﻿var KeyHandler = {
    tvKey : null,
    MainMenuAnchor : null,
    EpisodesAnchor : null,
    PlayerAnchor : null,
}

KeyHandler.create = function() {
    this.MainMenuAnchor  =  document.getElementById("MainMenu_Anchor");
    this.EpisodesAnchor  =  document.getElementById("Episodes_Anchor");
    this.PlayerAnchor =  document.getElementById("Player_Anchor");
    
	this.tvKey = new Common.API.TVKeyValue();
	
}

KeyHandler.setFocus = function(menuID) {  
  
    switch(menuID)
    {
		case Main.MainMenu_ID:
			this.MainMenuAnchor.focus();
			break;
		case Main.Episodes_ID:
			this.EpisodesAnchor.focus();
			break;
		case Main.Player_ID:
			this.PlayerAnchor.focus();
			break;
		default:
			alert("Unhandled key");
    }    
}

KeyHandler.MainMenuKeyDown = function()
{
    var keyCode0 = event.keyCode;

	switch(keyCode0)
    {    

		case this.tvKey.KEY_STOP:
            Audio.setVolume(10);
            break;
			
		case this.tvKey.KEY_FF:
            RUHD_XML_API.addToFav();
            break;
        
        case this.tvKey.KEY_RW:
            RUHD_XML_API.delFromFav();
            break;
			
		case this.tvKey.KEY_RED:
			RUHD_XML_API.sort(1);
			break;
			
		case this.tvKey.KEY_GREEN:
			RUHD_XML_API.sort(2);
			break;
		
		case this.tvKey.KEY_YELLOW:
			RUHD_XML_API.sort(7);
			break;
			
		case this.tvKey.KEY_BLUE:
			RUHD_XML_API.sort(8);
			break;
			
		case 147://KEY_INFOLINK
			widgetAPI.blockNavigation(event);
            break;
			
		case this.tvKey.KEY_DOWN:
			Main.selectNextItem();
			break;
            
        case this.tvKey.KEY_UP:
            Main.selectPrevItem();
            break;            

		case this.tvKey.KEY_LEFT:
            Main.selectPrevPage();
            break;
            
        case this.tvKey.KEY_RIGHT:
            Main.selectNextPage();
            break;

        case this.tvKey.KEY_VOL_UP:
            Audio.setRelativeVolume(0);
			Display.setVolume();
            break;
            
        case this.tvKey.KEY_VOL_DOWN:
            Audio.setRelativeVolume(1);
			Display.setVolume();
            break;
			
		case this.tvKey.KEY_MUTE:
			Audio.muteMode();
            break;
			
		case this.tvKey.KEY_TOOLS:
            Setup.setFormular();
            break;
			
		case this.tvKey.KEY_INFO:
			alert('INFo');
			Main.updateInfoSwicher();
            break;
	
		case this.tvKey.KEY_EXIT:
			widgetAPI.blockNavigation(event);
			Player.plugin.Stop();
			widgetAPI.sendReturnEvent();
            break;    
            break;

		case this.tvKey.KEY_PLAY:
			RUHD_XML_API.get_SSID('LOGOUT/');
			
			if(RUHD_XML_API.active_url == RUHD_XML_API.RUHD_URL)
			{
				RUHD_XML_API.active_url = RUHD_XML_API.RUSD_URL;
				widgetAPI.putInnerHTML(document.getElementById("def_mode"), 'RuHD');
				document.getElementById("logo").src= "img/rusd.png";
			}
			else
			{
				RUHD_XML_API.active_url = RUHD_XML_API.RUHD_URL;
				widgetAPI.putInnerHTML(document.getElementById("def_mode"), 'RuSD');
				document.getElementById("logo").src= "img/ruhd.png";
			}		
			Main.selected_item = 0;
			Main.selected_page = 0;
			RUHD_XML_API.get_SSID('');
			RUHD_XML_API.login();
			RUHD_XML_API.getAllSeries();
			Main.showSeries();
            break;
			
        case this.tvKey.KEY_ENTER:
			Main.showEpisodes();
            break;

	    case this.tvKey.KEY_RETURN:
			widgetAPI.blockNavigation(event);			
            break;
					
        default:
            alert("Unhandled key");
            break;
    }

}	

KeyHandler.EpisodesKeyDown = function()
{
	var keyCode1 = event.keyCode;
			
	switch(keyCode1)
    {
		case this.tvKey.KEY_DOWN:;
            Selectbox.selectNextItem();
            break;
            
        case this.tvKey.KEY_UP:
			Selectbox.selectPrevItem();
            break;   

		case this.tvKey.KEY_RIGHT:
            Selectbox.selectNextPage();
            break;
            
        case this.tvKey.KEY_LEFT:
			Selectbox.selectPrevPage();
            break;  			
			
        case this.tvKey.KEY_ENTER:
			Selectbox.SelectEpisode();
            break;
			
	    case this.tvKey.KEY_RETURN:
			widgetAPI.blockNavigation(event);
			Selectbox.selectbox_html.style.display="none";
			KeyHandler.setFocus(Main.MainMenu_ID);
			Main.MODE = Main.MainMenu_ID;
			break;
			
		case this.tvKey.KEY_GREEN:
			if(Main.MODE == Main.Player_ID)
			{
				KeyHandler.setFocus(Main.Player_ID);
				Selectbox.selectbox_html.style.display="none";
				Display.hidemenu();
				Display.showplayer();
			}
			break;
			
		default:
            alert("Unhandled key");
            break;
	}
}
	
KeyHandler.PlayerKeyDown = function()
{
	var keyCode2 = event.keyCode;
			
	switch(keyCode2)
    {
		case this.tvKey.KEY_RETURN:
			Main.MODE = Main.Player_ID;
			widgetAPI.blockNavigation(event);
			Selectbox.updateBox()
			KeyHandler.setFocus(Main.Episodes_ID);
			Display.hideplayer();
            Display.showmenu();
			break;

		 case this.tvKey.KEY_LEFT:
			Player.MinutesJump(-1);
            break;
            
        case this.tvKey.KEY_RIGHT:
			Player.MinutesJump(1);
            break; 
			
		case this.tvKey.KEY_DOWN:	
			Player.MinutesJump(-5);
            break;
			
		case this.tvKey.KEY_UP:
			Player.MinutesJump(5);
            break;

        case this.tvKey.KEY_FF:
            Player.MinutesJump(10);
            break;
        
        case this.tvKey.KEY_RW:
            Player.MinutesJump(-10);
            break;
			
        case this.tvKey.KEY_ENTER:
			Display.showplayer();
            break;

		case this.tvKey.KEY_PLAY:
			Player.resumeVideo();
            break;
            
         case this.tvKey.KEY_PAUSE:
			Player.pauseVideo();
			break;

        case this.tvKey.KEY_STOP:
			Player.stopVideo();
			break;
			
	    case this.tvKey.KEY_0:
			Player.PercentJump(0);
			Display.status("0%");
			break;
			
	    case this.tvKey.KEY_1:
			Player.PercentJump(1);
			break;
			
	    case this.tvKey.KEY_2:
			Player.PercentJump(2);
			break;
			
	    case this.tvKey.KEY_3:
			Player.PercentJump(3);
			break;
			
	    case this.tvKey.KEY_4:
			Player.PercentJump(4);
			break;
			
	    case this.tvKey.KEY_5:
			Player.PercentJump(5);
			break;
			
	    case this.tvKey.KEY_6:
			Player.PercentJump(6);
			break;
			
	    case this.tvKey.KEY_7:
			Player.PercentJump(7);
			break;
			
	    case this.tvKey.KEY_8:
			Player.PercentJump(8);
			break;
			
	    case this.tvKey.KEY_9:
			Player.PercentJump(9);
			break;
			
		case 147://KEY_INFOLINK
			widgetAPI.blockNavigation(event);
            break;

		case this.tvKey.KEY_TOOLS:
            widgetAPI.blockNavigation(event);
            pluginAPI.ShowTools(1);
            break;
			
		case 653://KEY_ASPECT
            if (Player.getSize()>=1)
                Player.setSize(0);
			else
				Player.setSize(Player.getSize()+1);
            break;
			
        case this.tvKey.KEY_VOL_UP:
            Audio.setRelativeVolume(0);
			Display.setVolume();
            break;
            
        case this.tvKey.KEY_VOL_DOWN:
            Audio.setRelativeVolume(1);
			Display.setVolume();
            break;
			
		case this.tvKey.KEY_EXIT:
			widgetAPI.blockNavigation(event);    
            break;
			
		case this.tvKey.KEY_MUTE:
			Audio.muteMode();
            break;
			
		default:
            alert("Unhandled key");
            break;
	}
}