﻿var widgetAPI = new Common.API.Widget();
var pluginAPI = new Common.API.Plugin();

var Main = {

    MODE : 0,
	MainMenu_ID : 0,
    Episodes_ID : 1,
    Player_ID : 2,
	selected_item: 0,
	selected_page: 0,
	active_menu_list : [],
	items_counter : 0,
	pages_counter : 0,
	last_page_items_counter : 0,
	selected_item_index : 0,
	info_mode : 0,
	XHRObj : null,
}

ConsoleLog = function (text) {

		var tm = new Date();
		var h = tm.getHours();
		var m = tm.getMinutes();
		var s = tm.getSeconds();
		var ms = tm.getMilliseconds();
		text = "[" + h + ":" + (m > 10 ? m : ("0" + m)) + ":" + (s > 10 ? s : ("0" + s)) + "," + ms + "] " + text;
		if (navigator.userAgent.search("Maple") > 0) 
		{
			alert(text);
		}
		if(navigator.userAgent.indexOf("Firefox")>-1&&window.console)
		{
			console.log(text);
		}	
		//xhr=new XMLHttpRequest();
		//xhr.open("POST", "http://192.168.178.1/?" + text, false);
		//xhr.send();			

}

function setWatchDog() {
	ConsoleLog("setWatchDog()");
	watchDog = new Common.API.Plugin();
}

function onWatchDog() {
	ConsoleLog("onWatchDog()");
	watchDog.setOnWatchDog();
}

function offWatchDog() {
	ConsoleLog("offWatchDog()");
	watchDog.setOffWatchDog();	
}

Main.onLoad = function () 
{
	
	setWatchDog();
	onWatchDog();
	KeyHandler.create();
	
	RUHD_XML_API.setStats();
    if (this.XHRObj != null) this.XHRObj.destroy(); 

	this.MODE = this.MainMenu_ID;
	Display.init();
	RUHD_XML_API.active_url = RUHD_XML_API.RUHD_URL;
	document.getElementById("statusbar").style.display="block";
	RUHD_XML_API.get_SSID('LOGOUT/');
	
	if(RUHD_XML_API.init() && RUHD_XML_API.login() && Player.init() && Audio.init() && Setup.init())
	{
		RUHD_XML_API.getAllSeries();
		Main.showSeries();	
	}
	
	
	KeyHandler.setFocus(this.MainMenu_ID);
	widgetAPI.sendReadyEvent();
}

Main.showEpisodes	= function ()
{
	RUHD_XML_API.getAllEpisodes();
	var episode_menu_list = RUHD_XML_API.Episodes;
	KeyHandler.setFocus(this.Episodes_ID);
	Selectbox.selected = 0;
	Player.url = Selectbox.setBox('выбор серии для просмотра', episode_menu_list);

}

Main.showSeries = function ()
{
	this.active_menu_list = RUHD_XML_API.Series;
	Main.countPages(RUHD_XML_API.Series);
	Main.updatePage();
	Main.updateItem();
}

Main.countPages	= function (series_list)
{
	this.items_counter = series_list.length;

	this.last_page_items_counter = this.items_counter % 10;
	if(this.last_page_items_counter==0)
		this.last_page_items_counter = 10;
	
	if ( this.last_page_items_counter > 0 && this.last_page_items_counter < 5)
		this.pages_counter = Math.round(this.items_counter / 10) + 1;
	else
		this.pages_counter = Math.round(this.items_counter / 10);
}

Main.updatePage = function()
{	
	KeyHandler.setFocus(this.MainMenu_ID);
	var chan = Array();
	var time = 0;
	var items_on_page = 10;

	if(this.selected_page > this.pages_counter-1)
		this.selected_page = 0;
		
	if(this.selected_page < 0)
		this.selected_page = this.pages_counter-1;
	
	for (var index = 0; index < 10; index++)
		{
			document.getElementById("ch"+index).style.display="";
			widgetAPI.putInnerHTML(document.getElementById("title"+index), "");
			widgetAPI.putInnerHTML(document.getElementById("descr"+index), "");
			document.getElementById("time"+index).style.backgroundImage= "url(img/nostar.png)";
			document.getElementById("descr"+index).style.display="";
			document.getElementById("title"+index).style.width= "160px";
			document.getElementById("number"+index).style = "";
		}
	
	if(this.selected_page == this.pages_counter-1)
	{
		items_on_page = this.last_page_items_counter;
		
		    for (var index = items_on_page; index < 10; index++)
			{
				document.getElementById("ch"+index).style.display="none";
			}
			
		if(this.selected_item > this.last_page_items_counter-1)
			this.selected_item = this.last_page_items_counter-1;
	}

    //Array(id_series, title, etitle, info, fpimg, pimg, mark, pos, favorite);
	for (var index = 0; index < items_on_page; index++)
    {
		var item_array_index = 10*this.selected_page + index;
		
		chan[index] = document.getElementById("chan"+index);
		chan[index].style.backgroundImage= "url(img/menu.png)";
		
		if(this.active_menu_list[item_array_index][8])
			document.getElementById("time"+index).style.backgroundImage= "url(img/star.png)";
		
		widgetAPI.putInnerHTML(document.getElementById("number"+index), item_array_index+1);
		document.getElementById("img"+index).src=RUHD_XML_API.active_url + this.active_menu_list[item_array_index][4];
        
        widgetAPI.putInnerHTML(document.getElementById("title"+index), this.active_menu_list[item_array_index][1]);
		widgetAPI.putInnerHTML(document.getElementById("descr"+index), this.active_menu_list[item_array_index][2]);

    }

}

Main.updateItem = function()
{
	for (var index = 0; index < 10; index++)
	{
		document.getElementById("chan"+index).style.backgroundImage= "url(img/menu.png)";
		document.getElementById("number"+index).style.backgroundImage = "";
	}
	
	this.selected_item_index = 10*this.selected_page + this.selected_item;
    document.getElementById("number"+this.selected_item).style.backgroundImage= "url(img/menu_act.png)";
	document.getElementById("chan"+this.selected_item).style.backgroundImage= "url(img/menu_act.png)";
	
	//update player
	document.getElementById("ch_arch").src=RUHD_XML_API.active_url + this.active_menu_list[this.selected_item_index][4];
	document.getElementById("ch_arch").width="35px";
	var title = this.active_menu_list[this.selected_item_index][1] + ' (' + this.active_menu_list[this.selected_item_index][2] + ')';
	widgetAPI.putInnerHTML(document.getElementById("ch_number"), this.selected_item_index+1);
	widgetAPI.putInnerHTML(document.getElementById("ch_name"), title);
	
	if(this.info_mode==1)
	{
		this.info_mode=0;
		Main.updateInfoSwicher();
	}
	else
		Main.updateInfo();
}

Main.updateInfo = function()
{		
	var item_array_index = this.selected_item_index;
	widgetAPI.putInnerHTML(document.getElementById("infoList"), "");
	var info = this.active_menu_list[item_array_index][3];
	var fpimg = RUHD_XML_API.active_url + this.active_menu_list[item_array_index][4];
	if(RUHD_XML_API.active_url == RUHD_XML_API.RUHD_URL)
		var width='width:300px;';
	else
		var width='width:100px;';
	var inform = '<div style="float:left;padding-bottom:6px;"><img style="' + width + '" src="'+fpimg+'"></div><br><span  style="float:left;">'+info+'</span></div>';
	widgetAPI.putInnerHTML(document.getElementById("infoList"), inform);

}

Main.updateInfoSwicher = function()
{
	if(this.info_mode==0)
	{
		this.info_mode = 1;
		var item_array_index = this.selected_item_index;
		document.getElementById("vod_info_button").style.display="none";
		document.getElementById("vod_back_button").style.display="";
		document.getElementById("vod_info").style.display="";
		var title = this.active_menu_list[item_array_index][1];
		var etitle = this.active_menu_list[item_array_index][2];
		var info = this.active_menu_list[item_array_index][3];
		var pimg = RUHD_XML_API.active_url + this.active_menu_list[item_array_index][5];
		
		var info_full = '<h3>' + title + ' - ' + etitle + '</h3>' + info;
		widgetAPI.putInnerHTML(document.getElementById("vod_info"), info_full);

		
		var inform = '<div style="float:left;padding-top:8px;height:436px;overflow:hidden;"><img style="width:300px;" src="'+pimg+'"></div></div>';
		widgetAPI.putInnerHTML(document.getElementById("infoList"), inform);
	}
	else
	{
		this.info_mode = 0;
		document.getElementById("vod_back_button").style.display="none";
		document.getElementById("vod_info").style.display="none";
		document.getElementById("vod_info_button").style.display="";
		Main.updateInfo();
	}
}

Main.selectNextItem = function()
{
	this.selected_item++;
	if(this.selected_item>=10 || (this.selected_page == this.pages_counter-1 && this.selected_item==this.last_page_items_counter))
	{
		this.selected_item = 0;
		this.selected_page++;
		Main.updatePage();
	}

	Main.updateItem();

}

Main.selectPrevItem = function()
{
	this.selected_item--;
	
	if(this.selected_page == 0 && this.selected_item<0)
	{
		this.selected_item = this.last_page_items_counter - 1;
		this.selected_page = this.pages_counter-1;
		Main.updatePage();
	}
	
	if(this.selected_item<0)
	{
		this.selected_item = 9;
		this.selected_page--;
		Main.updatePage();
		
	}
	
	Main.updateItem();
}

Main.selectNextPage = function()
{
	this.selected_page++;
	Main.updatePage();
	Main.updateItem();
}

Main.selectPrevPage = function()
{
	this.selected_page--;
	Main.updatePage();
	Main.updateItem();
}

Main.playVideo = function()
{	
	
	if(Player.state == Player.PLAYING_VOD)
	{
		Player.stopVideo();
	}
	if(Player.state == Player.PAUSA_VOD)
	{
		Player.stopVideo();
	}
	
	if (Player.url == null)
    {
        alert("No videos to play");
    }
    else
    {
        alert(Player.url);
        Player.playVideo( Player.url );
        Audio.plugin.SetSystemMute(false); 
    }
	
	Display.status('EPISODE START');
	Player.plugin.SetDisplayArea(0, 0, 960, 540);
	Main.UpdatePlayerStatusbar();
	KeyHandler.setFocus(Main.Player_ID);
	Display.hidemenu();
	Display.showplayer();
}

Main.UpdatePlayerStatusbar = function()
{
	document.getElementById("ch_percent").style.width="0%";
	widgetAPI.putInnerHTML(document.getElementById("time"), Main.secToStr(Player.vod_current_time/1000));
	var elapsed_time_percent = parseInt(Player.vod_current_time/ Player.vod_one_percent);
	var time_left = parseInt((Player.vod_duration - Player.vod_current_time)/60000);
	
	if(elapsed_time_percent>100)
		elapsed_time_percent = 100;
	document.getElementById("ch_percent").style.width=elapsed_time_percent+"%";
	widgetAPI.putInnerHTML(document.getElementById("pr1_time_left"), "+" + time_left + "мин");
	widgetAPI.putInnerHTML(document.getElementById("pr2_name"), "Продолжительность " + parseInt(Player.vod_duration/60000) + " мин.");
}

Main.secToStr =function(sec)
{
   sec = parseInt(sec);
   minuten = parseInt(sec/60);
   sec = sec%60;
   stunden = parseInt(minuten/60);
   minuten = minuten%60;
   return (stunden > 10 ? stunden : ("0" + stunden)) + ":" + (minuten > 10 ? minuten : ("0" + minuten)) + ":" + (sec > 10 ? sec : ("0" + sec));
   
}

Main.onUnload = function()
{
   offWatchDog();
   Audio.setVolume(10);
   Player.deinit();
}