﻿var Player =
{
    selected_channel: 0,
	selected_page: 0,
	chan_array_index: 0,
	plugin : null,
	mwPlugin: null,
    state : -1,
    skipState : -1,
    stopCallback : null,    /* Callback function to be set by client */
    originalSource : null,
    size: 0,
    STOPPED : 0,
	PLAYING_VOD : 1,
	PAUSA_VOD : 2,
	counter : 0,
	timer : null,
	timer_is_on : 0,
	current_time : 0,
	vod_duration : 0,
	vod_one_percent : 0,
	vod_current_time : 0
}

Player.init = function()
{
    var success = true;
    
    this.state = this.STOPPED;
    
    this.plugin = document.getElementById("pluginPlayer");
    
    if (!this.plugin)
    {
         success = false;
    }

	this.mwPlugin = document.getElementById("pluginObjectTVMW");
	if (!this.mwPlugin || !this.mwPlugin.GetSource) 
	{
		alert("Failed to init player: plugin TVMW not found.");
		success = false;
	} 
	else 
	{
		this.originalSource = this.mwPlugin.GetSource();
		this.mwPlugin.SetMediaSource();
	}

		
	this.plugin.OnBufferingStart = 'Player.onBufferingStart';
    this.plugin.OnBufferingProgress = 'Player.onBufferingProgress';
    this.plugin.OnBufferingComplete = 'Player.onBufferingComplete';
	this.plugin.OnCurrentPlayTime = 'Player.vodCurrentTime';
            
    return success;
}

Player.deinit = function()
{
	if(this.state)
		this.stopVideo();
	alert("Player deinit !!! " ); 
	if(this.mwPlugin != null)
		this.mwPlugin.SetMediaSource(this.originalSource);
	
	if (this.plugin)
	{
		this.plugin.Stop();
	}
}

Player.setVideoURL = function(url)
{
    this.url = url;
    alert("URL = " + this.url);
}

Player.playVideo = function()
{	

	if(this.state == this.PLAYING_VOD)
		this.stopVideo();

	if (this.url == null)
    {
        alert("No videos to play");
    }
    else
    {
        this.state = this.PLAYING_VOD;
        this.plugin.Play( this.url );
		pluginAPI.setOffScreenSaver();
        Audio.plugin.SetSystemMute(false); 
    }

}

Player.stopVideo = function()
{

	Display.status("Stop");
	if (this.state != this.STOPPED)
    {
        this.state = this.STOPPED;
        Display.status("Stop");
        this.plugin.Stop();
        
    }
    else
    {
        alert("Ignoring stop request, not in correct state");
    }
}

Player.getState = function()
{
    return this.state;
}

// Global functions called directly by the player 

Player.onBufferingStart = function()
{
    Display.status("Buffering...");
	alert("Buffering...");
}

Player.onBufferingProgress = function(percent)
{
    Display.status("Buffering:" + percent + "%");
	alert("Buffering:" + percent + "%");
}

Player.onBufferingComplete = function()
{
	Display.status("Buffering Complete");
	Player.ShowResolution();
	alert("Buffering Complete");
}

onServerError = function()
{
    Display.status("Server Error!");
}

OnNetworkDisconnected = function()
{
    Display.status("Network Error!");
}

getBandwidth = function(bandwidth) { alert("getBandwidth " + bandwidth); }

onDecoderReady = function() { alert("onDecoderReady"); }

onRenderError = function() { alert("onRenderError"); }

stopPlayer = function()
{
    Player.stopVideo();
}

Player.ShowResolution = function()
{
	alert('aaaaaaaaaaaaaaaaaa' + this.plugin.SetTotalBufferSize(5000));
	var h=this.plugin.GetVideoHeight();
	var w=this.plugin.GetVideoWidth();
	var res = "<center>" + w + "X" + h + "</center>";
	//Display.status(res);
	widgetAPI.putInnerHTML(document.getElementById("resolution"), res);
			
}			
setTottalBuffer = function(buffer) { alert("setTottalBuffer " + buffer); }

setCurBuffer = function(buffer) { alert("setCurBuffer " + buffer); }

Player.setSize=function(mode)
    {
        if (this.state != this.STOPPED)
        {
            this.size=mode;
            var h=this.plugin.GetVideoHeight();
            var w=this.plugin.GetVideoWidth();
        
            switch(mode)
			{
				case 0 :
					//[4x3]
					if(w<=720)
					this.plugin.SetDisplayArea(120,0,720,540);
					break;
	   
				case 1 :
					//[16x9]
					this.plugin.SetDisplayArea(0, 0, 960, 540);
					break;
			}
        }
    }

Player.getSize=function() {return this.size;}

Player.vodCurrentTime = function(time)
{
	if(this.state == this.PLAYING_VOD)
	{
		this.vod_current_time = parseInt(time);
		this.vod_duration = Player.plugin.GetDuration();
		this.vod_one_percent = parseInt(this.vod_duration/100);
		Main.UpdatePlayerStatusbar();
		if(this.vod_current_time>this.vod_duration-2000)
			Player.showSelectbox();
	}

}

Player.MinutesJump = function(minutes) 
{
	var sign = "";
	if(minutes>0)
		var sign = "+";
	this.statusmessage =sign + minutes + " мин.";
	if (minutes > 0) {
		this.plugin.JumpForward(minutes*60);    
	} else if (minutes < 0) {
		this.plugin.JumpBackward(minutes*60*-1);
	}
	Display.status(this.statusmessage);
}

Player.PercentJump = function(percent) 
{
	this.statusmessage = percent*10 + "%";
	var jump_time = 0;
	if(percent)
		jump_time = parseInt((this.vod_current_time + this.vod_one_percent*percent*10)/1000);
	
	var now_percent = parseInt(this.vod_current_time/this.vod_one_percent);
	var jump_to_percent = percent*10 - now_percent;
	var jump_to_minutes = (this.vod_one_percent*jump_to_percent)/1000;
	
	if (jump_to_minutes > 0) {
		this.plugin.JumpForward(jump_to_minutes);    
	} else if (jump_to_minutes < 0) {
		this.plugin.JumpBackward(jump_to_minutes*-1);
	}
	Display.status(this.statusmessage);
}

Player.resumeVideo = function()
{
	if (this.state != this.STOPPED)
	{
		this.state = this.PLAYING_VOD;
		this.plugin.Resume();
		document.getElementById("vod_pause").style.display="";
		document.getElementById("vod_play").style.display="none";
		Display.status('воспроизведение');
	}
	else
	{
		Player.playVideo();
	}
}

Player.pauseVideo = function()
{
	if (this.state != this.STOPPED)
	{
		this.state = this.PAUSA_VOD;
		this.plugin.Pause();
		document.getElementById("vod_pause").style.display="none";
		document.getElementById("vod_play").style.display="";
		document.getElementById("statusbar").style.display="";
		widgetAPI.putInnerHTML(Display.statusDiv, "ПАУЗА");
	}
}

Player.showSelectbox = function()
{
	Display.status("КОНЕЦ СЕРИИ");
	Main.MODE = Main.Player_ID;
	Selectbox.updateBox()
	KeyHandler.setFocus(Main.Episodes_ID);
	Display.hideplayer();
	Display.showmenu();
}