/*
 About: Author
 Tomasz Scislo
 About: Date
 2010-10-26
 */
/*
 * Class: CSSModification
 *
 * Class which implements possibility to change css images backgrounds for given DOM element.
 * This class MUST be used for all DOM elements with backgrounds. The reason for this is to change background url
 * because of 5 graphical widget versions.
 *
 * How to define new DOM element with background in widget:
 * 1. Create class in css file with background path: ../../images/background_img.jpg Keep in mind that there is no subdirectory
 * name in images folder, it was intended.
 * 
 * 2. In initialize scene method execute changeBackground method of this object. Two parameters are described below.
 * 
 * 3. If DOM element in a scene has to change it's background dynamicly use .css() jQuery method and don't change class.
 *
 *
 * This different background handling in widget was developed because widget has to work in 5 development layouts, which developer
 * have the possibility to change quicly and in production layout with no images subdirectories.
 */
CSSModification = function(){

    this.log = function(msg){
        alert(">>>>>>>>> CSSModification: " + msg);
    };
    
    if (graphicsDirectory == "") {
        this.log("graphicsDirectory empty -> no changes in CSS");
        this.changeCSS = false;
    }
    else {
        this.log('graphicsDirectory: ' + graphicsDirectory + " -> changing CSS");
        this.changeCSS = true;
    }
    
    /*
     * Function: changeBackground
     *
     * Method changes DOMElement background. DOMElement must exist in DOM.
     *
     * Parameters:
     * DOMElement - jQuery element selector
     * 
     * add - (string) which can be added to background style, after url
     *
     */
    this.changeBackground = function(DOMElement, add){
        try {
            if (this.changeCSS) {
                if ($(DOMElement).length == 0) {
                    throw new Error("No " + DOMElement + " in document! Unable to change background!");
                }
                var bgImage = $(DOMElement).css('backgroundImage');
                
                regExp = new RegExp('images.*');
                var path = bgImage.match(regExp);
                if (path == null) 
                    throw new Error("Unable to parse path for " + DOMElement);
                
                if (bgImage.match(/url.*/)) {
                    this.log("Changing bg with url()");
                    var reg = 'images/.*/(.*)\\)';
                }
                else 
                    var reg = 'images/(.*)';
                
                regExp = new RegExp(reg);
                path = path.toString().replace(regExp, "$1");
                if (path == null) 
                    throw new Error("Unable to parse path for " + DOMElement);
                
                var newPath = "images/" + graphicsDirectory + path;
                
                if (typeof add === "undefined") 
                    add = "";
                
                $(DOMElement).css('background', ' url(' + newPath + ') ' + add);
                this.log("Background change done for: " + DOMElement + " " + newPath);
            }
        } 
        catch (e) {
            this.log(e.message);
        }
    };
    
};
