/*
 About: Author
 Tomasz Scislo
 About: Date
 2010-10-04
 */
/*
 * Function: getImageSize
 *
 * CImageViewer object extenstion to get image size.
 *
 */
CImageViewer.prototype.getImageSize = function(){
    var eIVPlugin = document.getElementById("pluginObjectImageViewer");
    if (typeof eIVPlugin !== 'undefined') 
        if (eIVPlugin.GetVideoWidth() == 0 || eIVPlugin.GetVideoHeight() == 0) 
            return null;
        else 
            return eIVPlugin.GetVideoWidth() + "x" + eIVPlugin.GetVideoHeight();
    else 
        return null;
}

/*
 * Function: getImageWidth
 *
 * CImageViewer object extenstion to get image width.
 *
 */
CImageViewer.prototype.getImageWidth = function(){
    var eIVPlugin = document.getElementById("pluginObjectImageViewer");
    if (typeof eIVPlugin !== 'undefined') 
        return eIVPlugin.GetVideoWidth();
    else 
        return null;
}

/*
 * Function: getImageHeight
 *
 * CImageViewer object extenstion to get image height.
 *
 */
CImageViewer.prototype.getImageHeight = function(){
    var eIVPlugin = document.getElementById("pluginObjectImageViewer");
    if (typeof eIVPlugin !== 'undefined') 
        return eIVPlugin.GetVideoHeight();
    else 
        return null;
}

/*
 * Class: NGImageViewer
 *
 * Class which implements Slide Show support using Samsung CImage Viewer
 *
 *  Properties:
 *
 *  maxWidth - max image widht in px in Details Mode
 *
 *  maxHeight - max image height in px in Details Mode
 *
 *  images - array of json items with images details
 *
 *  effectNames - array of transition effects names
 *  
 *  effectMapping - array of objects which allowes to map effect name with its number from CImage Viewer
 *
 *  timeoutList - array of timeouts given in msec
 *
 *  idx - number indicating current image id from images array
 *
 *  timeOutId - number indicating current timeOut from timeoutList
 *
 *  timeoutNames - names indicating Slide show speed
 *
 *  transitionId - number indicating which transition effect was selected from effectsNames
 *
 *  marked - boolean indicating if markAll method sholud mark all elements or no
 *
 *  block - boolean block=true when transition can't be made, block=false if you can make a transition
 *
 *  fpause - boolean pause=true the animation was paused by user
 *
 *  fshowSlideShowAgain - boolean, if true runs show method of CImage Viewer object after rendering complete. Needed for DetailPage scene
 *
 *  fallInactive - boolean, when true all images are inactive. If so SlideShow works, like if all were set active
 *
 *  supportedEffects - boolean, true if DTV supports transition effects
 *
 *  NGSkinDirectory - string, Skin directory name (pictures location)
 *
 *  imgPlayPauseElement - one of DOM elements for showing current animation state
 *
 *  divStateElement - one of DOM elements for showing current animation state
 *
 * 	divPicName - one of DOM elements for showing current animation state
 *
 *  divResName - one of DOM elements for showing current animation state
 *
 *  divDateName - one of DOM elements for showing current animation state
 *
 *  divimagesCountName - one of DOM elements for showing current animation state
 *
 */
NGImageViewer = {

    maxWidth: 800,
    
    maxHeight: 600,
    
    // json Image array
    images: Array(),
    
	effectNames: ['NONE', 'FADE1', 'FADE2', 'BLIND', 'SPIRAL', 'CHECKER', 'LINEAR', 'STAIRS', 'WIPE', 'RANDOM'],
	
    effectMapping: {
		NONE : -2,
		FADE1: 0,
		FADE2: 1,
		BLIND: 2,
		SPIRAL: 3,
		CHECKER: 4,
		LINEAR: 5,
		STAIRS: 6,
		WIPE: 7,
		RANDOM: 8,
	},
    
    timeoutList: [10000, 5000, 3000],
    
    timeoutNames: ['Slow', 'Normal', 'Fast'],
    
    ImageViewer: new CImageViewer('Common ImageViewer'),
    
    // Current image id, Start idx always -1
    idx: -1,
    
    // current time between transitions from timeoutList
    timeOutId: 0,
    
    //selected transition
    transitionId: 0,
    
    //variable indicating if markAll method sholud mark all elements or no
    marked: false,
    
    // block=true when transition is in progress block=false if you can make a transition
    block: false,
    
    // pause=true the animation paused by user
    fpause: false,
    
    // fallInactive = true then all images are inactive
    fallInactive: false,
    
    //if true runs show method of CImage Viewer object after rendering complete. Needed for DetailPage scene
    fshowSlideShowAgain: false,
    
    // true if DTV supports transition effects
    supportedEffects: true,
    
    // Skin directory name (pictures location)
    NGSkinDirectory: graphicsDirectory,
    
    // DOM elements for showing current animation state
    imgPlayPauseElement: 'PlayPause',
    divStateElement: 'State',
    divPicName: 'PicName',
    divResName: 'Res',
    divDateName: 'Date',
    divimagesCountName: 'imagesCount'
};

/*
 * Function: markAll
 *
 * Marks all images in array as active or inactive
 *
 * Parameters:
 *
 *
 * Returns:
 * undefined
 */
NGImageViewer.markAll = function(){
    NGImageViewer.log("markAll");
    for (var i = 0; i < NGImageViewer.images.length; i++) {
        NGImageViewer.images[i].active = this.marked;
    }
    this.marked = !this.marked;
}

/*
 * Function: removeWidgetFromPath
 *
 * Removes from path '$WIDGET/'
 *
 * Parameters:
 *
 * path - input string
 *
 * Returns:
 * string
 */
NGImageViewer.removeWidgetFromPath = function(path){
    return path.replace('$WIDGET/', '');
};

/*
 * Function: generateSelecionHTML
 *
 * Prepares XHTML for PhotoSelection scene
 *
 * Parameters:
 *
 *
 * Returns:
 * XHTML for PhotoSelection scene
 */
NGImageViewer.generateSelecionHTML = function(){
    NGImageViewer.log("generateSelecionHTML");
    var tmpDom = "", tmpArr = Array();
    for (var i = 0; i < this.images.length; i++) {
        tmpDom = "";
        tmpDom += '<div class="SelectionContainer"><div  style="position:relative;top:0px;left:0px;" id="Pic' + i + '" class="frame">';
        tmpDom += '<div class="checkbox" style="background:url(images/' + this.NGSkinDirectory + 'checkbox.png)">' + ((this.images[i].active) ? '<img style="width:25px;" src="images/' + this.NGSkinDirectory + 'check_mark.png"  />' : '') + '</div>';
        tmpDom += '<img src="' + this.images[i].msrc + '" style="absolute:relative;top:0px;left:0px;"/>';
        tmpDom += '</div></div>';
        tmpArr[i] = tmpDom;
    }
    return tmpArr;
};

/*
 * Function: getCurrentPicture
 *
 * Returns current image JSON
 *
 * Parameters:
 *
 *
 * Returns:
 * JSON with image details
 */
NGImageViewer.getCurrentPicture = function(){
    NGImageViewer.log("getCurrentPicture");
    return this.images[this.idx];
};

/*
 * Function: secTimeList
 *
 * Transforms timeoutList in msec into array in sec
 *
 * Parameters:
 *
 *
 * Returns:
 * numbers array
 */
NGImageViewer.secTimeList = function(){
    var tmpArr = Array();
    for (var i = 0; i < this.timeoutList.length; i++) {
        tmpArr[i] = (this.timeoutList[i] / 1000).toString() + " sec";
    }
    return tmpArr;
};

/*
 * Function: shortenTxt
 *
 * Cuts input string to 17 chars and adds '...'
 *
 * Parameters:
 *
 * txt - input string
 *
 * Returns:
 * string
 */
NGImageViewer.shortenTxt = function(txt){
    if (txt.length > 17) 
        return (txt.slice(0, 17) + '...');
    else 
        return txt;
};

/*
 * Function: log
 *
 * Logs input string on console, uses alert()
 *
 * Parameters:
 *
 * msg - input string
 *
 * Returns:
 */
NGImageViewer.log = function(msg){
    alert(">>>>>NGImageViewer " + msg);
};

/*
 * Function: pauseResume
 *
 * Changes fpause flag
 *
 * Parameters:
 *
 *
 * Returns:
 */
NGImageViewer.pauseResume = function(){
    NGImageViewer.log("pauseResume");
    NGImageViewer.fpause = !NGImageViewer.fpause;
    $('#' + this.imgPlayPauseElement).css('background', 'url(images/' + this.NGSkinDirectory + 'slideshow_top_' + ((NGImageViewer.fpause) ? 'pause' : 'play') + '.png)');
};

/*
 * Function: pause
 *
 * Changes fpause flag to true
 *
 * Parameters:
 *
 *
 * Returns:
 */
NGImageViewer.pause = function(){
    NGImageViewer.log("pause");
    NGImageViewer.fpause = true;
    $('#' + this.imgPlayPauseElement).css('background', 'url(images/' + this.NGSkinDirectory + 'slideshow_top_pause.png)');
};

/*
 * Function: resume
 *
 * Changes fpause flag to false
 *
 * Parameters:
 *
 *
 * Returns:
 */
NGImageViewer.resume = function(){
    NGImageViewer.log("resume");
    NGImageViewer.fpause = false;
    $('#' + this.imgPlayPauseElement).css('background', 'url(images/' + this.NGSkinDirectory + 'slideshow_top_play.png)');
};

/*
 * Function: updateImageInfo
 *
 * Updates top DOM elements with information about current image
 *
 * Parameters:
 *
 *
 * Returns:
 */
NGImageViewer.updateImageInfo = function(){
    NGImageViewer.log("updateImageInfo");
    var imgSize = this.ImageViewer.getImageSize();
    if (imgSize) 
        $('#' + NGImageViewer.divResName).html(imgSize);
    $('#' + NGImageViewer.divimagesCountName).html(NGImageViewer.shortenTxt((NGImageViewer.idx + 1).toString() + '/' + NGImageViewer.images.length));
};


/*
 * Function: incPicturePointer
 *
 * Increments image idx by one
 *
 * Parameters:
 *
 *
 * Returns:
 */
NGImageViewer.incPicturePointer = function(type){
    NGImageViewer.log("incPicturePointer");
    NGImageViewer.idx++;
    NGImageViewer.idx %= NGImageViewer.images.length;
};

/*
 * Function: decPicturePointer
 *
 * Decrements image idx by one
 *
 * Parameters:
 *
 *
 * Returns:
 */
NGImageViewer.decPicturePointer = function(type){
    NGImageViewer.log("decPicturePointer");
    NGImageViewer.idx--;
    NGImageViewer.idx %= NGImageViewer.images.length;
    if (NGImageViewer.idx < 0) 
        NGImageViewer.idx = NGImageViewer.images.length - 1;
};

/*
 * Function: AllInActive
 *
 * Checks if all images are in inactive state. Returns true if they are.
 *
 * Parameters:
 *
 *
 * Returns:
 * boolean - true if all inactive
 */
NGImageViewer.AllInActive = function(){
    var allInactive = true;
    for (var i = 0; i < this.images.length; i++) {
        if (this.images[i].active) 
            allInactive = false;
    }
    return allInactive;
}

/*
 * Function: updateMaxWidhtHeight
 *
 * Updates max image Widht and Height for images used in DetailPage.
 *
 * Parameters:
 *
 *
 * Returns:
 */
NGImageViewer.updateMaxWidhtHeight = function(){
    NGImageViewer.log("updateMaxWidhtHeight");
//    if (this.ImageViewer.getImageWidth() > this.maxWidth) 
//        this.maxWidth = this.ImageViewer.getImageWidth();
//    if (this.ImageViewer.getImageHeight() > this.maxHeight) 
//        this.maxHeight = this.ImageViewer.getImageHeight();
}

/*
 * Function: picturePointerAction
 *
 * Increments or decrements image idx. Skips inactive images.
 *
 * Parameters:
 * type - boolean, if true than pointer is incremented otherwise decremented
 *
 * Returns:
 * boolean
 */
NGImageViewer.picturePointerAction = function(type){
    NGImageViewer.log("picturePointerAction");
    if (type) 
        NGImageViewer.incPicturePointer();
    else 
        NGImageViewer.decPicturePointer();
    // if next picture is active or if all pictures are inactive than recursion
    if (!this.images[this.idx].active && !this.fallInactive) 
        NGImageViewer.picturePointerAction(type);
    NGImageViewer.updateMaxWidhtHeight();
    return true;
};

/*
 * Function: nextOnlyCounter
 *
 * Increments idx and updates image info. Method used in DetailImage scene
 *
 * Parameters:
 *
 * Returns:
 */
NGImageViewer.nextOnlyCounter = function(){
    NGImageViewer.log("nextOnlyCounter");
    NGImageViewer.picturePointerAction(true);
    $('#loaderD').sfLoading('show');
    NGImageViewer.ImageViewer.hide();
    NGImageViewer.updateImageInfo();
    this.ImageViewer.play(this.images[this.idx].src, this.maxWidth, this.maxHeight);
};

/*
 * Function: prevOnlyCounter
 *
 * Decrements idx and updates image info. Method used in DetailImage scene
 *
 * Parameters:
 *
 * Returns:
 */
NGImageViewer.prevOnlyCounter = function(){
    NGImageViewer.log("prevOnlyCounter");
    NGImageViewer.picturePointerAction(false);
    $('#loaderD').sfLoading('show');
    NGImageViewer.ImageViewer.hide();
    NGImageViewer.updateImageInfo();
    this.ImageViewer.play(this.images[this.idx].src, this.maxWidth, this.maxHeight);
};

/*
 * Function: next
 *
 * Increments idx, updates image info, and loads next image in CImage Transition.
 *
 * Parameters:
 *
 * remoteForward - boolean, if set to true than doesn't take into account fpause flag
 *
 * Returns:
 */
NGImageViewer.next = function(remoteForward){
    NGImageViewer.log("next");
    if (!NGImageViewer.allowTransition(remoteForward)) 
        return true;
    NGImageViewer.block = true;
    NGImageViewer.picturePointerAction(true);
    NGImageViewer.loadImg();
};

/*
 * Function: allowTransition
 *
 * Checks if transition is possible, checks fpause flag and block flag state.
 *
 * Parameters:
 *
 * remoteForward - boolean, if set to true than doesn't take into account block flag
 *
 * Returns:
 * boolean - true if allows transition
 */
NGImageViewer.allowTransition = function(remoteForward){
    NGImageViewer.log("allowTransition");
    if (NGImageViewer.block) {
        NGImageViewer.log("transition blocked");
        return false;
    }
    else 
        if (NGImageViewer.fpause && !remoteForward) {
            NGImageViewer.log("transition paused");
            return false;
        }
    return true;
};

/*
 * Function: prev
 *
 * Decrements idx, updates image info, and loads prev image in CImage Transition.
 *
 * Parameters:
 *
 * remotePrev - boolean, if set to true than doesn't take into account fpause flag
 *
 * Returns:
 */
NGImageViewer.prev = function(remotePrev){
    NGImageViewer.log("prev");
    if (!NGImageViewer.allowTransition(remotePrev)) 
        return true;
    NGImageViewer.block = true;
    NGImageViewer.picturePointerAction(false);
    NGImageViewer.loadImg();
};

/*
 * Function: loadImg
 *
 * Loads current image from array in CImage Viewer
 *
 * Parameters:
 *
 *
 * Returns:
 */
NGImageViewer.loadImg = function(){
    //$('#loader').sfLoading('show');
    this.ImageViewer.prepareNext(this.images[this.idx].src, this.transitionId);
    this.ImageViewer.showNow();
};


/*
 * Function: cleanUp
 *
 * On unload event this method destroys CImage Viewer object which is required for propper TV operations
 *
 * Parameters:
 *
 *
 * Returns:
 */
NGImageViewer.cleanUp = function(){
    NGImageViewer.log('cleanUp');
    NGImageViewer.stopAnimation();
    NGImageViewer.ImageViewer.endSlideshow();
    NGImageViewer.ImageViewer.destroy();
};

/*
 * Function: hide
 *
 * Hides CImage Viewer DOM elements and stops the slide show
 *
 * Parameters:
 *
 *
 * Returns:
 */
NGImageViewer.hide = function(){
    NGImageViewer.log('hide');
    NGImageViewer.stopAnimation();
    NGImageViewer.ImageViewer.stop();
    NGImageViewer.ImageViewer.clearScreen();
    this.ImageViewer.hide();
};

/*
 * Function: endSlideShow
 *
 * Ends slideshow mode (transitions OFF), changes display size area and shows DOM element
 *
 * Parameters:
 *
 *
 * Returns:
 */
NGImageViewer.endSlideShow = function(){
    NGImageViewer.log('endSlideShow');
    NGImageViewer.ImageViewer.endSlideshow();
    NGImageViewer.ImageViewer.setFrameArea(98, 137, 413, 305);
    NGImageViewer.ImageViewer.play(NGImageViewer.images[NGImageViewer.idx].src, this.maxWidth, this.maxHeight);
};

/*
 * Function: returnToSlideShow
 *
 * Returns to slideshow mode
 *
 * Parameters:
 *
 *
 * Returns:
 */
NGImageViewer.returnToSlideShow = function(){
    NGImageViewer.log('returnToSlideShow');
    NGImageViewer.ImageViewer.stop();
    NGImageViewer.ImageViewer.clearScreen();
    NGImageViewer.ImageViewer.startSlideshow();
    NGImageViewer.ImageViewer.setFrameArea(0, 0, 960, 540);
    NGImageViewer.ImageViewer.show();
    NGImageViewer.ImageViewer.play(NGImageViewer.images[NGImageViewer.idx].src, 1290, 1080);
};

/*
 * Function: startAnimation
 *
 * Starts animation
 *
 * Parameters:
 *
 *
 * Returns:
 */
NGImageViewer.startAnimation = function(){
    NGImageViewer.log('startAnimation');
    NGImageViewer.intervalPtr = setInterval(NGImageViewer.next, NGImageViewer.timeoutList[NGImageViewer.timeOutId]);
};

/*
 * Function: stopAnimation
 *
 * Stops animation
 *
 * Parameters:
 *
 *
 * Returns:
 */
NGImageViewer.stopAnimation = function(){
    NGImageViewer.log('stopAnimation');
    if (NGImageViewer.intervalPtr) 
        clearInterval(NGImageViewer.intervalPtr);
};

/*
 * Function: FF
 *
 * Changes current transition into slower by incrementing transitionId pointer
 *
 * Parameters:
 *
 *
 * Returns:
 */
NGImageViewer.FF = function(){
    NGImageViewer.log('FF');
    if (this.timeOutId == 2) {
        NGImageViewer.log("Fast already selected!");
        return true;
    }
    NGImageViewer.stopAnimation();
    this.timeOutId++;
    speed = this.timeOutId;
    try {
        LocalXML.writeLocalXML();
    } 
    catch (e) {
        showPopupOk(e.message);
    }
    $('#' + this.divStateElement).html(this.timeoutNames[this.timeOutId]);
    NGImageViewer.startAnimation();
    NGImageViewer.log("New timeoutId " + this.timeOutId);
};

/*
 * Function: REW
 *
 * Changes current transition into slower by decrementing transitionId pointer
 *
 * Parameters:
 *
 *
 * Returns:
 */
NGImageViewer.REW = function(){
    NGImageViewer.log('REW');
    if (this.timeOutId == 0) {
        NGImageViewer.log("Slow already selected!");
        return true;
    }
    NGImageViewer.stopAnimation();
    this.timeOutId--;
    speed = this.timeOutId;
    try {
        LocalXML.writeLocalXML();
    } 
    catch (e) {
        showPopupOk(e.message);
    }
    $('#' + this.divStateElement).html(this.timeoutNames[this.timeOutId]);
    NGImageViewer.startAnimation();
    NGImageViewer.log("New timeoutId " + this.timeOutId);
};

/*
 * Function: setTransitionEffect
 *
 * Sets transition effect id. Don't do it directly using transitionId object field.
 *
 * Parameters:
 * id - number, new transitionId value
 *
 * Returns:
 */
NGImageViewer.setTransitionEffect = function(id){
    NGImageViewer.log('setTransitionEffect');
    if (this.supportedEffects) 
        this.transitionId = this.effectMapping[this.effectNames[id]];
		NGImageViewer.log("USED EFFECT ID = " + this.transitionId);
}

/*
 * Function: setTimeOutId
 *
 * Sets timeout effect id. Don't do it directly using timeoutId object field.
 *
 * Parameters:
 * id - number, new timeoutId value
 *
 * Returns:
 */
NGImageViewer.setTimeOutId = function(id){
    NGImageViewer.log('setTimeOutId');
    NGImageViewer.timeOutId = id;
    $('#' + this.divStateElement).html(this.timeoutNames[this.timeOutId]);
    NGImageViewer.stopAnimation();
    NGImageViewer.startAnimation();
    NGImageViewer.updateImageInfo();
}

/*
 * Function: checkIfEffectsSupported
 *
 * Method checks if DTV supports CImage Viewer transition effects, and sets object boolean field supportedEffects
 *
 * Parameters:
 *
 * Returns:
 */
NGImageViewer.checkIfEffectsSupported = function(){
    var info = this.ImageViewer.isEffectAvailable();
    NGImageViewer.log((info) ? 'Transition effects suported' : 'Transition effects NOT suported. Turned OFF!!!');
    if (!info) {
        this.transitionId = this.ImageViewer.Effect.NONE;
        this.supportedEffects = false;
    }
};

/*
 * Function: getModelCode
 *
 * Method checks DTV ModelCode
 *
 * Parameters:
 *
 * Returns:
 */
NGImageViewer.getModelCode = function(){
    NGImageViewer.log("DTV ModelCode: " + document.getElementById("pluginObjectNNavi").GetModelCode());
}

/*
 * Function: readParametersFromGlobals
 *
 * Method reads animation parameters, such as: timeoutId and transitionId from global variables.
 *
 * Parameters:
 *
 * Returns:
 */
NGImageViewer.readParametersFromGlobals = function(){
    NGImageViewer.log('readParametersFromGlobals');
    NGImageViewer.log('activeTranistion ' + activeTranistion);
    NGImageViewer.log('speed ' + speed);
    NGImageViewer.setTransitionEffect(activeTranistion);
    NGImageViewer.setTimeOutId(speed);
};

/*
 * Function: loadersHideSlideShow
 *
 * Method hides loading indicators and shows SlideShow
 *
 * Parameters:
 *
 * Returns:
 */
NGImageViewer.loadersHideSlideShow = function(){
    NGImageViewer.log('loadersHideSlideShow');
    $('#loader').sfLoading('hide');
    $('#loaderD').sfLoading('hide');
    if (this.fshowSlideShowAgain) 
        NGImageViewer.ImageViewer.show();
};

/*
 * Function: prepareEffects
 *
 * Main initial method which sets up all initial fields values of NGImageViewer object, as well as setting up CImage Viewer object parameters.
 *
 * Parameters:
 *
 * Returns:
 */
NGImageViewer.prepareEffects = function(){
    NGImageViewer.log('prepareEffects');
    NGImageViewer.getModelCode();
    NGImageViewer.checkIfEffectsSupported();
    SceneSlideShow.prototype.menuAction = false;
    SceneSlideShow.prototype.menusShown = true;
    $('#SlideShowOptionsTop').css('top', '0px');
    $('#SlideShowNationalGeoKeyHelp').css('top', '505px');
    SceneSlideShow.prototype.hideMenus();
    
    
    this.ImageViewer.setFrameArea(0, 0, 960, 540);
    this.ImageViewer.setOnBufferingComplete(function(){
        NGImageViewer.log("Image buffering ended!");
    });
    this.ImageViewer.setOnRenderingComplete(function(){
        NGImageViewer.log("Next image can be prepared. Block false.");
        NGImageViewer.block = false;
        //Image info updates when current image rendering ends
        NGImageViewer.updateImageInfo();
        NGImageViewer.loadersHideSlideShow();
    });
    this.ImageViewer.setOnRenderError(function(){
        var info = "Unable to render image.";
        NGImageViewer.log(info);
        showPopupOk(info);
        NGImageViewer.loadersHideSlideShow();
        NGImageViewer.block = false;
    });
    this.ImageViewer.setOnNetworkError(function(){
        var info = "Unable to download image. Network error occurred.";
        NGImageViewer.log(info);
        showPopupOk(info);
        NGImageViewer.loadersHideSlideShow();
        NGImageViewer.block = false;
    });
    this.fallInactive = NGImageViewer.AllInActive();
    this.picturePointerAction(true);
    //$('#loader').sfLoading('show');
    this.ImageViewer.startSlideshow();
    this.ImageViewer.show();
    this.ImageViewer.play(this.images[this.idx].src, 1920, 1080);
    
};

