/*
 About: Author
 Tomasz Scislo
 About: Date
 2010-10-04
 */
/*
 * Class: NGxMLParser
 *
 * Class enables widget to get and parse NG XML file.
 *
 *  Properties:
 *
 *  XMLContent - Keeps XHR_sprc object with XHRHttpRequest for NG XML file
 *
 *  xmlPath - Keeps url for NG XML file taken from ./url.txt
 *
 */
var NGxMLParser = function(){
    var me = this;
    this.XMLContent;
	$('#loading').sfLoading('show');
    this.xmlPath = new WidgetFileSystem('resources/' + graphicsDirectory + 'url.txt').fileHTML;
    blockApp();
    
    if (typeof window.DOMParser === "undefined") {
        window.DOMParser = function(){
        };
        
        window.DOMParser.prototype.parseFromString = function(str, contentType){
            var xmldata = new XMLHttpRequest;
            
            if (!contentType) {
                contentType = 'application/xml';
            }
            
            xmldata.open('GET', 'data:' + contentType + ';charset=utf-8,' +
            encodeURIComponent(str), false);
            
            if (xmldata.overrideMimeType) {
                xmldata.overrideMimeType(contentType);
            }
            
            xmldata.send(null);
            return xmldata.responseXML;
        };
        
    }
    
    /*
     * Variable: xmlContent
     *
     * Keeps XHR_sprc object with XHRHttpRequest for NG XML file
     */
    this.xmlContent = new XHR_sprc(this.xmlPath, function(){
        $('#loading').sfLoading('hide');
        unblockApp();
        me.parseXML(me.xmlContent.resp);
    }, function(e){
		blockApp();
        showPopupOk(e.message);
        $('#loading').sfLoading('hide');
    }, true);
    
    this.xmlContent.makeRequest(true);
    
    /*
     * Function: parseXML
     *
     * Parses given XML object
     *
     * Parameters:
     *
     * xmlObject- XML Object from XHRHttpRequest.
     *
     *
     * Returns:
     */
    this.parseXML = function(xmlObject){
        var gallery = $(xmlObject).find('gallery');
        
        if (gallery.length == 0) 
            throw new Error('No gallery element in XML');
        else 
            if (gallery.children('item').lenght == 0) 
                throw new Error('No item element in XML');
        
        NGImageViewer.images = Array();
        
        gallery.children('item').each(function(i){
            if ($(this).children('pictureid').length == 0) 
                throw new Error('No pictureid element in XML for item: ' + i);
            else 
                if (gallery.children('link').lenght == 0) 
                    throw new Error('No link element in XML for item: ' + i);
                else 
                    if (gallery.children('description').lenght == 0) 
                        throw new Error('No description element in XML for item: ' + i);
                    
                    else 
                        if (gallery.children('submittername').lenght == 0) 
                            throw new Error('No submittername element in XML for item: ' + i);
            
            var pictureid = $(this).children('pictureid').text();
            var link = $(this).children('link').text();
            var submittername = $(this).children('submittername').text();
            var description = $(this).children('description').text();
			var thumb = $(this).children('thumb').text();
            
            alert(">>>>>>>> Used Image Url (" + i + ") " + $.trim(link));
            
            NGImageViewer.images[i] = {
                src: $.trim(link),
                msrc: $.trim(thumb),
                desc: $.trim(description),
                auth: $.trim(submittername),
                active: true
            }
            
        });
        
        // Local settings XML NG parser
        try {
            LocalXML.processLocalXML();
        } 
        catch (e) {
			blockApp();
            showPopupOk(e.message);
        }
    };
};
