/*
 About: Author
 Tomasz Scislo
 About: Date
 2010-10-04
 */
/*
 * Class: WidgetFileSystem
 *
 * Class which implements Slide Show support using Samsung CImage Viewer
 *
 *  Properties:
 *
 *  filePath - relative file path in widget
 *
 *  widgetPath - absolute widget path
 *
 *  fileHTML - file contents
 *
 *  fullFilePath - full, absolute file path in widget
 *
 *
 */
var WidgetFileSystem = function(filePath){
    this.filePath = filePath;
    this.widgetPath;
    this.fileHTML;
    // in this var object stores full widget file path
    this.fullFilePath;
    
    /*
     * Function: log
     *
     * Simple logger
     *
     * Parameters:
     * msg - string to log
     *
     *
     * Returns:
     */
    this.log = function(msg){
        alert(">>>>>WidgetFileSystem " + msg);
    };
    
    /*
     * Function: prepareWidgetPath
     *
     * Prepares full widget path in DTV file system
     *
     * Parameters:
     *
     *
     * Returns:
     * string 
     */
    this.prepareWidgetPath = function(){
        this.log("prepareWidgetPath");
        var re = new RegExp(".*/");
        var tmpPathName = location.pathname.match(re)[0];
        if (location.pathname.match(re).length == 0) 
            throw new Error('Unable to prepare proper basic widget path!');
        return location.protocol + "//" + location.host + tmpPathName;
    };
    
    try {
        this.widgetPath = this.prepareWidgetPath();
        this.fullFilePath = this.widgetPath + this.filePath;
        this.WidgetXHR = new XHR_sprc(this.fullFilePath);
        this.WidgetXHR.makeRequest(false);
        if (!this.WidgetXHR.resp) 
            throw new Error("Unable to perform request: <br />" + this.filePath);
        this.fileHTML = this.WidgetXHR.resp;
    } 
    catch (e) {
        this.fullFilePath = undefined;
        this.log(e.message);
        showPopupOk(e.message);
		$('#loading').sfLoading('hide');
    }
    
};
