/*
 About: Author
 Tomasz Scislo
 About: Date
 2010-10-04
 */
/*
 * Class: XHR_sprc
 *
 * Class which implements AJAX requests inside widget
 *
 *  Properties:
 *
 *  url - url to get data from
 *
 *  XHRObj - XMLHttpRequest object
 *
 *  resp - XML response
 *
 *  fError - callback function to invoke, when XHRHttpRequest fails
 *
 *  callback - function to callback when request is properly done
 *
 *  xml - boolean, when set to true response is XML object, false plain text
 *
 */
var XHR_sprc = function(url, callback, fError, xml){
    this.url = url;
    if (this.XHRObj != null) 
        this.XHRObj.destroy();
    this.XHRObj = new XMLHttpRequest();
    this.resp;
    this.fError = fError;
    var me = this;
    
    /*
     * Function: XHRState
     *
     * Method hadles all XHRHttpRequest state changes
     *
     * Parameters:
     *
     *
     * Returns:
     */
    this.XHRState = function(){
        if (this.XHRObj.readyState < 4) 
            return;
        if (this.XHRObj.status < 400) {
            if (xml) 
                this.resp = this.XHRObj.responseXML;
            else 
                this.resp = this.XHRObj.responseText;
            if (typeof callback === "function") 
                callback();
        }
        else {
            throw new Error('Unable to open file <br />' + this.url + '<br /> Restart application.');
        }
    };
    
    this.XHRObj.onreadystatechange = function(){
        try {
            me.XHRState();
        } 
        catch (e) {
            if (typeof me.fError === "function") 
                me.fError(e);
            alert(">>>>>>>>>> XHR_sprc: " + e.message);
        }
    };
    
    /*
     * Function: makeRequest
     *
     * Method hadles all XHRHttpRequest state changes
     *
     * Parameters:
     * type - boolean, when set to true than async mode otherwise sync mode
     *
     * Returns:
     */
    this.makeRequest = function(type){
        this.XHRObj.open("GET", this.url, type);
        this.XHRObj.send(null);
    }
    
};

