alert(">>>>> National Geographic init.js START");

/*
 Variable: graphicsDirectory
 Directory name for all layout changes in widget: in ./images ./app/stylesheets and ./resources
 Changing widget layout needs also changes in css and html scene files.
 */
var graphicsDirectory = ""; 

/*
 Variable: transitionList
 Widget possible transition list taken from NGImageViewer singleton
 */
var transitionList;
/*
 Variable: speedList
 Widget possible timeout list taken from NGImageViewer singleton
 */
var speedList;
/*
 Variable: transitionList
 Current widget transition ID
 */
var activeTranistion = 0;
/*
 Variable: speed
 Current widget timeout ID
 */
var speed = 0;
/*
 Variable: LocalXML
 CommonFileSystem object to manipulate local XML settings file
 */
var LocalXML;

/*
 Variable: timerID
 Global variable with setTimeout pointer
 */
var timerID;

/*
 Variable: imageList
 Array of images to be loaded for widget
 */
var imageList = new Array();

/*
 Variable: loaded
 Number of loaded images
 */
var loaded = 0;

/*
 Variable: loaded
 Array of loaded images for widget
 */
var loadedList = new Array();

preLoadImg(graphicsDirectory);

$.sf.loadCSS("app/stylesheets/" + graphicsDirectory + "colors.css");
$.sf.loadJS("Lib/HTMLPanel_sprc.js");
$.sf.loadJS("Lib/ui_grid_sprc.js");
$.sf.loadJS("Lib/ComboBox.js");
$.sf.loadJS("app/NGImageViewer.js");
$.sf.loadJS("app/XHR_sprc.js");
$.sf.loadJS("app/NGxMLParser.js");
$.sf.loadJS("app/WidgetFileSystem.js");
$.sf.loadJS("app/CommonFileSystem.js");
$.sf.loadJS("app/CSSModification.js");
$.sf.loadJS("$MANAGER_WIDGET/Common/API/Plugin.js");


/*
 * Function: alert
 *
 * Alert stub for production realase
 *
 */
function alert(){
}

/*
 * Function: onStart
 *
 * Actions taken after widget startup
 *
 */
function onStart(){
	$.sfScene.show('Main');
    transitionList = NGImageViewer.effectNames;
    speedList = NGImageViewer.timeoutNames;
    LocalXML = new CommonFileSystem();
}

/*
 * Function: onDestroy
 *
 * Actions taken before exiting the widget
 *
 */
function onDestroy(){
}


// It is very important to destroy CImageViewer object on unload	
$(window).unload(function(){
    NGImageViewer.log('Unload NGImageViewer');
    NGImageViewer.cleanUp();
});

/*
 * Function: blockApp
 *
 * Blocks app while xml loading. Do not allow user to enter into app.
 *
 */
function blockApp(){
    alert(">>>>>>>>> blockApp");
    $.sfScene.hide('MainRight');
    $.sfScene.hide('MainTop');
    $.sfScene.hide('HomeMenu');
    $.sfScene.focus('Main');
    $('#SceneMain').css('background', '#fff url(images/' + graphicsDirectory + 'ng_common_bg_02.png) no-repeat');
}

/*
 * Function: unblockApp
 *
 * Unblocks app after xml loading. Allows user to enter into app.
 *
 */
function unblockApp(){
    alert(">>>>>>>>> unblockApp");
    $.sfScene.show('MainRight');
    $.sfScene.show('HomeMenu');
    $.sfScene.focus('HomeMenu');
    $('#SceneMain').css('background', '#fff url(images/' + graphicsDirectory + 'ng_common_bg_01.png) no-repeat');
}

/*
 * Function: preLoadImg
 *
 * Preloads images from one skin NG directory
 *
 */
function preLoadImg(category){

    imageList[0] = new Image();
    imageList[0].src = "images/" + category + "about_picture.png";
    imageList[1] = new Image();
    imageList[1].src = "images/" + category + "cancel_but.png";
    imageList[2] = new Image();
    imageList[2].src = "images/" + category + "category_about_nor.png";
    imageList[3] = new Image();
    imageList[3].src = "images/" + category + "category_about_sel.png";
    imageList[4] = new Image();
    imageList[4].src = "images/" + category + "category_adventure.png";
    imageList[5] = new Image();
    imageList[5].src = "images/" + category + "category_copyright.png";
    imageList[6] = new Image();
    imageList[6].src = "images/" + category + "category_focus.png";
    imageList[7] = new Image();
    imageList[7].src = "images/" + category + "category_option_nor.png";
    imageList[8] = new Image();
    imageList[8].src = "images/" + category + "category_option_sel.png";
    imageList[9] = new Image();
    imageList[9].src = "images/" + category + "category_play_nor.png";
    imageList[10] = new Image();
    imageList[10].src = "images/" + category + "category_play_sel.png";
    imageList[11] = new Image();
    imageList[11].src = "images/" + category + "common_scroll_focus.png";
    imageList[12] = new Image();
    imageList[12].src = "images/" + category + "common_scroll_nor.png";
    imageList[13] = new Image();
    imageList[13].src = "images/" + category + "ng_common_bg_01.png";
    imageList[14] = new Image();
    imageList[14].src = "images/" + category + "ng_common_bg_02.png";
    imageList[15] = new Image();
    imageList[15].src = "images/" + category + "ng_logo.png";
    imageList[16] = new Image();
    imageList[16].src = "images/" + category + "ok_but.png";
    imageList[17] = new Image();
    imageList[17].src = "images/" + category + "option_arrow_nor.png";
    imageList[18] = new Image();
    imageList[18].src = "images/" + category + "option_arrow_sel.png";
    imageList[19] = new Image();
    imageList[19].src = "images/" + category + "option_bg.png";
    imageList[20] = new Image();
    imageList[20].src = "images/" + category + "option_box.png";
    imageList[21] = new Image();
    imageList[21].src = "images/" + category + "option_focus.png";
    imageList[22] = new Image();
    imageList[22].src = "images/" + category + "photo_detail_arrow_left.png";
    imageList[23] = new Image();
    imageList[23].src = "images/" + category + "photo_detail_arrow_right.png";
    imageList[24] = new Image();
    imageList[24].src = "images/" + category + "photo_detail_frame.png";
    imageList[25] = new Image();
    imageList[25].src = "images/" + category + "photo_detail_picture.png";
    imageList[26] = new Image();
    imageList[26].src = "images/" + category + "photo_thumb.png";
    imageList[27] = new Image();
    imageList[27].src = "images/" + category + "photo_thumb_frame_nor.png";
    imageList[28] = new Image();
    imageList[28].src = "images/" + category + "photo_thumb_frame_sel.png";
    imageList[29] = new Image();
    imageList[29].src = "images/" + category + "play_picture.png";
    imageList[30] = new Image();
    imageList[30].src = "images/" + category + "play_picture_frame.png";
    imageList[31] = new Image();
    imageList[31].src = "images/" + category + "popup_bg.png";
    imageList[32] = new Image();
    imageList[32].src = "images/" + category + "popup_focus.png";
    imageList[33] = new Image();
    imageList[33].src = "images/" + category + "popup_line.png";
    imageList[34] = new Image();
    imageList[34].src = "images/" + category + "popup_line_thick.png";
    imageList[35] = new Image();
    imageList[35].src = "images/" + category + "slideshow_ng_logo.png";
    imageList[36] = new Image();
    imageList[36].src = "images/" + category + "slideshow_top_bg.png";
    imageList[37] = new Image();
    imageList[37].src = "images/" + category + "slideshow_top_pause.png";
    imageList[38] = new Image();
    imageList[38].src = "images/" + category + "slideshow_top_play.png";
    imageList[39] = new Image();
    imageList[39].src = "images/" + category + "check_mark.png";
    imageList[40] = new Image();
    imageList[40].src = "images/" + category + "checkbox.png";
    imageList[41] = new Image();
    imageList[41].src = "images/" + category + "option_pull_down.png";
    imageList[42] = new Image();
    imageList[42].src = "images/" + category + "option_pull_down_focus.png";
    imageList[43] = new Image();
    imageList[43].src = "images/" + category + "popup_box.png";
    imageList[44] = new Image();
    imageList[44].src = "images/" + category + "popup_pull_down.png";
    imageList[45] = new Image();
    imageList[45].src = "images/" + category + "popup_pull_down_focus.png";
    
    var i = 0;
    for (i = 0; i < imageList.length; i++) {
        loadedList[i] = false;
    }
    
    checkLoad();
}

/*
 * Function: checkLoad
 *
 * This function checks if all images have been loaded (does it in 30 ms intervals)
 *
 */
function checkLoad(){
    alert("Start_________" + loaded);
    if (loaded == imageList.length) {
        alert("Finished_______" + loaded);
        clearTimeout(timerID);
        return;
    }
    var i = 0;
    for (i = 0; i < imageList.length; i++) {
        if (loadedList[i] == false && imageList[i].complete) {
            loadedList[i] = true;
            loaded++;
            alert("Inside________" + loaded);
        }
        
    }
    timerID = setTimeout("checkLoad()", 30)
}

/*
 * Function: showPopupOk
 *
 * Shows popup with definded string
 *
 */
function showPopupOk(msg){
    $(function(){
        $("body").prepend('<div id="popup" style="position:absolute; overflow:auto; width:650px; z-index:20;"></div>');
    });
    alert(">>>>>>>>>>>>>showPopupOk: " + msg);
    $('#popup').sfPopup({
        text: msg,
        num: 1,
        response: 1,
        callback: function(rlt){
        }
    });
    $.sfScene.hide("MainRight");
    $('#popup').sfPopup("show");
}

alert("init.js loaded.");
