/*
 About: Author
 Tomasz Scislo
 About: Date
 2010-10-14
 */
alert('SceneDetailPage.js loaded');


/*
 * Class: SceneDetailPage
 *
 * Class with DetailPage Scene, which is used to display additional information about image
 *
 *
 */
function SceneDetailPage(){

}

/*
 * Function: initialize
 *
 * Scene initialization
 *
 */
SceneDetailPage.prototype.initialize = function(){
    alert("SceneDetailPage.initialize()");
    var cssModification = new CSSModification();
    cssModification.changeBackground('#Frame');
    cssModification.changeBackground('#LeftArrow');
    cssModification.changeBackground('#RightArrow');
}

/*
 * Function: backToSlideShow
 *
 * Method which enables scene to return to SlideShow scene setting all needed variables
 *
 */
SceneDetailPage.prototype.backToSlideShow = function(){
    alert("SceneDetailPage.backToSlideShow()");
    $.sfKey.block(event);
    $.sfScene.hide("DetailPage");
    $.sfScene.hide("Main");
    $.sfScene.hide("MainTop");
    NGImageViewer.returnToSlideShow();
    NGImageViewer.resume();
    NGImageViewer.idx--;
    NGImageViewer.startAnimation();
    $.sfScene.show("SlideShow");
    $.sfScene.focus("SlideShow");
};

/*
 * Function: cutText
 *
 * Simple method to cut strings after given no of chars
 *
 * Parameters:
 * txt - string to cut
 * cutSize - number of chars to be left
 *
 *
 * Returns:
 * string
 */
SceneDetailPage.prototype.cutText = function(txt, cutSize){
    if (txt.length > cutSize) 
        return (txt.slice(0, cutSize) + '[...]');
    else 
        return txt;
};

/*
 * Function: updateSceneElements
 *
 * Updates scene DOM elements
 *
 */
SceneDetailPage.prototype.updateSceneElements = function(){
    alert("SceneDetailPage.updateSceneElements()");
    $('#MainTopMiddle').html("Home > Details Page");
    $('#MainTopRight').html((NGImageViewer.idx + 1).toString() + "/" + NGImageViewer.images.length.toString());
    $('#ImageDesc').html(SceneDetailPage.prototype.cutText(NGImageViewer.getCurrentPicture().desc, 440) + "<div id='Photographer' class='color4'>" + NGImageViewer.getCurrentPicture().auth + "</div>");
    
    
};

/*
 * Function: handleShow
 *
 * Handles scene show
 *
 */
SceneDetailPage.prototype.handleShow = function(data){
    alert("SceneDetailPage.handleShow()");
    // Scene Main background change
    $('#SceneMain').css('background', '#fff url(images/' + graphicsDirectory + 'ng_common_bg_02.png) no-repeat');
    SceneDetailPage.prototype.updateSceneElements();
    $('#MainNationalGeoKeyHelp').sfKeyHelp({
        'green': 'Home',
        'tools': 'Options',
        'leftright': 'Previous / Next',
        'enter': 'Slide Show',
        'return': 'Return'
    });
    $('#loaderD').sfLoading('show');
    NGImageViewer.fshowSlideShowAgain = true;
    //    NGImageViewer.ImageViewer.hide();
    NGImageViewer.endSlideShow();
}

/*
 * Function: handleHide
 *
 * Handles scene hide
 *
 */
SceneDetailPage.prototype.handleHide = function(){
    alert("SceneDetailPage.handleHide()");
    // Scene Main background change
    $('#SceneMain').css('background', '#fff url(images/' + graphicsDirectory + 'ng_common_bg_01.png) no-repeat');
    $('#loaderD').sfLoading('hide');
    NGImageViewer.fshowSlideShowAgain = false;
    // this function will be called when the scene manager hide this scene  
}

/*
 * Function: handleFocus
 *
 * Handles scene focus
 *
 */
SceneDetailPage.prototype.handleFocus = function(){
    alert("SceneDetailPage.handleFocus()");
    // this function will be called when the scene manager focus this scene
}

/*
 * Function: handleBlur
 *
 * Handles scene blur
 *
 */
SceneDetailPage.prototype.handleBlur = function(){
    alert("SceneDetailPage.handleBlur()");
    // this function will be called when the scene manager move focus to another scene from this scene
}

/*
 * Function: handleKeyDown
 *
 * Handles key events
 *
 */
SceneDetailPage.prototype.handleKeyDown = function(keyCode){
    alert("SceneDetailPage.handleKeyDown(" + keyCode + ")");
    // TODO : write an key event handler when this scene get focued
    switch (keyCode) {
        case $.sfKey.LEFT:
            NGImageViewer.prevOnlyCounter();
            SceneDetailPage.prototype.updateSceneElements();
            break;
        case $.sfKey.RIGHT:
            NGImageViewer.nextOnlyCounter();
            SceneDetailPage.prototype.updateSceneElements();
            break;
        case $.sfKey.GREEN:
            NGImageViewer.hide();
            $.sfScene.hide("DetailPage");
            $.sfScene.hide("MainTop");
            $.sfScene.show("Main");
            $.sfScene.show("HomeMenu");
            $.sfScene.show("MainRight");
            break;
        case $.sfKey.TOOLS:
            ScenePopupOption.prototype.invocationScene = "DetailPage";
            $.sfScene.show("PopupOption");
            $.sfScene.focus("PopupOption");
            break;
        case $.sfKey.RETURN:
            SceneDetailPage.prototype.backToSlideShow();
            break;
        case $.sfKey.ENTER:
            SceneDetailPage.prototype.backToSlideShow();
            break;
    }
}
