/*
 About: Author
 Kamil Parzniewski
 About: Date
 2010-10-14
 */
alert('SceneHomeAbout.js loaded');

/*
 * Class: SceneHomeAbout
 *
 * Class with HomeAbout Scene, which is used to display about NG text.
 *
 *
 */
function SceneHomeAbout(){

}

/*
 * Function: initialize
 *
 * Scene initialization
 *
 */
SceneHomeAbout.prototype.initialize = function(){
    alert("SceneHomeAbout.initialize()");
    // this function will be called only once when the scene manager show this scene first time
    // initialize the scene controls and styles, and initialize your variables here 
    // scene HTML and CSS will be loaded before this function is called
    $("#AboutPanel").sfHtmlPanel("init");
    var aboutFile = new WidgetFileSystem('resources/' + graphicsDirectory + 'about.txt');
    $("#AboutPanel").sfHtmlPanel({
        text: aboutFile.fileHTML
    });
    $("#AboutPanel").sfHtmlPanel({
        animate: false,
        speed: 0,
        step: 25,
        focus: "HomeMenu"
    });
    var cssModification = new CSSModification();
    cssModification.changeBackground('#AboutPicture');
    cssModification.changeBackground('#SceneHomeAbout .HandleNormal');
}

/*
 * Function: handleShow
 *
 * Handles scene show
 *
 */
SceneHomeAbout.prototype.handleShow = function(data){
    alert("SceneHomeAbout.handleShow()");
    // this function will be called when the scene manager show this scene 
}

/*
 * Function: handleHide
 *
 * Handles scene hide
 *
 */
SceneHomeAbout.prototype.handleHide = function(){
    alert("SceneHomeAbout.handleHide()");
    // this function will be called when the scene manager hide this scene  
}

/*
 * Function: handleFocus
 *
 * Handles scene focus
 *
 */
SceneHomeAbout.prototype.handleFocus = function(){
    alert("SceneHomeAbout.handleFocus()");
    // this function will be called when the scene manager focus this scene
    $("#AboutPanel").sfHtmlPanel("focus");
	$("#SceneHomeAbout .HandleSelect").css('background', 'url(images/' + graphicsDirectory + '/common_scroll_focus.png)');
    $('#MainNationalGeoKeyHelp').sfKeyHelp({
        'rewff': 'Page Move',
        'return': 'Return'
    });
}

/*
 * Function: handleBlur
 *
 * Handles scene blur
 *
 */
SceneHomeAbout.prototype.handleBlur = function(){
    alert("SceneHomeAbout.handleBlur()");
	$("#SceneHomeAbout .HandleSelect").css('background', 'url(images/' + graphicsDirectory + '/common_scroll_nor.png)');
    // this function will be called when the scene manager move focus to another scene from this scene
}

/*
 * Function: handleKeyDown
 *
 * Handles key events
 *
 */
SceneHomeAbout.prototype.handleKeyDown = function(keyCode){
    alert("SceneHomeAbout.handleKeyDown(" + keyCode + ")");
    // TODO : write an key event handler when this scene get focued
    switch (keyCode) {
        case $.sfKey.LEFT:
            break;
        case $.sfKey.RIGHT:
            break;
        case $.sfKey.UP:
            break;
        case $.sfKey.DOWN:
            break;
        case $.sfKey.ENTER:
            break;
    }
}
