/*
 About: Author
 Tomasz Scislo
 About: Date
 2010-10-14
 */
alert('SceneHomeMenu.js loaded');

/*
 * Class: SceneHomeMenu
 *
 * Class with HomeMenut Scene, which is used to display main navigation.
 *
 *
 */
function SceneHomeMenu(){
    this.mFocus = 0;
    this.mFocusPos = 92;
    this.mDivIds = ["#HomeMenuPlay", "#HomeMenuOption", "#HomeMenuAbout"];
    this.mImgsIds = ["category_play", "category_option", "category_about"];
}

/*
 * Function: initialize
 *
 * Scene initialization
 *
 */
SceneHomeMenu.prototype.initialize = function(){
    alert("SceneHomeMenu.initialize()");
    var desc = new WidgetFileSystem('resources/' + graphicsDirectory + 'desc.txt');
    $("#HomeMenuCategoryText").html(desc.fileHTML);
    $.sfScene.show("HomeOption");
    $.sfScene.hide("HomeOption");
    $.sfScene.show("PopupOption");
    $.sfScene.hide("PopupOption");
    this._updateFocus("Select");
    var cssModification = new CSSModification();
    cssModification.changeBackground('#HomeMenuFocus');
    cssModification.changeBackground('#HomeMenuCopyright');
	cssModification.changeBackground('.MenuImage');
}

/*
 * Function: handleShow
 *
 * Handles scene show
 *
 */
SceneHomeMenu.prototype.handleShow = function(data){
    alert("SceneHomeMenu.handleShow()");
    this._initFirst();
    // this function will be called when the scene manager show this scene 
}

/*
 * Function: handleHide
 *
 * Handles scene hide
 *
 */
SceneHomeMenu.prototype.handleHide = function(){
    alert("SceneHomeMenu.handleHide()");
    // this function will be called when the scene manager hide this scene  
}

/*
 * Function: handleFocus
 *
 * Handles scene focus
 *
 */
SceneHomeMenu.prototype.handleFocus = function(){
    alert("SceneHomeMenu.handleFocus()");
    // this function will be called when the scene manager focus this scene
    $('#MainNationalGeoKeyHelp').sfKeyHelp({
        'enter': 'Enter',
        'return': 'Return',
    });
}

/*
 * Function: handleBlur
 *
 * Handles scene blur
 *
 */
SceneHomeMenu.prototype.handleBlur = function(){
    alert("SceneHomeMenu.handleBlur()");
    // this function will be called when the scene manager move focus to another scene from this scene
}

/*
 * Function: handleKeyDown
 *
 * Handles key events
 *
 */
SceneHomeMenu.prototype.handleKeyDown = function(keyCode){
    alert("SceneHomeMenu.handleKeyDown(" + keyCode + ")");
    // TODO : write an key event handler when this scene get focued
    switch (keyCode) {
        case $.sfKey.LEFT:
            break;
        case $.sfKey.RIGHT:
            this._focus();
            break;
        case $.sfKey.UP:
            this._moveUp();
            this._select();
            break;
        case $.sfKey.DOWN:
            this._moveDown();
            this._select();
            break;
        case $.sfKey.ENTER:
            this._focus();
            break;
    }
}

/*
 * Function: _initFirst
 * Method initializes start element
 *
 */
SceneHomeMenu.prototype._initFirst = function(){
    this.mFocus = 1;
    this._updateFocus("Normal");
    this.mFocus = 0;
    this._updateFocus("Select");
}

/*
 * Function: _moveUp
 * Function move focus up from one option menu to upper one
 *
 */
SceneHomeMenu.prototype._moveUp = function(){
    this._updateFocus("Normal");
    if (this.mFocus > 0) {
        this.mFocus--;
    }
    else {
        this.mFocus = 0;
    }
    this._updateFocus("Select");
    var cssModification = new CSSModification();
}

/*
 * Function: _moveDown
 * Function move focus down from one option menu to lower one
 *
 */
SceneHomeMenu.prototype._moveDown = function(){
    this._updateFocus("Normal");
    if (this.mFocus < 2) {
        this.mFocus++;
    }
    else {
        this.mFocus = 2;
    }
    this._updateFocus("Select");
    var cssModification = new CSSModification();
}

/*
 * Function: _updateFocus
 * THis function updates focus for selected menu
 *
 */
SceneHomeMenu.prototype._updateFocus = function(type){
    $("#HomeMenuFocus").css("top", (this.mFocusPos + (this.mFocus * 56)) + "px");
    for (var k = 0; k < this.mDivIds.length; k++) {
        if (k == this.mFocus) 
            $(this.mDivIds[k]).css('backgroundImage', 'url(images/' + graphicsDirectory + this.mImgsIds[k] + '_sel.png)');
        else 
            $(this.mDivIds[k]).css('backgroundImage', 'url(images/' + graphicsDirectory + this.mImgsIds[k] + '_nor.png)');
    }
}

/*
 * Function: _select
 * Method to show focused scene
 *
 */
SceneHomeMenu.prototype._select = function(){
    switch (this.mFocus) {
        case 0:
            $.sfScene.hide("HomeAbout");
            $.sfScene.hide("HomeOption");
            $.sfScene.show("MainRight");
            break;//show PLAY scene
        case 1:
            $.sfScene.hide("HomeAbout");
            $.sfScene.hide("MainRight");
            $.sfScene.show("HomeOption");
            break;//show OPTION scene
        case 2:
            $.sfScene.hide("HomeOption");
            $.sfScene.hide("MainRight");
            $.sfScene.show("HomeAbout");
            break;//show ABOUT scene
    }
}

/*
 * Function: _focus
 * Method to change focus on scenes
 *
 */
SceneHomeMenu.prototype._focus = function(){
    switch (this.mFocus) {
        case 0:
            $.sfScene.hide("Main");
            $.sfScene.hide("HomeMenu");
            $.sfScene.show("SlideShow");
            $.sfScene.focus("SlideShow");
            break;//show PLAY scene
        case 1:
            $.sfScene.focus("HomeOption");
            break;//show OPTION scene
        case 2:
            $.sfScene.focus("HomeAbout");
            break;//show ABOUT scene
    }
}

