/*
 About: Author
 Kamil Parzniewski
 About: Date
 2010-10-14
 */
alert('SceneHomeOption.js loaded');

/*
 * Class: SceneHomeOption
 *
 * Class with HomeOption Scene, which is used to display SlideShow options from main menu.
 *
 *
 */
function SceneHomeOption(){
    this.mFocus = 0;
    this.mDivId = ["Selection", "Transition", "Speed"];
}

/*
 * Function: initialize
 *
 * Scene initialization
 *
 */
SceneHomeOption.prototype.initialize = function(){
    alert("SceneHomeOption.initialize()");
    // this function will be called only once when the scene manager show this scene first time
    // initialize the scene controls and styles, and initialize your variables here 
    // scene HTML and CSS will be loaded before this function is called
    
    $("#ComboTransition").sfComboBox("maxComboLength", 5);
    $("#ComboSpeed").sfComboBox("maxComboLength", 3);
    
    $("#ComboSpeed").sfComboBox(speedList);
    $("#ComboTransition").sfComboBox(transitionList);
    
    $("#ComboSpeed").sfComboBox("return", function(index){
        //alert("OptionSpeed IDX: " + $("#OptionSpeed").sfComboBox("comboIndex"));
        speed = $("#ComboSpeed").sfComboBox("comboIndex");
        $("#OptionSpeed").html(speedList[speed]);
    });
    $("#ComboTransition").sfComboBox("return", function(index){
        //alert("OptionTransition IDX: " + $("#OptionTransition").sfComboBox("comboIndex"));
        activeTranistion = $("#ComboTransition").sfComboBox("comboIndex");
        $("#OptionTransition").html(transitionList[activeTranistion]);
    });

    $("#OptionTransition").html(transitionList[activeTranistion]);
    $("#OptionSpeed").html(speedList[speed]);    
    

}

/*
 * Function: handleShow
 *
 * Handles scene show
 * 
 */
SceneHomeOption.prototype.handleShow = function(data){
    alert("SceneHomeOption.handleShow()");
    // this function will be called when the scene manager show this scene 
    $("#ComboTransition").sfComboBox("setComboIndex", activeTranistion);
    $("#ComboSpeed").sfComboBox("setComboIndex", speed);
    $("#OptionTransition").html(transitionList[activeTranistion]);
    $("#OptionSpeed").html(speedList[speed]);  
    
    var cssModification = new CSSModification();
    cssModification.changeBackground("#OptionBackground");    
    
    $("#OptionSelection").css('background', '#000 url(images/' + graphicsDirectory + 'option_box.png) no-repeat');
    $("#OptionTransition").css('background', '#000 url(images/' + graphicsDirectory + 'option_box.png) no-repeat');
    $("#OptionSpeed").css('background', '#000 url(images/' + graphicsDirectory + 'option_box.png) no-repeat');
}

/*
 * Function: handleHide
 *
 * Handles scene hide
 * 
 */
SceneHomeOption.prototype.handleHide = function(){
    alert("SceneHomeOption.handleHide()");
    // this function will be called when the scene manager hide this scene  
}

/*
 * Function: handleFocus 
 *
 * Handles scene focus
 * 
 */
SceneHomeOption.prototype.handleFocus = function(){
    alert("SceneHomeOption.handleFocus()");
    // this function will be called when the scene manager focus this scene
    this._updateFocus("Select");
}

/*
 * Function: handleBlur 
 *
 * Handles scene blur
 * 
 */
SceneHomeOption.prototype.handleBlur = function(){
    alert("SceneHomeOption.handleBlur()");
    try {
        LocalXML.writeLocalXML();
    } 
    catch (e) {
        showPopupOk(e.message);
    }
}

/*
 * Function: handleKeyDown 
 *
 * Handles key events
 * 
 */
SceneHomeOption.prototype.handleKeyDown = function(keyCode){
    alert("SceneHomeOption.handleKeyDown(" + keyCode + ")");
    // TODO : write an key event handler when this scene get focued
    switch (keyCode) {
        case $.sfKey.LEFT:
            break;
        case $.sfKey.RIGHT:
            break;
        case $.sfKey.UP:
            this._moveUp();
            break;
        case $.sfKey.DOWN:
            this._moveDown();
            break;
        case $.sfKey.ENTER:
            if (this.mFocus > 0) {
                this._slideCombobox(this.mDivId[this.mFocus]);
            }
            else {
                this._updateFocus("Normal");
                this.mFocus = 0;
                $.sfScene.hide("HomeOption");
                $.sfScene.hide("HomeMenu");
                $.sfScene.show("PhotoSelection");
                $.sfScene.focus("PhotoSelection");
            }
            break;
        case $.sfKey.RETURN:
            $.sfKey.block(event);
            this._updateFocus("Normal");
            this.mFocus = 0;
            $.sfScene.focus("HomeMenu");
            $.sf.returnFocus();
            break;
    }
}

/*
 * Function: _slideCombobox
 *
 * This function calls ComboBox to slide up/down list
 *
 */
SceneHomeOption.prototype._slideCombobox = function(type){
    $("#Combo" + type).sfComboBox("SLIDEDOWN");
}

/*
 * Function: _moveUp
 *
 * Function move focus up from one option menu to upper one
 *
 */
SceneHomeOption.prototype._moveUp = function(){
    this._updateFocus("Normal");
    if (this.mFocus > 0) {
        this.mFocus--;
    }
    else {
        this.mFocus = 0;
    }
    this._updateFocus("Select");
}

/*
 * Function: _moveDown
 *
 * Function move focus down from one option menu to lower one
 * 
 */
SceneHomeOption.prototype._moveDown = function(){
    this._updateFocus("Normal");
    if (this.mFocus < 2) {
        this.mFocus++;
    }
    else {
        this.mFocus = 2;
    }
    this._updateFocus("Select");
}

/*
 * Function: _updateFocus
 *
 * THis function updates focus for selected menu
 *
 */
SceneHomeOption.prototype._updateFocus = function(type){
    if(type == "Select")
    {//css();
        $("#Option" + this.mDivId[this.mFocus]).css('background', '#000 url(images/' + graphicsDirectory + 'option_focus.png) no-repeat');
        $("#Option" + this.mDivId[this.mFocus]).css('color','#3F2302');
        $("#"+this.mDivId[this.mFocus]+"Arrow").css('background', 'url(images/' + graphicsDirectory + 'option_arrow_sel.png) no-repeat');
    }
    else
    {
        $("#Option" + this.mDivId[this.mFocus]).css('background', '#000 url(images/' + graphicsDirectory + 'option_box.png) no-repeat');
        $("#Option" + this.mDivId[this.mFocus]).css('color','#FFFFFF');
        $("#"+this.mDivId[this.mFocus]+"Arrow").css('background', 'url(images/' + graphicsDirectory + 'option_arrow_nor.png) no-repeat');    
    }
}
