/*
 About: Author
 Tomasz Scislo
 About: Date
 2010-10-14
 */
alert('ScenePhotoSelection.js loaded');

/*
 * Class: ScenePhotoSelection
 *
 * Class with PhotoSelection Scene, which is used to manage which images should be included to the slide show.
 *
 *
 */
function ScenePhotoSelection(){
    this.perPage = 12;
    this.perRow = 6;
    this.container = "#selectionContainer";
    this.scrollContainer = "#selectionScroll";
}

/*
 * Function: paintBar
 *
 * Method to update HelpBar on the bottom of the scene.
 *
 */
ScenePhotoSelection.prototype.paintBar = function(){
    alert("ScenePhotoSelection.paintBar()");
    $('#MainNationalGeoKeyHelp').sfKeyHelp({
        'green': 'Home',
        'yellow': ((NGImageViewer.images[parseInt($(this.container).sfGridSPRC("getCurIndex"))].active) ? 'Deselect' : 'Select'),
        'blue': ((NGImageViewer.marked) ? 'Select All' : 'Deselect All'),
        'rewff': 'Page Move',
        'enter': 'Slide Show',
        'return': 'Return'
    });
}

/*
 * Function: initialize
 *
 * Scene initialization
 *
 */
ScenePhotoSelection.prototype.initialize = function(){
    alert("ScenePhotoSelection.initialize()");
    $(this.container).sfGridSPRC({
        data: NGImageViewer.generateSelecionHTML(),
        itemsPerPage: this.perPage,
        perRow: this.perRow,
        currPage: 0,
        index: 0
    });
    this.pages = $(this.container).sfGridSPRC("getPages");
    $(this.scrollContainer).sfScroll({
        page: this.pages
    });
    $(this.scrollContainer).sfScroll('move', this.idx = 0);
    
    var cssModification = new CSSModification();
    cssModification.changeBackground('.sf-ui-scroll-middle', 'repeat-y !important');
    cssModification.changeBackground('.sf-ui-scroll-bottom', 'repeat-y !important');
    cssModification.changeBackground('.sf-ui-scroll-top', 'repeat-y !important');
}

/*
 * Function: handleShow
 *
 * Handles scene show
 *
 */
ScenePhotoSelection.prototype.handleShow = function(data){
    alert("ScenePhotoSelection.handleShow()");
    $.sfScene.show("MainTop");
    $('#MainTopMiddle').html("Home > Photo Selection");
    $('#SceneMain').css('background', '#fff url(images/' + graphicsDirectory + 'ng_common_bg_02.png) no-repeat');
    this.paintBar();
    this.updatePageCount();
}

/*
 * Function: handleHide
 *
 * Handles scene hide
 *
 */
ScenePhotoSelection.prototype.handleHide = function(){
    alert("ScenePhotoSelection.handleHide()");
    $('#SceneMain').css('background', '#fff url(images/' + graphicsDirectory + 'ng_common_bg_01.png) no-repeat');
    NGImageViewer.fallInactive = NGImageViewer.AllInActive();
    try {
        LocalXML.writeLocalXML();
    } 
    catch (e) {
        showPopupOk(e.message);
    }
}

/*
 * Function: handleFocus
 *
 * Handles scene focus
 *
 */
ScenePhotoSelection.prototype.handleFocus = function(){
    alert("ScenePhotoSelection.handleFocus()");
    $(this.container).sfGridSPRC("focus");
    // this function will be called when the scene manager focus this scene
}

/*
 * Function: handleBlur
 *
 * Handles scene blur
 *
 */
ScenePhotoSelection.prototype.handleBlur = function(){
    alert("ScenePhotoSelection.handleBlur()");
    // this function will be called when the scene manager move focus to another scene from this scene
}

/*
 * Function: next
 *
 * Switch to next image
 *
 */
ScenePhotoSelection.prototype.next = function(){
    $(this.container).sfGridSPRC("next");
    this.updatePageCount();
    this.paintBar();
}

/*
 * Function: prev
 *
 * Switch to prev image
 *
 */
ScenePhotoSelection.prototype.prev = function(){
    $(this.container).sfGridSPRC("prev");
    this.updatePageCount();
    this.paintBar();
}

/*
 * Function: up
 *
 * Switch to upper image
 *
 */
ScenePhotoSelection.prototype.up = function(){
    $(this.container).sfGridSPRC("up");
    this.updatePageCount();
    this.paintBar();
}

/*
 * Function: down
 *
 * Switch to lower image
 *
 */
ScenePhotoSelection.prototype.down = function(){
    $(this.container).sfGridSPRC("down");
    this.updatePageCount();
    this.paintBar();
}

/*
 * Function: nextPage
 *
 * Switch to next page
 *
 */
ScenePhotoSelection.prototype.nextPage = function(){
    $(this.container).sfGridSPRC("nextPage");
    this.updatePageCount();
    this.paintBar();
}

/*
 * Function: prevPage
 *
 * Switch to prev page
 *
 */
ScenePhotoSelection.prototype.prevPage = function(){
    $(this.container).sfGridSPRC("prevPage");
    this.updatePageCount();
    this.paintBar();
}

/*
 * Function: updatePageCount
 *
 * Updates pages count in DOM elements
 *
 */
ScenePhotoSelection.prototype.updatePageCount = function(){
    alert("ScenePhotoSelection.updatePageCount()");
    $('#MainTopRight').html(($(this.container).sfGridSPRC("getCurPage") + 1) + '/' + $(this.container).sfGridSPRC("getPages"));
    $(this.scrollContainer).sfScroll('move', $(this.container).sfGridSPRC("getCurPage"));
}

/*
 * Function: select
 *
 * Selects one grid element
 *
 */
ScenePhotoSelection.prototype.select = function(){
    alert("ScenePhotoSelection.select()");
    var selIndex = $(this.container).sfGridSPRC("getCurIndex");
    NGImageViewer.images[selIndex].active = !NGImageViewer.images[selIndex].active;
    $(this.container).sfGridSPRC("init", {
        data: NGImageViewer.generateSelecionHTML(),
        itemsPerPage: this.perPage,
        perRow: this.perRow,
        index: $(this.container).sfGridSPRC("getCurIndex"),
        currPage: $(this.container).sfGridSPRC("getCurPage")
    });
}

/*
 * Function: markAll
 *
 * Marks all images selected / deselected
 *
 */
ScenePhotoSelection.prototype.markAll = function(){
    alert("ScenePhotoSelection.markAll()");
    NGImageViewer.markAll();
    $(this.container).sfGridSPRC("init", {
        data: NGImageViewer.generateSelecionHTML(),
        itemsPerPage: this.perPage,
        perRow: this.perRow,
        index: $(this.container).sfGridSPRC("getCurIndex"),
        currPage: $(this.container).sfGridSPRC("getCurPage")
    });
}

/*
 * Function: handleKeyDown
 *
 * Handles key events
 *
 */
ScenePhotoSelection.prototype.handleKeyDown = function(keyCode){
    alert("ScenePhotoSelection.handleKeyDown(" + keyCode + ")");
    // TODO : write an key event handler when this scene get focued
    switch (keyCode) {
        case $.sfKey.LEFT:
            this.prev();
            break;
        case $.sfKey.RIGHT:
            this.next();
            break;
        case $.sfKey.GREEN:
            $.sfScene.hide("PhotoSelection");
            $.sfScene.hide("MainTop");
            $.sfScene.show("Main");
            $.sfScene.show("MainRight");
            $.sfScene.show("HomeMenu");
            $.sfScene.focus("HomeMenu");
            break;
        case $.sfKey.YELLOW:
            this.select();
            this.paintBar();
            break;
        case $.sfKey.UP:
            this.up();
            break;
        case $.sfKey.DOWN:
            this.down();
            break;
        case $.sfKey.BLUE:
            this.markAll();
            this.paintBar();
            break;
        case $.sfKey.FF:
            this.nextPage();
            break;
        case $.sfKey.RW:
            this.prevPage();
            break;
        case $.sfKey.ENTER:
            $.sfScene.hide("PhotoSelection");
            $.sfScene.show("SlideShow");
            $.sfScene.focus("SlideShow");
            break;
        case $.sfKey.RETURN:
            $.sfKey.block(event);
            this.prevPage();
            break;
    }
}
