/*
 About: Author
 Kamil Parzniewski
 About: Date
 2010-10-14
 */
alert('ScenePopupOption.js loaded');

/*
 * Class: ScenePopupOption
 *
 * Class with PopupOption Scene, which is used to show slide show settings in popup.
 *
 *
 */
function ScenePopupOption(){
    this.mFocus = 0;
    this.mDivId = ["Selection", "Transition", "Speed"];
}

/*
 * Function: initialize
 *
 * Scene initialization
 *
 */
ScenePopupOption.prototype.initialize = function(){
    alert("ScenePopupOption.initialize()");
    
    $("#ComboTransition2").sfComboBox("maxComboLength", 5);
    $("#ComboSpeed2").sfComboBox("maxComboLength", 3);    

    $("#ComboTransition2").sfComboBox(transitionList);    
    $("#ComboSpeed2").sfComboBox(speedList);

    $("#ComboSpeed2").sfComboBox("return", function(index){
        speed = $("#ComboSpeed2").sfComboBox("comboIndex");
        $("#PopupSpeed").html(speedList[speed]);
        NGImageViewer.readParametersFromGlobals();
    });
    
    

    $("#ComboTransition2").sfComboBox("return", function(index){        
        activeTranistion = $("#ComboTransition2").sfComboBox("comboIndex");
        $("#PopupTransition").html(transitionList[activeTranistion]);
        NGImageViewer.readParametersFromGlobals();
    });
    
    $("#PopupTransition").html(transitionList[activeTranistion]);
    $("#PopupSpeed").html(speedList[speed]);       
}

/*
 * Function: handleShow
 *
 * Handles scene show
 * 
 */
ScenePopupOption.prototype.handleShow = function(data, scene){
    alert("ScenePopupOption.handleShow()");
    // this function will be called when the scene manager show this scene 
    $("#ComboTransition2").sfComboBox("setComboIndex", activeTranistion);
    $("#ComboSpeed2").sfComboBox("setComboIndex", speed);
    $("#PopupTransition").html(transitionList[activeTranistion]);
    $("#PopupSpeed").html(speedList[speed]);    

    var cssModification = new CSSModification();
    cssModification.changeBackground("#PopupBg");
    cssModification.changeBackground("#PopupLineThick");
    cssModification.changeBackground("#PopupLine0");
    cssModification.changeBackground("#PopupLine1");
    cssModification.changeBackground("#PopupLine2");
    cssModification.changeBackground("#PopupEnterImg");
    cssModification.changeBackground("#PopupExitImg");    
    
    $("#PopupSelection").css('background', '#000 url(images/' + graphicsDirectory + 'popup_box.png) no-repeat');
    $("#PopupTransition").css('background', '#000 url(images/' + graphicsDirectory + 'popup_box.png) no-repeat');
    $("#PopupSpeed").css('background', '#000 url(images/' + graphicsDirectory + 'popup_box.png) no-repeat');    
}

/*
 * Function: handleHide
 *
 * Handles scene hide
 * 
 */
ScenePopupOption.prototype.handleHide = function(){
    alert("ScenePopupOption.handleHide()");
    // this function will be called when the scene manager hide this scene  
}

/*
 * Function: handleFocus 
 *
 * Handles scene focus
 * 
 */
ScenePopupOption.prototype.handleFocus = function(){
    alert("ScenePopupOption.handleFocus()");
    // this function will be called when the scene manager focus this scene
    this._updateFocus("Select");
    
}

/*
 * Function: handleBlur 
 *
 * Handles scene blur
 * 
 */
ScenePopupOption.prototype.handleBlur = function(){
    alert("ScenePopupOption.handleBlur()");
    try {
        LocalXML.writeLocalXML();
    } 
    catch (e) {
        showPopupOk(e.message);
    }
    // this function will be called when the scene manager move focus to another scene from this scene
}

/*
 * Function: handleKeyDown 
 *
 * Handles key events
 * 
 */
ScenePopupOption.prototype.handleKeyDown = function(keyCode){
    alert("ScenePopupOption.handleKeyDown(" + keyCode + ")");
    // TODO : write an key event handler when this scene get focued
    switch (keyCode) {
        case $.sfKey.LEFT:
            break;
        case $.sfKey.RIGHT:
            break;
        case $.sfKey.UP:
            this._moveUp();
            break;
        case $.sfKey.DOWN:
            this._moveDown();
            break;
        case $.sfKey.ENTER:
            if (this.mFocus > 0) {
                this._slideCombobox(this.mDivId[this.mFocus]);
            }
            else {
				alert(">>>>>>>>>PhotoSelection");
                this._updateFocus("Normal");
                this.mFocus = 0;
                NGImageViewer.hide();
                $.sfScene.hide("PopupOption");
                $.sfScene.hide("SlideShow");
				$.sfScene.hide("DetailPage");
                $.sfScene.show("Main");
                $.sfScene.show("PhotoSelection");
                $.sfScene.focus("PhotoSelection");
            }
            break;
        case $.sfKey.RETURN:
            $.sfKey.block(event);
            this._updateFocus("Normal");
            this.mFocus = 0;
            $.sfScene.hide("PopupOption");
            $.sfScene.focus(ScenePopupOption.prototype.invocationScene);
            $.sf.returnFocus();
            break;
    }
}

/*
 * Function: _slideCombobox 
 *
 * Function calls ComboBox to slide up/down list
 * 
 */
ScenePopupOption.prototype._slideCombobox = function(type){
    alert("#Combo" + type+"2");
    $("#Combo" + type+"2").sfComboBox("SLIDEDOWN");
}

/*
 * Function: _moveUp 
 *
 * Function move focus up from one option menu to upper one
 * 
 */
ScenePopupOption.prototype._moveUp = function(){
    this._updateFocus("Normal");
    if (this.mFocus > 0) {
        this.mFocus--;
    }
    else {
        this.mFocus = 0;
    }
    this._updateFocus("Select");
}

/*
 * Function: _moveDown
 *
 * Function move focus down from one option menu to lower one
 * 
 */
ScenePopupOption.prototype._moveDown = function(){
    this._updateFocus("Normal");
    if (this.mFocus < 2) {
        this.mFocus++;
    }
    else {
        this.mFocus = 2;
    }
    this._updateFocus("Select");
}

/*
 * Function: _updateFocus
 *
 * Function updates focus for selected menu
 * 
 */
ScenePopupOption.prototype._updateFocus = function(type){
   if(type == "Select")
   {//css();
       $("#Popup" + this.mDivId[this.mFocus]).css('background', '#000 url(images/' + graphicsDirectory + 'popup_focus.png) no-repeat');
       $("#Popup" + this.mDivId[this.mFocus]).css('color','#3F2302');
       $("#"+this.mDivId[this.mFocus]+"Arrow").css('background', 'url(images/' + graphicsDirectory + 'option_arrow_sel.png) no-repeat');
   }
   else
   {
       $("#Popup" + this.mDivId[this.mFocus]).css('background', '#000 url(images/' + graphicsDirectory + 'popup_box.png) no-repeat');
       $("#Popup" + this.mDivId[this.mFocus]).css('color','#FFFFFF');
       $("#"+this.mDivId[this.mFocus]+"Arrow").css('background', 'url(images/' + graphicsDirectory + 'option_arrow_nor.png) no-repeat');    
   }
}
