/*
 About: Author
 Tomasz Scislo
 About: Date
 2010-10-14
 */
alert('SceneSlideShow.js loaded');

/*
 * Class: SceneSlideShow
 *
 * Class with SlideShow Scene, which is used to display slide show.
 *
 *
 */
function SceneSlideShow(){
    //Menu hide action time
    SceneSlideShow.prototype.menuDuration = 1100;
    //Time between button press and beginig of menu hide action
    SceneSlideShow.prototype.hideDuration = 3000;
}

/*
 * Function: paintBar
 *
 * Method to update HelpBar on the bottom of the scene.
 *
 */
SceneSlideShow.prototype.paintBar = function(){
    alert("SceneSlideShow.paintBar()");
    $('#SlideShowNationalGeoKeyHelp').sfKeyHelp({
        'green': 'Home',
        'yellow': 'Detail',
        'tools': 'Option',
        'leftright': 'Previous / Next',
        'rewff': 'Slow / Fast',
        'enter': ((NGImageViewer.fpause) ? 'Play' : 'Pause'),
        'return': 'Return'
    });
}

/*
 * Function: initialize
 *
 * Scene initialization
 *
 */
SceneSlideShow.prototype.initialize = function(){
    alert("SceneSlideShow.initialize()");
    var cssModification = new CSSModification();
    cssModification.changeBackground('#SlideShowOptionsTop');
	cssModification.changeBackground('#NGLogo');
	cssModification.changeBackground('#PlayPause');
}

/*
 * Function: showMenus
 *
 * Shows scene top and bottom bar.
 *
 */
SceneSlideShow.prototype.showMenus = function(){
    if (typeof SceneSlideShow.prototype.timeoutPtr !== "undefined") 
        clearTimeout(SceneSlideShow.prototype.timeoutPtr);
    alert("SceneSlideShow.showMenus()");
    if (!SceneSlideShow.prototype.menusShown && !SceneSlideShow.prototype.menuAction) {
        SceneSlideShow.prototype.menuAction = true;
        $('#SlideShowNationalGeoKeyHelp').animate({
            top: parseInt($('#SlideShowNationalGeoKeyHelp').css('top')) - $('#SlideShowNationalGeoKeyHelp').height()
        }, {
            duration: SceneSlideShow.prototype.menuDuration
        });
        $('#SlideShowOptionsTop').animate({
            top: parseInt($('#SlideShowOptionsTop').css('top')) + $('#SlideShowOptionsTop').height()
        }, {
            duration: SceneSlideShow.prototype.menuDuration,
            complete: function(){
                SceneSlideShow.prototype.menusShown = true;
                SceneSlideShow.prototype.menuAction = false;
            }
        });
    }
    SceneSlideShow.prototype.timeoutPtr = setTimeout(SceneSlideShow.prototype.hideMenus, 3000);
};

/*
 * Function: hideMenus
 *
 * Hides scene top and bottom bar.
 *
 */
SceneSlideShow.prototype.hideMenus = function(){
    alert("SceneSlideShow.hideMenus()");
    if (SceneSlideShow.prototype.menusShown && !SceneSlideShow.prototype.menuAction) {
        SceneSlideShow.prototype.menuAction = true;
        $('#SlideShowNationalGeoKeyHelp').delay(SceneSlideShow.prototype.hideDuration).animate({
            top: parseInt($('#SlideShowNationalGeoKeyHelp').css('top')) + $('#SlideShowNationalGeoKeyHelp').height()
        }, {
            duration: SceneSlideShow.prototype.menuDuration
        });
        $('#SlideShowOptionsTop').delay(SceneSlideShow.prototype.hideDuration).animate({
            top: parseInt($('#SlideShowOptionsTop').css('top')) - $('#SlideShowOptionsTop').height()
        }, {
            duration: SceneSlideShow.prototype.menuDuration,
            complete: function(){
                SceneSlideShow.prototype.menusShown = false;
                SceneSlideShow.prototype.menuAction = false;
            }
        });
    }
};

/*
 * Function: handleShow
 *
 * Handles scene show
 *
 */
SceneSlideShow.prototype.handleShow = function(data){
    alert("SceneSlideShow.handleShow()");
    // this function will be called when the scene manager show this scene 
    $.sfScene.hide("MainRight");
    NGImageViewer.prepareEffects();
    NGImageViewer.readParametersFromGlobals();
    this.paintBar();
}

/*
 * Function: handleHide
 *
 * Handles scene hide
 *
 */
SceneSlideShow.prototype.handleHide = function(){
    alert("SceneSlideShow.handleHide()");
    // this function will be called when the scene manager hide this scene  
}

/*
 * Function: handleFocus
 *
 * Handles scene focus
 *
 */
SceneSlideShow.prototype.handleFocus = function(){
    alert("SceneSlideShow.handleFocus()");
    // this function will be called when the scene manager focus this scene
}

/*
 * Function: handleBlur
 *
 * Handles scene blur
 *
 */
SceneSlideShow.prototype.handleBlur = function(){
    alert("SceneSlideShow.handleBlur()");
    // this function will be called when the scene manager move focus to another scene from this scene
}

/*
 * Function: handleKeyDown
 *
 * Handles key events
 *
 */
SceneSlideShow.prototype.handleKeyDown = function(keyCode){
    alert("SceneSlideShow.handleKeyDown(" + keyCode + ")");
    SceneSlideShow.prototype.showMenus();
    // TODO : write an key event handler when this scene get focued
    switch (keyCode) {
        case $.sfKey.RETURN:
            $.sfKey.block(event);
            NGImageViewer.hide();
            $.sfScene.hide("MainTop");
            $.sfScene.hide("SlideShow");
            $.sfScene.show("Main");
            $.sfScene.show("MainRight");
            $.sfScene.show("HomeMenu");
            break;
        case $.sfKey.LEFT:
            NGImageViewer.prev(true);
            break;
        case $.sfKey.RIGHT:
            NGImageViewer.next(true);
            break;
        case $.sfKey.FF:
            NGImageViewer.FF();
            break;
        case 69:
            NGImageViewer.REW();
            break;
        case 74:
            NGImageViewer.pause();
            this.paintBar();
            break;
        case 71:
            NGImageViewer.resume();
            this.paintBar();
            break;
        case $.sfKey.ENTER:
            NGImageViewer.pauseResume();
            this.paintBar();
            break;
        case $.sfKey.TOOLS:
            ScenePopupOption.prototype.invocationScene = "SlideShow";
            $.sfScene.show("PopupOption");
            $.sfScene.focus("PopupOption");
            break;
        case $.sfKey.YELLOW:
            NGImageViewer.hide();
            $.sfScene.hide("SlideShow");
            $.sfScene.hide("MainRight");
            $.sfScene.show("Main");
            $.sfScene.show("MainTop");
            $.sfScene.show("DetailPage");
            $.sfScene.focus("DetailPage");
            break;
        case $.sfKey.GREEN:
            NGImageViewer.hide();
            NGImageViewer.stopAnimation();
            $.sfScene.hide("SlideShow");
            $.sfScene.show("Main");
            $.sfScene.show("MainRight");
            $.sfScene.show("HomeMenu");
            $.sfScene.focus("HomeMenu");
            break;
    }
}
