/**
 * @author k.parzniewsk@samsung.com
 */

(function($){
    $.sf.loadCSS("app/stylesheets/ComboBox.css");
})(jQuery);

(function($){
    $.fn.sfComboBox = function(options, value)
    {
        alert("Inside ComboBox");
        if(!(this.data("pluginName") == "sfComboBox"))
        {
            alert("FIRST START");
            this.data("pluginName","sfComboBox");
            this.data("onReturn",null);
            this.data("init",false);
            
            this.data("maxComboLength",5);
            this.data("comboItems",[]);
            this.data("comboIndex",-1);
            this.data("comboListIndex",-1);
            this.data("show",false);
            this.data("ANCHOR_ID",("_sf_combo_box_"+this.attr("id")));
            this.data("ownerId",this.attr("id"));
        };

        if(typeof  options == "object")
        {
            addToList(this,options);
            HtmlView(this);
        }
        else if(typeof options == "string")
        {
            options = options.toUpperCase();
            if(options == "SLIDEDOWN")
            {
                if(!this.data("init"))
                {
                    initialize(this);
                }
                slideDown(this);
            }
            else if(options == "SETCOMBOINDEX")
            {
                this.data("comboListIndex",value);
                UpdateView(this);
            }
			else if(options == "COMBOINDEX") {
				return this.data("comboListIndex");
			}
            else if(options == "RETURN")
            {
                if(typeof value == "function")
                {
                    this.data("onReturn",value);
                }
            }
            else if(options == "MAXCOMBOLENGTH")
            {
                this.data("maxComboLength",value);
            }
        }
    }
    
    $.fn.sfComboBox.handleKeydown = function(self)
    {
        var keyCode = event.keyCode;
        alert("handleKeydown()");
        switch (keyCode) 
        {
            case $.sfKey.LEFT:
                break;
            case $.sfKey.RIGHT:
                break;
            case $.sfKey.UP:
                moveUp(self);
                break;
            case $.sfKey.DOWN:
                moveDown(self);
                break;
            case $.sfKey.ENTER:
                $.sfKey.block();
                self.find("#list"+0).removeClass("select");
                self.find("#list"+0).removeClass("normal");
                slideDown(self);
                break;
            case $.sfKey.RETURN:
            case $.sfKey.EXIT:
                $.sfKey.block();
                break;
            case $.sfKey.INFO:
                break;
        }        
    }
    
    function initialize(self)
    {
        try
        {
            alert("init ComboBox");
            $("<a href='javascript:void(0)' id='"+self.data("ANCHOR_ID")+"'></a>").appendTo('body');
            var timer = setTimeout(function()
            {
                $("#"+self.data("ANCHOR_ID")).keydown(function()
                {
                    $.fn.sfComboBox.handleKeydown(self);
                });
            },0);
            self.data("init",true);
        }
        catch(e)
        {
            alert(e.toString());
        }
    }
    
    function moveUp(self)
    {
        alert("moveUp()");
        removeFocus(self,self.data("comboIndex"));
        var num = parseInt(self.data("comboListIndex"));
        if((--num)  < 0)
        {
            self.data("comboIndex",0);
            self.data("comboListIndex",0);
        }
        else
        {
            if(num > (self.data("maxComboLength")-1))
            {
                self.data("comboListIndex", num);
            }
            else
            {
                self.data("comboIndex", num);
                self.data("comboListIndex", num);                
            }
            

        }
        alert(self.data("comboIndex"));
        alert(self.data("comboListIndex"));
        UpdateHtml(self);
        setFocus(self,self.data("comboIndex"));
    }
    
    function moveDown(self)
    {
        alert("moveDown()");
        removeFocus(self,self.data("comboIndex"));
        var num = parseInt(self.data("comboListIndex"));
        if((++num) > (self.data("maxComboLength")-1))
        {
            self.data("comboIndex", (self.data("maxComboLength")-1));
            if(num > (self.data("comboItems").length-1))
            {
                self.data("comboListIndex", (self.data("comboItems").length-1));
            }
            else
            {
                self.data("comboListIndex", num);
            }
        }
        else
        {
            self.data("comboIndex", num);
            self.data("comboListIndex", num);
        }
        alert(self.data("comboIndex"));
        alert(self.data("comboListIndex"));        
        UpdateHtml(self);
        setFocus(self,self.data("comboIndex"));
    
    }
    
    function slideDown(self)
    {
        var menuId = "_menu_"+self.data("ownerId");
        var handle = self.data("ownerId")+"Scroll";
        alert(menuId);
        alert(handle);
        if(!self.data("show"))
        {
            if(parseInt(self.data("comboListIndex")) >= parseInt(self.data("maxComboLength")))
            {
                self.data("comboIndex",parseInt(self.data("maxComboLength"))-1);
            }
            else
            {
                self.data("comboIndex",self.data("comboListIndex"));
            }
            alert("function slideDown(self)_____"+self.data("comboIndex"));
            UpdateHtml(self);
            
            for(var i= 0; i < self.data("comboItems").length; ++i)
            {
                self.find("#list"+i).css("visibility","visible");
                var height = parseInt(self.find("#list"+i).css("height"));
                self.find("#list"+i).css("top",((i*height)+1)+"px").show();
                //self.find("#list"+i).addClass("select");
                removeFocus(self,i);
            } 
            alert(parseInt(self.find("#list0").css("height")));
            alert(parseInt(self.find("#list0").css("width")));
            setFocus(self,self.data("comboIndex"));
            self.data("show",true);
            //alert("Handle test: "+countScrollHeight(self));
            var tmp = countScrollHeight(self);
            $("#"+handle+" .ComboBoxScrollHandle").css("height",tmp+"px")
            $("#"+handle).show();
            $("#"+self.data("ANCHOR_ID")).focus();
        }
        else
        {
            UpdateView(self);
                       
            $("#"+menuId+" div").hide();
            self.data("show",false);
            self.find("#list"+0).removeClass("focus");
            self.data("onReturn")(self.data("comboListIndex"));
            $("#"+handle).hide();
            $.sf.returnFocus();
        }
    }
    
    function countScrollHeight(self)
    {
        var height = 0;
        height = (parseInt(self.find("#list0").css("height"))*parseInt(self.data("maxComboLength")))/parseInt(self.data("comboItems").length);
        return height;
    }
    
    function removeFocus(self,index)
    {
        //alert("removeFocus("+index+")");
        //self.find("#list"+index).removeClass("focus");
        self.find("#list"+index).css('background', 'url(images/' + graphicsDirectory + 'option_pull_down.png) no-repeat');
        self.find("#list"+index).css('vertical-align', 'middle');
        self.find("#list"+index).css('color', '#000000');
        //self.find("#list"+index).addClass("select");        
    }
    
    function setFocus(self,index)
    {
        //alert("setFocus("+index+")");
        //self.find("#list"+index).removeClass("select");
        self.find("#list"+index).css('background', 'url(images/' + graphicsDirectory + 'option_pull_down_focus.png) no-repeat');
        self.find("#list"+index).css('vertical-align', 'middle');
        self.find("#list"+index).css('color', '#FFFFFF');
        //self.find("#list"+index).addClass("focus");
        
    }
    
    function addToList(self,value)
    {
        if( value.constructor != Array)
        {
            value = [value];
        }
        self.data("comboItems",value);
    }
    
    function UpdateHtml(self)
    {
        for(var i = 0; i < parseInt(self.data("maxComboLength")); ++i)
        {
            if(parseInt(self.data("comboListIndex")) >= parseInt(self.data("maxComboLength")))
            {
                var num = self.data("comboListIndex") - (self.data("maxComboLength")-1);
                //alert("UpdateHtml(self) "+(i+num));
                self.find("#list"+i).html(self.data("comboItems")[i+num]);
            }
            else
            {
                //alert("UpdateHtml() index= "+i);
                self.find("#list"+i).html(self.data("comboItems")[i]);
            }
        }
        var handle = self.data("ownerId")+"Scroll";
        var tmp = countScrollHeight(self);
        $("#"+handle+" .ComboBoxScrollHandle").css("height",tmp+"px")
        $("#"+handle+" .ComboBoxScrollHandle").css("top",(parseInt(self.data("comboListIndex"))*tmp)+"px")
    }
    
    function UpdateView(self)
    {
        if(parseInt(self.data("comboListIndex")) >= parseInt(self.data("maxComboLength")))
        {
            self.data("comboIndex",parseInt(self.data("maxComboLength"))-1);
            //alert("function UpdateView(self) 1: "+self.data("comboIndex"));
        }
        else
        {
            self.data("comboIndex",self.data("comboListIndex"));
            //alert("function UpdateView(self) 2: "+self.data("comboIndex"));
        }
        
        var tmp = self.find("#list"+0).html();
        if(self.data("comboItems")[self.data("comboListIndex")] != tmp)
        { 
            self.find("#list"+0).html(self.data("comboItems")[self.data("comboListIndex")]);        
        }    
    }
    
    function HtmlView(self)
    {
        var menuId = "_menu_"+self.data("ownerId");
        $("<div id='"+menuId+"' class='ul'></div>").appendTo("#"+self.data("ownerId"));
        var handle = self.data("ownerId")+"Scroll";
        $("<div id='"+handle+"' ><div class='ComboBoxScrollHandle'></div></div>").appendTo("#"+self.data("ownerId"));
        $("#"+handle).hide();
        for(var i = 0; i < parseInt(self.data("maxComboLength")); ++i)
        {
            var listElem = $("<div id=list"+i+">"+self.data("comboItems")[i]+"</div>");
            listElem.addClass("li");
            if(i != 0)
            {
                listElem.css("visibility","hidden");
            }
            $("#"+menuId).append(listElem);
            var height = parseInt(self.find("#list"+i).css("height"));
            self.find("#list"+i).css("top",((i*height)+1)+"px");
        }

        if(parseInt(self.data("comboListIndex")) == -1 || parseInt(self.data("comboList")) == -1)
        {
            //alert("____________INIT VALUES____________");
            self.data("comboListIndex",0);
            self.data("comboList",0);
        }
        
        if(parseInt(self.data("comboListIndex")) >= parseInt(self.data("maxComboLength")))
        {
            self.data("comboIndex",4);
            //alert("function HtmlView(self) 1: "+self.data("comboIndex"));
        }
        else
        {
            self.data("comboIndex",self.data("comboListIndex"));
            //alert("function HtmlView(self) 2: "+self.data("comboIndex"));
        }
        UpdateHtml(self);        
        
        var tmp = self.find("#list"+0).html();
        self.find("#list"+0).html(self.find("#list"+self.data("comboIndex")).html());
        self.find("#list"+self.data("comboIndex")).html(tmp);        
        
        $("#"+menuId+" div").hide();
    }
})(jQuery);
