/**
 * @author k.parzniewsk@samsung.com
 * You NEED proper css file to run this component / look inside Example project for proper css
 */

(function($) {
	// load CSS
	$.sf.loadCSS("app/stylesheets/HTMLPanel.css");
})(jQuery);

(function($){
    $.fn.sfHtmlPanel = function(options,value)
    {
        alert("Inside HTMLPanel");
        if(!(this.data("pluginName") == "HTMLPanel"))
        {
            this.data("pluginName","HTMLPanel");
            this.data("animate",false);
            this.data("ownerId",this.attr("id"));
            this.data("ANCHOR_ID",("_html_panel_"+this.attr("id")));
            this.data("init",false);
            this.data("scrollPos",0);
            this.data("speed",0);
            this.data("step",300);
            this.data("focus","Main");
            this.data("pages",1);
        }

        if(typeof options == "string")
        {
            if(options == "init")
            {
                if(!(this.data("init")))
                {
                    alert("init panel");
                    InitializeHtmlPanel(this);
                }
                HtmlView(this);
            }
            else if(options = "focus")
            {
				scrollHandlerFocus("Select");
                $("#"+this.data("ANCHOR_ID")).focus();
            }
        }
        
        if(typeof options == "object")
        {
            alert(options);
            alert(value);
            var self = this;
            $.each(options, function(key, value)
            {
                if(key == "text")
                {
                    setPanelText(self,value);
                }
                else if(key == "animate")
                {
                    self.data("animate",value);
                }
                else if(key == "speed")
                {
                    self.data("speed",parseInt(value));
                }
                else if(key == "step")
                {
                    self.data("step",parseInt(value));                    
                }
                else if(key == "focus")
                {
                    self.data("focus",value);  
                }
                alert(key);
                alert(value);
            });
            self = null;
        }
        
    }
    
    $.fn.sfHtmlPanel.handleKeydown = function(self)
    {
        var keyCode = event.keyCode;
        alert("handleKeydown()");
        switch (keyCode) 
        {
            case $.sfKey.LEFT:
                break;
            case $.sfKey.RIGHT:
                break;
            case $.sfKey.UP:
                moveUp(self);
                break;
            case $.sfKey.DOWN:
                moveDown(self);
                break;
            case $.sfKey.ENTER:
                break;
            case $.sfKey.RETURN:
            case $.sfKey.EXIT:
                $.sfKey.block();
                scrollHandlerFocus("Normal")
				$.sfScene.focus(self.data("focus"));
                $.sf.returnFocus();
                break;
            case $.sfKey.INFO:
                break;
        }            
    }
    
    function InitializeHtmlPanel(self)
    {
        try
        {
            alert("InitializeHtmlPanel");
            $("<a href='javascript:void(0)' id='"+self.data("ANCHOR_ID")+"'></a>").appendTo('body');
            var timer = setTimeout(function()
            {
                $("#"+self.data("ANCHOR_ID")).keydown(function()
                {
                    $.fn.sfHtmlPanel.handleKeydown(self);
                });
            },0);
            self.data("init",true);
        }
        catch(e)
        {
            alert(e.toString());
        }
    }
    
	function scrollHandlerFocus(focus)
	{
		$("#htmlSliderHandle").removeClass();
		$("#htmlSliderHandle").addClass("Handle"+focus);
	}

    function moveDown(self)
    {
        var scrollHeight = (parseInt(self.find("#htmlSliderHandle").css("height"))*parseInt(self.find("#htmlSlider").css("height")))/100.0;
        if(parseInt(self.data("scrollPos")) < (parseInt($("#htmlPanel").attr("scrollHeight")) - parseInt($("#htmlPanel").css("height")) - self.data("step")))
        {
            var scrollPanelPos = parseInt(self.data("scrollPos")) + self.data("step");
            var scrollBarPos = parseInt(scrollPanelPos/$("#htmlPanel").attr("scrollHeight")*100);
        }
        else
        {
            var scrollPanelPos = parseInt($("#htmlPanel").attr("scrollHeight")) - parseInt($("#htmlPanel").css("height"));
            var scrollBarPos = 100.0 - ((scrollHeight/parseInt($("#htmlPanel").css("height")))*100.0);
        }
        
        var page = parseInt((scrollBarPos+1) / (100/self.data("pages")))+1;
        $("#htmlPageCnt").html(page+"/"+self.data("pages"));
        
        self.find("#htmlSliderHandle").animate({"top": scrollBarPos+"%"},self.data("speed"));
        $("#htmlPanel").animate({scrollTop: scrollPanelPos }, self.data("speed"));
        self.data("scrollPos",scrollPanelPos);
    }
    
    function moveUp(self)
    {
        var scrollHeight = (parseInt(self.find("#htmlSliderHandle").css("height"))*parseInt(self.find("#htmlSlider").css("height")))/100;
        if(parseInt(self.data("scrollPos")) > self.data("step"))
        {
            var scrollPanelPos = parseInt(self.data("scrollPos")) - self.data("step");
            var scrollBarPos = parseInt(scrollPanelPos/$("#htmlPanel").attr("scrollHeight")*100);
        }
        else
        {           
            var scrollPanelPos = 0;
            var scrollBarPos = 0;
        }
        
        var page = parseInt((scrollBarPos+1) / (100/self.data("pages")))+1;
        $("#htmlPageCnt").html(page+"/"+self.data("pages"));
        
        self.find("#htmlSliderHandle").animate({"top": scrollBarPos+"%"},self.data("speed"));
        $("#htmlPanel").animate({scrollTop: scrollPanelPos }, self.data("speed"));
        self.data("scrollPos",scrollPanelPos);
    }
    
    function HtmlView(self)
    {
        var panelId = "_html_"+self.data("ownerId");
        var mainElem = $("<div id='"+panelId+"'></div>");
        mainElem.appendTo("#"+self.data("ownerId"));
        var mainPanel = $("<div id='mainWnd'><div id='htmlPageCnt''></div><div id='htmlSlider''></div><div id='htmlPanel'></div></div>");
        mainElem.append(mainPanel);
    }
    
    function setPanelText(self,value)
    {
        $("#htmlPanel").html(value);      
        var scrollHeight = parseInt($("#htmlPanel").attr("scrollHeight"));
        var height = parseInt($("#htmlPanel").height());
        if( scrollHeight <= height )
        {
            var slideHeight = ((parseInt($("#htmlPanel").css("height"))/$("#htmlPanel").attr("scrollHeight"))*100.0);
            $("<div id='htmlSliderHandle' class='HandleNormal'></div>").css("height",slideHeight+"%").appendTo("#htmlSlider");
            $("#htmlSliderHandle").css("top","0%");
            $("#htmlPageCnt").html("1/1");
        }
        else
        {
            if(!(self.data("animate")))
            {
                var emptyDiv = $("<div id='emptyHtmlDiv'></div>");
                var emptyDivHeight = (parseInt($("#htmlPanel").css("height")) - 1) - (parseInt($("#htmlPanel").attr("scrollHeight")) % parseInt($("#htmlPanel").css("height")));
                emptyDiv.css("height", emptyDivHeight+"px");
                $("#htmlPanel").append(emptyDiv);
                self.data("step",parseInt($("#htmlPanel").css("height")));
            }
            alert("Full panel height "+$("#htmlPanel").attr("scrollHeight"));
            var slideHeight = ((parseInt($("#htmlPanel").css("height"))/$("#htmlPanel").attr("scrollHeight"))*100.0);
            $("<div id='htmlSliderHandle' class='HandleNormal'></div>").css("height",slideHeight+"%").appendTo("#htmlSlider");
            $("#htmlSliderHandle").css("top","0%");
            var pageNb = parseInt($("#htmlPanel").attr("scrollHeight")/parseInt($("#htmlPanel").css("height")));
            self.data("pages",pageNb);
            $("#htmlPageCnt").html("1/"+pageNb);
        }
    }
    
})(jQuery);
