/*
 About: Author
 Tomasz Scislo
 Date: 2010-10-15
 
 USAGE:
 If you decide to use this jquery_sprc_patch.js with Samsung Framework you must know that assigning values using $.data
 is 100% secure and valid for DOM objects, to which we can assign attributes. For other objects such as document object
 patch still uses jQuery originall assignment, which is not secure for jQuery and Samsung Framework so you have to be careful
 with that.
 */
$(function(){
    jQuery.event.handle = function(event){
        var all, handlers, namespaces, namespace, events;
        
        event = arguments[0] = jQuery.event.fix(event || window.event);
        event.currentTarget = this;
        
        // Namespaced event handlers
        all = event.type.indexOf(".") < 0 && !event.exclusive;
        
        if (!all) {
            namespaces = event.type.split(".");
            event.type = namespaces.shift();
            namespace = new RegExp("(^|\\.)" +
            namespaces.slice(0).sort().join("\\.(?:.*\\.)?") +
            "(\\.|$)");
        }
        
        // patch
        // if browser is unable to use data method to store events throws
        // exeption
        try {
            var events = jQuery.data(this, "events"), handlers = events[event.type];
            if (events && handlers) {
                // Clone the handlers to prevent manipulation
                handlers = handlers.slice(0);
                
                for (var j = 0, l = handlers.length; j < l; j++) {
                    var handleObj = handlers[j];
                    
                    // Filter the functions by class
                    if (all || namespace.test(handleObj.namespace)) {
                        // Pass in a reference to the handler function itself
                        // So that we can later remove it
                        event.handler = handleObj.handler;
                        event.data = handleObj.data;
                        event.handleObj = handleObj;
                        
                        var ret = handleObj.handler.apply(this, arguments);
                        
                        if (ret !== undefined) {
                            event.result = ret;
                            if (ret === false) {
                                event.preventDefault();
                                event.stopPropagation();
                            }
                        }
                        
                        if (event.isImmediatePropagationStopped()) {
                            break;
                        }
                    }
                }
            }
            
            return event.result;
        } 
        catch (e) {
            return null;
        }
        
    };
    
    function now(){
        return (new Date).getTime();
    }
    
    var expando = "jQuery" + now(), uuid = 0, windowData = {};
    
    jQuery.extend({
        cache: {},
        
        expando: expando,
        
        // The following elements throw uncatchable exceptions if you
        // attempt to add expando properties to them.
        noData: {
            "embed": true,
            "object": true,
            "applet": true
        },
        
        /*
         * Function: data
         *
         * Patched $.data method
         *
         */
        data: function(elem, name, data){
            if (elem.nodeName && jQuery.noData[elem.nodeName.toLowerCase()]) {
                return;
            }
            
            elem = elem == window ? windowData : elem;
            
            // orginal jQuery version
            // var id = elem[ expando ], cache = jQuery.cache, thisCache;
            
            // patch
            // for DOM object use Attributes
            if (typeof elem.getAttribute == "function") 
                var id = elem.getAttribute(expando);
            // for other use standard extending approach
            else {
                var id = elem[expando];
            }
            
            var cache = jQuery.cache, thisCache;
            
            if (!id && typeof name === "string" && data === undefined) {
                return null;
            }
            
            // Compute a unique ID for the element
            if (!id) {
                id = ++uuid;
            }
            
            // Avoid generating a new cache unless none exists and we
            // want to manipulate it.
            if (typeof name === "object") {
                // orginal jQuery version
                // elem[expando] = id;
                // patch
                // for other use standard extending approach
                if (typeof elem.setAttribute == "function") 
                    elem.setAttribute(expando, id);
                // for other use standard extending approach
                else {
                    elem[expando] = id;
                }
                thisCache = cache[id] = jQuery.extend(true, {}, name);
                
            }
            else 
                if (!cache[id]) {
                    // orginal jQuery version
                    // elem[expando] = id;
                    // patch
                    // for other use standard extending approach
                    if (typeof elem.setAttribute == "function") 
                        elem.setAttribute(expando, id);
                    // for other use standard extending approach
                    else {
                        elem[expando] = id;
                    }
                    
                    cache[id] = {};
                }
            
            thisCache = cache[id];
            
            // Prevent overriding the named cache with undefined values
            if (data !== undefined) {
                thisCache[name] = data;
            }
            
            return typeof name === "string" ? thisCache[name] : thisCache;
        },
        
        removeData: function(elem, name){
            if (elem.nodeName && jQuery.noData[elem.nodeName.toLowerCase()]) {
                return;
            }
            
            elem = elem == window ? windowData : elem;
            
            var id = elem[expando], cache = jQuery.cache, thisCache = cache[id];
            
            // If we want to remove a specific section of the element's data
            if (name) {
                if (thisCache) {
                    // Remove the section of cache data
                    delete thisCache[name];
                    
                    // If we've removed all the data, remove the element's cache
                    if (jQuery.isEmptyObject(thisCache)) {
                        jQuery.removeData(elem);
                    }
                }
                
                // Otherwise, we want to remove all of the element's data
            }
            else {
                if (jQuery.support.deleteExpando) {
                    delete elem[jQuery.expando];
                    
                }
                else 
                    if (elem.removeAttribute) {
                        elem.removeAttribute(jQuery.expando);
                    }
                
                // Completely remove the data cache
                delete cache[id];
            }
        }
    });
});
