/**
 * @author Bartlomiej Koper
 * 
 * sfGridSPRC
 * 
 * properties:
 * 		firstIndexOnPage
 * 		lastIndexOnPage
 * 		index
 * 		data
 * 		stuif
 * 		page
 * 		pages
 * 		perRow
 * 
 * methods:
 * 		next
 * 		prev
 * 		up
 * 		down
 * 		nextPage
 * 		prevPage
 * 		focus
 * 		blur
 * 		getCurPage
 * 		getCurIndex
 * 		getPageNb
 * 
 * html:
 * <div>
 * 	<div id="sfGridSPRCItem0" class="sfGridSPRCItem sfGridSPRC-focus"></div>
 *  <div id="sfGridSPRCItem1" class="sfGridSPRCItem"></div>
 *  <div id="sfGridSPRCItem2" class="sfGridSPRCItem"></div>
 *  <div id="sfGridSPRCItem3" class="sfGridSPRCItem"></div>
 *  ...
 *  <div id="sfGridSPRCItem3" class="sfGridSPRCItem"></div>
 * </div>
 * 
 */
(function($){
    $.fn.sfGridSPRC = function(options, value){
		if (!(this.data('sfui') == 'sfGridSPRC')) {					
			// Temporary reInit with new options object bug fix (TO DO: Fix in other way)
            if (typeof options.data === "undefined") {
                alert("D sfGridSPRC ReInit!!!")
                options = value;
                alert("D sfGridSPRC ReInit options.data" + options.data);
				initialize(this, options);
            }		
			onCreate(this, options.index);		
		}
		
		
		if (typeof options == 'string') {
			switch (options) {
				case 'next':
					next(this);
					break;
				case 'prev':
					prev(this);
					break;
				case 'up':
					up(this);
					break;
				case 'down':
					down(this);
					break;
				case 'nextPage':
					nextPage(this);
					break;
				case 'prevPage':
					prevPage(this);
					break;
				case 'focus':
					focus(this)
					break;
				case 'blur':
					blur(this)
					break;
				case 'getCurPage':
					return this.data('page');
					break;
				case 'getPages':
					return this.data('pages');
					break;
				case 'getCurIndex':
					return this.data('index');
					break;
				case 'init':
            		initialize(this, value);
                    break;
			}
		}
		
		/**
		 * Functions
		 */
		
		/**
		 * Constructor
		 * @param {Object} self
		 * @param {Object} index
		 */
		function onCreate(self, index){
			alert("D sfGridSPRC onCreate")
			
			self
				.addClass('sfGridSPRC')
				.data('sfui', 'sfGridSPRC')
				.data('itemsPerPage', options.itemsPerPage)
				.data('perRow', options.perRow)
				.data('itemsNb', options.data.length)
				.data('data', options.data)
				.data('index', options.index)
				.data('page', 0)
				.data('pages', Math.ceil( options.data.length / options.itemsPerPage ));
			insertPage(self, 0);
							
			var data = self.data('data');
			var first = self.data('firstIndexOnPage');
			var last = self.data('lastIndexOnPage');
			for(var i = first; i < last; i++){
				$("#sfGridSPRCItem" + i).html(data[i]);
			}
			
			focus(self, self.data('index'));
		}
		
		/**
		 * Function to initialize component with new data
		 * Required options.currPage = page no on which one wants
		 * to initialize component
		 * @author Tomasz Scislo
		 */
		function initialize(self, options) {
			 self.addClass('sfGridSPRC')
			.data('sfui', 'sfGridSPRC')
			.data('itemsPerPage', options.itemsPerPage)
			.data('perRow', options.perRow)
			.data('itemsNb', options.data.length)
			.data('data', options.data)
			.data('index', options.index)
			.data('page', options.currPage)
			.data('pages', Math.ceil(options.data.length / options.itemsPerPage));
            insertPage(self, self.data('page'));
			focus(self, self.data('index'));
		}
		
		/**
		 * 
		 * @param {Object} self - this pointer
		 * @param {Object} page - page to display 
		 * @param {Object} index - index to select (optional)
		 */
		function insertPage(self, page){
			self.empty();
						
			self.data('page',page);
			var pages = self.data('pages');
			var itemsPerPage = self.data('itemsPerPage');
			var itemsNb = self.data('itemsNb')
			 
			var firstEl = page * itemsPerPage;
			var lastEl = (firstEl + itemsPerPage) < itemsNb ? firstEl + itemsPerPage : itemsNb;
			
			/*
			 * border values
			 */
			if (page >= pages) {
				insertPage(self, 0);
				return;
			}				
			
			if ( page < 0 ) {
				insertPage(self, pages - 1, self.data('itemsNb')-1 );
				return;
			}	
			
			var data = self.data('data');
			self.data('firstIndexOnPage', firstEl);
			self.data('lastIndexOnPage', lastEl);									
			for (var i = firstEl; i < lastEl; i++) {
				self.append('<div class="sfGridSPRCItem" id="sfGridSPRCItem' + i + '" >' + data[i] + '</div>')
								
			}						
		}
		
		function nextPage(self){
			var page = self.data('page');
			var pages = self.data('pages');
			page + 1 >= pages ? page = 0 : page++;
			insertPage(self, page);
			
			var index = self.data('index');
			var last = self.data('lastIndexOnPage');
			var first = self.data('firstIndexOnPage');
			var perPage = self.data('itemsPerPage');
			var newIndex;
			newIndex = index + perPage;
			if( newIndex < first  ) newIndex = first;
			if( newIndex > last ) newIndex = first;
			focus(self, newIndex);
		}
		
		function prevPage(self){
			var page = self.data('page');
			var pages = self.data('pages');
			page - 1 < 0 ? page = pages-1 : page--;
			insertPage(self, page);
			
			var index = self.data('index');
			var perPage = self.data('itemsPerPage');
			var first = self.data('firstIndexOnPage');
			var last = self.data('lastIndexOnPage');
			var newIndex;
			newIndex = index - perPage;
			if( newIndex < first ) newIndex = last-1 
			focus(self, newIndex);
		}		
		
		function next(self){
			var index = self.data('index');
			var last = self.data('lastIndexOnPage');
			var itemsNb = self.data('itemsNb');
			var newIndex = ++index;
			if( newIndex >= last) insertPage(self, self.data('page') + 1)
			if( newIndex >= itemsNb) newIndex = 0;
			focus(self, newIndex); 
		}
		
		function prev(self){
			var index = self.data('index');
			var first = self.data('firstIndexOnPage');
			if ((index - 1) < first) {
				insertPage(self, self.data('page') - 1);
				focus(self, self.data('lastIndexOnPage') - 1 );
			} else 
				focus(self, --index);
		}
		
		function down(self){
			var index = self.data('index');
			var perRow = self.data('perRow');
			var last = self.data('lastIndexOnPage');	
			var itemsNb = self.data('itemsNb');	
			var newIndex = index + perRow;
			
			if( newIndex >= last )	insertPage(self, self.data('page') + 1)
			if( newIndex >= itemsNb){
				if( self.data('page')+1 == self.data('pages') ) 
					newIndex = self.data('lastIndexOnPage') - 1;
				else 
					newIndex = self.data('firstIndexOnPage');
			}
			
			focus(self, newIndex); 
		}
		
		function up(self){
			var index = self.data('index');
			var perRow = self.data('perRow');
			var first = self.data('firstIndexOnPage');	
			var itemsNb = self.data('itemsNb');	
			var newIndex = index - perRow;
			
			if( newIndex < first ){
				insertPage(self, self.data('page') - 1)				
			} 
			
			if( newIndex < 0 ) newIndex = self.data('lastIndexOnPage')-1;
			focus(self, newIndex);
				
		}
		
		function focus(self, el){		
			if( typeof(el) != "undefined") self.data('index',el);			
			self.children('div').removeClass('sfGridSPRC-focus').removeClass('sfGridSPRC-blur');
			var jQuertItem =  $('#sfGridSPRCItem' + self.data('index') );
			if(jQuertItem.length != 0 )	jQuertItem.addClass('sfGridSPRC-focus');
		}
		
		function blur(self, el){		
			self.data('index',el);			
			self.children('div').removeClass('sfGridSPRC-focus').removeClass('sfGridSPRC-blur');
			var jQuertItem =  $('#sfGridSPRCItem' + self.data('index') );
			if(jQuertItem.length != 0 )	jQuertItem.addClass('sfGridSPRC-blur');
		}
		
	}
})(jQuery);

