
var previous_bets;
var new_round;


function print_previous_bets() {
	var str = "";
	for (var i=0; i<previous_bets.length; i++) {

		str += _global.env.GAME.players[i+1].name + ": ";

		for (var j=0; j<previous_bets[i].length; j++) {
			str += previous_bets[i][j] + " ";
		}

		str += "\n";
	}
	alert(str);
}




function get_hand_action(deck, braveness, round, base_bet, random_seed, bluff, required_bet, number_of_players_left) {

	var action_to_take	= "";
	var amount_to_bet	= 0;
	var wait_time		= 1200;
	var nr_players_factor 	= (5-number_of_players_left)/8;

	if (round == 0) {

		// ************************
		//
		// 	Pre flop
		//
		// ************************

		// We are pre-flop... Get a value for this hand
		var current_hand_potential = get_preflop_valuation(deck.cards[0], deck.cards[1], number_of_players_left);

		var weighted_potential = current_hand_potential+braveness*2+nr_players_factor;
       
		if (weighted_potential > 0.40) {
			action_to_take 	= "RAISE";
			//amount_to_bet	= Math.round(base_bet * (0.5+weighted_potential));
            amount_to_bet	=100;
			wait_time	= wait_time*(1-weighted_potential+random_seed);
		} else if (weighted_potential <= 0.25) {
			if ( (bluff) || (number_of_players_left == 2) ) {
				action_to_take 	= "RAISE";
				//amount_to_bet	= Math.round(base_bet * random_seed);
                 amount_to_bet	=100;
				wait_time	= wait_time*(random_seed);
			} else {
				action_to_take = "FOLD";
				wait_time	= wait_time*(random_seed);
			}
		} else if ( (weighted_potential > 0.25) && (weighted_potential <= 0.40) ) {
			action_to_take 	= "CHECK/CALL";
			amount_to_bet	= required_bet;
			wait_time	= wait_time*(random_seed+1);
		}


	} else if (round == 3) {

		// ************************
		//
		// 	Final round
		//
		// ************************

		// Final round, bet based on how good the current hand is
		hand_eval = get_postflop_valuation(deck, _global.env.GAME.community_cards, 1);

		// If we have a good hand, we do not have to be particularily brave...
		if (hand_eval[0] >= 9) {
			// Full house or better, disregard hand value and go for it!

			action_to_take 	= "RAISE";
			amount_to_bet	= Math.round(base_bet * (hand_eval[0]/5) * (random_seed+braveness));
			wait_time	= wait_time*(random_seed/1.5);

		} else if ( (hand_eval[0] >= 6) && (hand_eval[0] < 9) ) {
			// Straight, flush or full house, continue based on how good the hand is and how brave the player is

			if ((hand_eval[1]+braveness) < 0.6) {

				action_to_take 	= "RAISE";
				amount_to_bet	= Math.round(base_bet * (hand_eval[0]/2) * (random_seed+2*braveness));
				wait_time	= wait_time*(random_seed/1.5);
			} else {

				action_to_take 	= "RAISE";
				amount_to_bet	= Math.round(base_bet * (hand_eval[0]/2) * (random_seed+braveness));
				wait_time	= wait_time*(random_seed-braveness*10);
			}

		} else if ( (hand_eval[0] == 4) && (hand_eval[0] == 5) ) {
			// One Pair or Two Pairs, how good are they and how brave is this player?

			if (bluff) {
				action_to_take 	= "RAISE";
				amount_to_bet	= Math.round(base_bet * random_seed);
				wait_time	= wait_time*(random_seed);
			} else {

				if (((hand_eval[1]/2)+braveness+nr_players_factor) > 0.2) {

					action_to_take 	= "RAISE";
					amount_to_bet	= Math.round(base_bet * hand_eval[1] * (random_seed+braveness+hand_eval[1]/2));
					wait_time	= wait_time*(random_seed-braveness*10);
				} else {

					action_to_take 	= "CHECK/CALL";
					amount_to_bet	= required_bet;
					wait_time	= wait_time*(random_seed-braveness*20);
				}
			}

		} else {
			// We have nothing, but if it is a "good" nothing and this player is brave, call

			if (bluff) {
				action_to_take 	= "RAISE";
				amount_to_bet	= Math.round(base_bet * random_seed);
				wait_time	= wait_time*(random_seed);
			} else {

				var factor = ((hand_eval[1]/2) + (braveness/2) + nr_players_factor);

				if (factor>=0.7) {

					action_to_take 	= "CHECK/CALL";
					amount_to_bet	= required_bet;
					wait_time	= wait_time*(random_seed);
				} else {

					action_to_take 	= "FOLD";
					wait_time	= wait_time*(random_seed);
				}
			}

		}

	} else {

		// ************************
		//
		//     In between rounds
		//
		// ************************

		// Post-flop...
		// hand_eval is an array on the form:
		// [current hand value, how good is this hand, how much more can it improve]
		hand_eval = get_postflop_valuation(deck, _global.env.GAME.community_cards, 3-round);

		// If we have a good hand, we do not have to be particularily brave...
		if (hand_eval[0] >= 9) {
			// Full house or better, disregard hand value and go for it!

			action_to_take 	= "RAISE";
			amount_to_bet	= Math.round(base_bet * (hand_eval[0]/5) * (random_seed+braveness));
			wait_time	= wait_time*(random_seed/1.5);

		} else if ( (hand_eval[0] >= 6) && (hand_eval[0] < 9) ) {
			// Straight, flush or full house, continue based on how good the hand is and how brave the player is

			if ((hand_eval[1]+braveness) < 0.6) {

				action_to_take 	= "RAISE";
				amount_to_bet	= Math.round(base_bet * (hand_eval[0]/2) * (random_seed+2*braveness));
				wait_time	= wait_time*(random_seed/1.5);
			} else {

				action_to_take 	= "RAISE";
				amount_to_bet	= Math.round(base_bet * (hand_eval[0]/2) * (random_seed+braveness));
				wait_time	= wait_time*(random_seed-braveness*10);
			}

		} else if ( (hand_eval[0] == 4) && (hand_eval[0] == 5) ) {
			// One Pair or Two Pairs, continue based on how much we can improve

			if (bluff) {
				action_to_take 	= "RAISE";
				amount_to_bet	= Math.round(base_bet * random_seed);
				wait_time	= wait_time*(random_seed);
			} else {

				if (((hand_eval[1]/2) + hand_eval[2] + (braveness/2) + nr_players_factor) > 0.2) {

					action_to_take 	= "RAISE";
					amount_to_bet	= Math.round(base_bet * hand_eval[1] * (random_seed+braveness+hand_eval[2]));
					wait_time	= wait_time*(random_seed-braveness*10);
				} else {

					action_to_take 	= "CHECK/CALL";
					amount_to_bet	= required_bet;
					wait_time	= wait_time*(random_seed-braveness*20);
				}
			}

		} else {
			// We have nothing, but might there be something coming up?

			if (bluff) {
				action_to_take 	= "RAISE";
				amount_to_bet	= Math.round(base_bet * random_seed);
				wait_time	= wait_time*(random_seed);
			} else {

				var factor = ((hand_eval[1]/2) + hand_eval[2] + (braveness/2) + nr_players_factor);

				if (factor>=0.4) {

					action_to_take 	= "RAISE";
					amount_to_bet	= Math.round(base_bet * hand_eval[1] * (random_seed+braveness+hand_eval[2]));
					wait_time	= wait_time*(random_seed-braveness*10);
				} else if ( (factor<0.4) && (factor>=0.2) ) {

					action_to_take 	= "CHECK/CALL";
					amount_to_bet	= required_bet;
					wait_time	= wait_time*(random_seed);
				} else {

					action_to_take 	= "FOLD";
					wait_time	= wait_time*(random_seed);
				}
			}

		}

	}


	// Put the players intended action into context of how much
	// his opponents have betted.
	var bet_ratio = required_bet/base_bet;

	if (bet_ratio <= 1) {
		// Moderate betting, be brave...

		switch (action_to_take) {
			case "FOLD":
				if (bluff) {
					action_to_take 	= "CHECK/CALL";
					wait_time 	*= 2;
				}
				break;
			case "CHECK/CALL":
				if (bluff) {
					action_to_take 	= "RAISE";
					amount_to_bet	= Math.round(required_bet*(random_seed+1));
				}
				break;
			case "RAISE":
				if (bluff) {
					amount_to_bet 	*= 2;
				}
				break;
		}

	} else if ( (bet_ratio>1) && (bet_ratio<=5) ) {
		// Higher betting, be more cautious...


	} else if (bet_ratio>5) {
		// Someone is betting really high, beware...

		var brave_factor = ((braveness*5)+random_seed+nr_players_factor);

		switch (action_to_take) {
			case "CHECK/CALL":
				if ( (brave_factor<1.0) && (!bluff) ) {
					action_to_take 	= "FOLD";
					amount_to_bet	= 0;
					wait_time 	= wait_time/2;
				}
				break;
			case "RAISE":
				if ( (brave_factor<1.0) && (!bluff) ) {
					action_to_take 	= "CHECK/CALL";
					amount_to_bet	= 0;
				}
				break;
		}
	}



	var action_to_take_num = 0;
	if (action_to_take == "FOLD")
		action_to_take_num = 0;
	if (action_to_take == "CHECK/CALL")
		action_to_take_num = 1;
	if (action_to_take == "RAISE")
		action_to_take_num = 2;
//alert("action to take:" + action_to_take + " amount_to_bet:" + amount_to_bet + " wait_time" +wait_time + "action_to_take_num:" + action_to_take_num );

        if(_global.skip == true){
            wait_time = 100;
            
        }

	return new Array(action_to_take, amount_to_bet, wait_time, action_to_take_num);
     }




function avatar_bet() {

	if (!new_round) {
		new_round = true;
	}


	// How brave is this player?
	var braveness;

	// Induce a certain amount of randomness
	var random_seed;


	var number_of_players_left 	= _global.env.GAME.get_nr_players_left();
	var round			= _global.env.GAME.round;
	var player 			= _global.env.GAME.get_current_player();
	var required_bet		= _global.env.GAME.get_required_bet();
	var current_bet			= _global.env.GAME.get_current_bet();
	var max_bet 			= _global.env.GAME.get_max_bet();
	var player_index 		= _global.env.GAME.get_player_index(player.name)-1;
	var pot_size			= _global.env.GAME.get_pot_size();
	var max_wait_time		= 5000;

	var nr_players_factor 	= (5-number_of_players_left)/8;


	// Setup the array which hold the bets of each round
	// Note that this array does not contain the STB Player
	// (which is at position 0 in the env.GAME.players array)
	if ( (round == 0) && (new_round) ) {
		previous_bets = new Array(_global.env.GAME.players.length-1);
		for (var i=0; i<previous_bets.length; i++) {
			previous_bets[i] = new Array(_global.env.HAND_CARD_AMOUNTS.length);
			for (var j=0; j<previous_bets[i].length; j++) {
				previous_bets[i][j] = 0;
			}
		}

		if (_global.env.USE_BLINDS) {
			if (_global.env.GAME.big_blind > 0)
				previous_bets[_global.env.GAME.big_blind-1][0] = _global.env.GAME.big_blind_amount;
			if (_global.env.GAME.small_blind > 0)
				previous_bets[_global.env.GAME.small_blind-1][0] = _global.env.GAME.small_blind_amount;
		}

		new_round = false;
	}

	if (round > 0)
		new_round = true;



	var base_bet = Math.round(_global.env.INIT_CASH/100);
	if (_global.env.USE_BLINDS)
		base_bet = (round+1)*_global.env.GAME.big_blind_amount;


	// Adjust braveness according to the ratio between required amount to bet and pot size
	var brave_adj = 0;

	if (!_global.env.GAME.is_checkable()) { //Dont be extra brave if you can check
		var bet_fact  = required_bet/pot_size;
		if (bet_fact < 0.1) {
			brave_adj = 0.05;
		} else if (bet_fact < 0.3) {
			brave_adj = 0.02;
		} else if (bet_fact < 0.6) {
			brave_adj = 0.01;
		}
		brave_adj += (5-round)/50; //Be braver in the begining
	}

	braveness 		= player.braveness + brave_adj;
	random_seed 		= (Math.random()*2) + 0.5; //0,5-2,5
	bluff			= ( (braveness+Math.abs(braveness))*4 > Math.random());



	var action_to_take;
	var action_to_take_num 	= 0;
	var amount_to_bet	= 0;
	var wait_time;

	if (_global.env.REQUIRED_PLAYER_CARDS_IN_HAND > 0) {

		// One or more cards in the hand must be in the solution,
		// generate all possible subsets and pick the best combination

		var subsets = generate_possible_subsets(player.deck.cards, _global.env.REQUIRED_PLAYER_CARDS_IN_HAND);
		for (var s=0; s<subsets.length; s++) {
			var deck = new Deck();
			for (var c=0; c<subsets[s].length; c++) {
				deck.stack(subsets[s][c]);
			}

			var temp_action = get_hand_action(deck, braveness, round, base_bet, random_seed, bluff, required_bet, number_of_players_left);

			// See if this action is better than the currently choosen
			if (temp_action[3] == action_to_take_num) {

				if (temp_action[2] > amount_to_bet) {
					action_to_take		= temp_action[0];
					amount_to_bet		= temp_action[1];
					wait_time		= temp_action[2];
					action_to_take_num 	= temp_action[3];
				}

			}  else if (temp_action[3] > action_to_take_num) {
				action_to_take		= temp_action[0];
				amount_to_bet		= temp_action[1];
				wait_time		= temp_action[2];
				action_to_take_num 	= temp_action[3];
			}
		}

	} else {

		var action 	= get_hand_action(player.deck, braveness, round, base_bet, random_seed, bluff, required_bet, number_of_players_left);
		action_to_take	= action[0];
		amount_to_bet	= action[1];
		wait_time	= action[2];
	}






	if (action_to_take == "RAISE") {


		// If this is a rebet, remove the previous betted amount, to prevent endless raising
		amount_to_bet -= previous_bets[player_index][round];


		// See if the amount this player wants to bet is greater than
		// what already has been added to the table
		if (amount_to_bet<required_bet) {

			// Fold if the required bet is vastly higher than the
			// bet this player whishes to place. But not everytime as
			// this would lead to that the MOXI player can outbet all
			// opponents by betting large every time

			var factor = (braveness - (Math.random()/5) + nr_players_factor/10);
                        //var factor = 0.2;
			if ( ( (amount_to_bet / required_bet) < 0.3) && (factor<0.0) ) {
				action_to_take 	= "FOLD";
				amount_to_bet	= 0;
			} else {
				action_to_take 	= "CHECK/CALL";
				amount_to_bet	= current_bet;

			}

		} else {

			if ( (player.cash-amount_to_bet<=base_bet) && (player.cash-amount_to_bet>0) ) {
				amount_to_bet=player.cash; //Go All-in if there are less than a certain amount of cash left after doing this raise
			}

		}

		amount_to_bet 	= Math.min(player.cash, amount_to_bet);
	}

	previous_bets[player_index][round] += amount_to_bet;


        //alert("action_to_take: " +action_to_take+" amount_to_bet: "+amount_to_bet);


	wait_time = Math.min(wait_time, max_wait_time);

	//Testing
	//_global.bet_interval_id = setInterval(env.GAME, "bet_response", 500, "FOLD", 0);
	//return;



	switch (action_to_take) {

		case "FOLD":
			if (_global.env.GAME.is_checkable())
				//_global.bet_interval_id = setInterval(_global.env.GAME.bet_response.bind(_global.env.GAME), Math.round(wait_time), "CHECK", 0, false);
                                    //_global.bet_interval_id = setInterval("_global.env.GAME.bet_response('CHECK', 0, false)", Math.round(wait_time) );
                                _global.bet_interval_id = setTimeout("_global.env.GAME.bet_response('CHECK', 0, false)", Math.round(wait_time) );
			else
				//_global.bet_interval_id = setInterval(_global.env.GAME.bet_response.bind(_global.env.GAME), Math.round(wait_time), "FOLD", 0, false);
                                    //_global.bet_interval_id = setInterval("_global.env.GAME.bet_response('FOLD', 0, false)", Math.round(wait_time) );
                                _global.bet_interval_id = setTimeout("_global.env.GAME.bet_response('FOLD', 0, false)", Math.round(wait_time) );

			break;

		case "CHECK/CALL":
			if (_global.env.GAME.is_checkable()){
			//	_global.bet_interval_id = setInterval(_global.env.GAME.bet_response.bind(_global.env.GAME), Math.round(wait_time), "CHECK", 0, false);
                            //_global.bet_interval_id = setInterval("_global.env.GAME.bet_response('CHECK', 0, false)", Math.round(wait_time) );
                            _global.bet_interval_id = setTimeout("_global.env.GAME.bet_response('CHECK', 0, false)", Math.round(wait_time) );

                        }else if (_global.env.GAME.is_callable()){
			//	_global.bet_interval_id = setInterval(_global.env.GAME.bet_response.bind(_global.env.GAME), Math.round(wait_time), "CALL", 0, false);
			//_global.bet_interval_id = setInterval("_global.env.GAME.bet_response('CALL', 0, false)", Math.round(wait_time) );
                        _global.bet_interval_id = setTimeout("_global.env.GAME.bet_response('CALL', 0, false)", Math.round(wait_time) );
                        }else{
			//	_global.bet_interval_id = setInterval(_global.env.GAME.bet_response.bind(_global.env.GAME), Math.round(wait_time), "FOLD", 0, false);
			//_global.bet_interval_id = setInterval("_global.env.GAME.bet_response('FOLD', 0, false)", Math.round(wait_time) );
                        _global.bet_interval_id = setTimeout("_global.env.GAME.bet_response('FOLD', 0, false)", Math.round(wait_time) );
                        }
                        break;

		case "RAISE":
			//_global.bet_interval_id = setInterval(_global.env.GAME.bet_response.bind(_global.env.GAME), Math.round(wait_time), "BET", amount_to_bet, false);
			//_global.bet_interval_id = setInterval("_global.env.GAME.bet_response('BET', "+amount_to_bet+", false)", Math.round(wait_time) );
                        _global.bet_interval_id = setTimeout("_global.env.GAME.bet_response('BET', "+amount_to_bet+", false)", Math.round(wait_time) );

                        break;

	}


}

