
var preflop_lookup = new Array(9);
for (var i=0; i<preflop_lookup.length; i++) {
	preflop_lookup[i] = new Array(169);
}



// Assume four opponents
preflop_lookup[4][0] = 55.9;
preflop_lookup[4][1] = 49.8;
preflop_lookup[4][2] = 44.7;
preflop_lookup[4][3] = 35.4;
preflop_lookup[4][4] = 33.7;
preflop_lookup[4][5] = 40.3;
preflop_lookup[4][6] = 32.5;
preflop_lookup[4][7] = 32.5;
preflop_lookup[4][8] = 31.1;
preflop_lookup[4][9] = 31.0;
preflop_lookup[4][10] = 32.4;
preflop_lookup[4][11] = 36.4;
preflop_lookup[4][12] = 30.1;
preflop_lookup[4][13] = 29.9;
preflop_lookup[4][14] = 29.1;
preflop_lookup[4][15] = 28.5;
preflop_lookup[4][16] = 32.6;
preflop_lookup[4][17] = 30.4;
preflop_lookup[4][18] = 28.4;
preflop_lookup[4][19] = 29.3;
preflop_lookup[4][20] = 26.0;
preflop_lookup[4][21] = 27.4;
preflop_lookup[4][22] = 27.2;
preflop_lookup[4][23] = 26.1;
preflop_lookup[4][24] = 26.0;
preflop_lookup[4][25] = 26.4;
preflop_lookup[4][26] = 29.4;
preflop_lookup[4][27] = 28.9;
preflop_lookup[4][28] = 26.5;
preflop_lookup[4][29] = 25.3;
preflop_lookup[4][30] = 25.6;
preflop_lookup[4][31] = 24.6;
preflop_lookup[4][32] = 27.6;
preflop_lookup[4][33] = 26.9;
preflop_lookup[4][34] = 26.8;
preflop_lookup[4][35] = 24.0;
preflop_lookup[4][36] = 25.1;
preflop_lookup[4][37] = 27.6;
preflop_lookup[4][38] = 23.9;
preflop_lookup[4][39] = 23.6;
preflop_lookup[4][40] = 24.5;
preflop_lookup[4][41] = 24.4;
preflop_lookup[4][42] = 24.0;
preflop_lookup[4][43] = 26.5;
preflop_lookup[4][44] = 25.3;
preflop_lookup[4][45] = 24.5;
preflop_lookup[4][46] = 25.7;
preflop_lookup[4][47] = 23.7;
preflop_lookup[4][48] = 22.0;
preflop_lookup[4][49] = 23.0;
preflop_lookup[4][50] = 22.1;
preflop_lookup[4][51] = 22.2;
preflop_lookup[4][52] = 22.3;
preflop_lookup[4][53] = 20.8;
preflop_lookup[4][54] = 22.4;
preflop_lookup[4][55] = 21.7;
preflop_lookup[4][56] = 22.7;
preflop_lookup[4][57] = 20.6;
preflop_lookup[4][58] = 22.2;
preflop_lookup[4][59] = 19.0;
preflop_lookup[4][60] = 17.8;
preflop_lookup[4][61] = 21.2;
preflop_lookup[4][62] = 20.6;
preflop_lookup[4][63] = 19.7;
preflop_lookup[4][64] = 21.9;
preflop_lookup[4][65] = 18.9;
preflop_lookup[4][66] = 21.4;
preflop_lookup[4][67] = 20.4;
preflop_lookup[4][68] = 19.4;
preflop_lookup[4][69] = 20.7;
preflop_lookup[4][70] = 22.6;
preflop_lookup[4][71] = 24.7;
preflop_lookup[4][72] = 20.5;
preflop_lookup[4][73] = 20.1;
preflop_lookup[4][74] = 20.6;
preflop_lookup[4][75] = 18.4;
preflop_lookup[4][76] = 19.5;
preflop_lookup[4][77] = 19.1;
preflop_lookup[4][78] = 23.6;
preflop_lookup[4][79] = 22.5;
preflop_lookup[4][80] = 20.0;
preflop_lookup[4][81] = 17.5;
preflop_lookup[4][82] = 22.9;
preflop_lookup[4][83] = 23.7;
preflop_lookup[4][84] = 19.4;
preflop_lookup[4][85] = 18.8;
preflop_lookup[4][86] = 17.9;
preflop_lookup[4][87] = 18.8;
preflop_lookup[4][88] = 16.9;
preflop_lookup[4][89] = 18.3;
preflop_lookup[4][90] = 18.9;
preflop_lookup[4][91] = 22.6;
preflop_lookup[4][92] = 22.0;
preflop_lookup[4][93] = 18.4;
preflop_lookup[4][94] = 16.8;
preflop_lookup[4][95] = 20.4;
preflop_lookup[4][96] = 20.1;
preflop_lookup[4][97] = 21.1;
preflop_lookup[4][98] = 17.8;
preflop_lookup[4][99] = 17.4;
preflop_lookup[4][100] = 16.1;
preflop_lookup[4][101] = 17.4;
preflop_lookup[4][102] = 21.5;
preflop_lookup[4][103] = 15.7;
preflop_lookup[4][104] = 20.4;
preflop_lookup[4][105] = 20.4;
preflop_lookup[4][106] = 21.4;
preflop_lookup[4][107] = 17.3;
preflop_lookup[4][108] = 18.5;
preflop_lookup[4][109] = 16.4;
preflop_lookup[4][110] = 20.6;
preflop_lookup[4][111] = 16.8;
preflop_lookup[4][112] = 14.9;
preflop_lookup[4][113] = 19.6;
preflop_lookup[4][114] = 16.4;
preflop_lookup[4][115] = 15.4;
preflop_lookup[4][116] = 20.5;
preflop_lookup[4][117] = 16.0;
preflop_lookup[4][118] = 18.4;
preflop_lookup[4][119] = 15.7;
preflop_lookup[4][120] = 17.1;
preflop_lookup[4][121] = 19.7;
preflop_lookup[4][122] = 18.4;
preflop_lookup[4][123] = 15.0;
preflop_lookup[4][124] = 15.9;
preflop_lookup[4][125] = 19.0;
preflop_lookup[4][126] = 16.9;
preflop_lookup[4][127] = 15.0;
preflop_lookup[4][128] = 18.3;
preflop_lookup[4][129] = 18.1;
preflop_lookup[4][130] = 18.6;
preflop_lookup[4][131] = 15.5;
preflop_lookup[4][132] = 17.6;
preflop_lookup[4][133] = 16.9;
preflop_lookup[4][134] = 16.9;
preflop_lookup[4][135] = 17.6;
preflop_lookup[4][136] = 14.4;
preflop_lookup[4][137] = 17.3;
preflop_lookup[4][138] = 16.5;
preflop_lookup[4][139] = 15.2;
preflop_lookup[4][140] = 13.6;
preflop_lookup[4][141] = 16.4;
preflop_lookup[4][142] = 16.5;
preflop_lookup[4][143] = 15.9;
preflop_lookup[4][144] = 15.3;
preflop_lookup[4][145] = 13.9;
preflop_lookup[4][146] = 12.8;
preflop_lookup[4][147] = 15.9;
preflop_lookup[4][148] = 14.8;
preflop_lookup[4][149] = 15.3;
preflop_lookup[4][150] = 12.8;
preflop_lookup[4][151] = 14.8;
preflop_lookup[4][152] = 14.6;
preflop_lookup[4][153] = 14.1;
preflop_lookup[4][154] = 14.3;
preflop_lookup[4][155] = 12.0;
preflop_lookup[4][156] = 13.4;
preflop_lookup[4][157] = 13.7;
preflop_lookup[4][158] = 11.5;
preflop_lookup[4][159] = 13.2;
preflop_lookup[4][160] = 12.3;
preflop_lookup[4][161] = 13.2;
preflop_lookup[4][162] = 10.8;
preflop_lookup[4][163] = 12.7;
preflop_lookup[4][164] = 11.2;
preflop_lookup[4][165] = 12.1;
preflop_lookup[4][166] = 11.9;
preflop_lookup[4][167] = 11.4;
preflop_lookup[4][168] = 10.7;

function get_preflop_valuation(card1, card2, player_count) {

	player_count = 4;

	var factor = 50;

	var high_card_value	= Math.max(card1.value, card2.value);
	var low_card_value 	= Math.min(card1.value, card2.value);

	switch (high_card_value) {
		case 2:
			switch (low_card_value) {
				case 2:
					factor = preflop_lookup[player_count][60];
					break;
			}
			break;

		case 3:
			switch (low_card_value) {
				case 3:
					factor = preflop_lookup[player_count][59];
					break;
				case 2:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][112];
					break;
			}
			break;

		case 4:
			switch (low_card_value) {
				case 4:
					factor = preflop_lookup[player_count][57];
					break;
				case 3:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][88];
					else
						factor = preflop_lookup[player_count][146];
					break;
				case 2:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][103];
					else
						factor = preflop_lookup[player_count][158];
					break;
			}
			break;

		case 5:
			switch (low_card_value) {
				case 5:
					factor = preflop_lookup[player_count][54];
					break;
				case 4:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][65];
					else
						factor = preflop_lookup[player_count][127];
					break;
				case 3:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][81];
					else
						factor = preflop_lookup[player_count][140];
					break;
				case 2:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][100];
					else
						factor = preflop_lookup[player_count][155];
					break;
			}
			break;

		case 6:
			switch (low_card_value) {
				case 6:
					factor = preflop_lookup[player_count][45];
					break;
				case 5:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][63];
					else
						factor = preflop_lookup[player_count][124];
					break;
				case 4:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][75];
					else
						factor = preflop_lookup[player_count][136];
					break;
				case 3:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][94];
					else
						factor = preflop_lookup[player_count][150];
					break;
				case 2:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][115];
					else
						factor = preflop_lookup[player_count][164];
					break;
			}
			break;

		case 7:
			switch (low_card_value) {
				case 7:
					factor = preflop_lookup[player_count][34];
					break;
				case 6:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][53];
					else
						factor = preflop_lookup[player_count][120];
					break;
				case 5:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][68];
					else
						factor = preflop_lookup[player_count][131];
					break;
				case 4:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][86];
					else
						factor = preflop_lookup[player_count][145];
					break;
				case 3:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][109];
					else
						factor = preflop_lookup[player_count][160];
					break;
				case 2:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][123];
					else
						factor = preflop_lookup[player_count][168];
					break;
			}
			break;

		case 8:
			switch (low_card_value) {
				case 8:
					factor = preflop_lookup[player_count][26];
					break;
				case 7:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][48];
					else
						factor = preflop_lookup[player_count][108];
					break;
				case 6:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][62];
					else
						factor = preflop_lookup[player_count][126];
					break;
				case 5:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][77];
					else
						factor = preflop_lookup[player_count][139];
					break;
				case 4:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][99];
					else
						factor = preflop_lookup[player_count][156];
					break;
				case 3:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][117];
					else
						factor = preflop_lookup[player_count][166];
					break;
				case 2:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][119];
					else
						factor = preflop_lookup[player_count][167];
					break;
			}
			break;

		case 9:
			switch (low_card_value) {
				case 9:
					factor = preflop_lookup[player_count][16];
					break;
				case 8:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][39];
					else
						factor = preflop_lookup[player_count][96];
					break;
				case 7:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][50];
					else
						factor = preflop_lookup[player_count][118];
					break;
				case 6:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][67];
					else
						factor = preflop_lookup[player_count][133];
					break;
				case 5:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][87];
					else
						factor = preflop_lookup[player_count][148];
					break;
				case 4:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][107];
					else
						factor = preflop_lookup[player_count][161];
					break;
				case 3:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][111];
					else
						factor = preflop_lookup[player_count][163];
					break;
				case 2:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][114];
					else
						factor = preflop_lookup[player_count][165];
					break;
			}
			break;

		case 10:
			switch (low_card_value) {
				case 10:
					factor = preflop_lookup[player_count][11];
					break;
				case 9:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][20];
					else
						factor = preflop_lookup[player_count][70];
					break;
				case 8:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][35];
					else
						factor = preflop_lookup[player_count][95];
					break;
				case 7:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][51];
					else
						factor = preflop_lookup[player_count][122];
					break;
				case 6:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][72];
					else
						factor = preflop_lookup[player_count][138];
					break;
				case 5:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][90];
					else
						factor = preflop_lookup[player_count][151];
					break;
				case 4:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][93];
					else
						factor = preflop_lookup[player_count][154];
					break;
				case 3:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][98];
					else
						factor = preflop_lookup[player_count][157];
					break;
				case 2:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][101];
					else
						factor = preflop_lookup[player_count][159];
					break;
			}
			break;

		case 11:
			switch (low_card_value) {
				case 11:
					factor = preflop_lookup[player_count][5];
					break;
				case 10:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][15];
					else
						factor = preflop_lookup[player_count][44];
					break;
				case 9:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][23];
					else
						factor = preflop_lookup[player_count][79];
					break;
				case 8:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][42];
					else
						factor = preflop_lookup[player_count][105];
					break;
				case 7:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][58];
					else
						factor = preflop_lookup[player_count][128];
					break;
				case 6:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][74];
					else
						factor = preflop_lookup[player_count][142];
					break;
				case 5:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][80];
					else
						factor = preflop_lookup[player_count][147];
					break;
				case 4:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][84];
					else
						factor = preflop_lookup[player_count][149];
					break;
				case 3:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][85];
					else
						factor = preflop_lookup[player_count][152];
					break;
				case 2:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][89];
					else
						factor = preflop_lookup[player_count][153];
					break;
			}
			break;

		case 12:
			switch (low_card_value) {
				case 12:
					factor = preflop_lookup[player_count][2];
					break;
				case 11:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][12];
					else
						factor = preflop_lookup[player_count][33];
					break;
				case 10:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][14];
					else
						factor = preflop_lookup[player_count][46];
					break;
				case 9:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][25];
					else
						factor = preflop_lookup[player_count][82];
					break;
				case 8:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][41];
					else
						factor = preflop_lookup[player_count][110];
					break;
				case 7:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][56];
					else
						factor = preflop_lookup[player_count][130];
					break;
				case 6:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][64];
					else
						factor = preflop_lookup[player_count][135];
					break;
				case 5:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][66];
					else
						factor = preflop_lookup[player_count][137];
					break;
				case 4:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][69];
					else
						factor = preflop_lookup[player_count][141];
					break;
				case 3:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][73];
					else
						factor = preflop_lookup[player_count][143];
					break;
				case 2:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][76];
					else
						factor = preflop_lookup[player_count][144];
					break;
			}
			break;

		case 13:
			switch (low_card_value) {
				case 13:
					factor = preflop_lookup[player_count][1];
					break;
				case 12:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][6];
					else
						factor = preflop_lookup[player_count][19];
					break;
				case 11:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][8];
					else
						factor = preflop_lookup[player_count][32];
					break;
				case 10:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][13];
					else
						factor = preflop_lookup[player_count][43];
					break;
				case 9:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][22];
					else
						factor = preflop_lookup[player_count][78];
					break;
				case 8:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][36];
					else
						factor = preflop_lookup[player_count][106];
					break;
				case 7:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][40];
					else
						factor = preflop_lookup[player_count][116];
					break;
				case 6:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][47];
					else
						factor = preflop_lookup[player_count][121];
					break;
				case 5:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][49];
					else
						factor = preflop_lookup[player_count][125];
					break;
				case 4:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][52];
					else
						factor = preflop_lookup[player_count][129];
					break;
				case 3:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][55];
					else
						factor = preflop_lookup[player_count][132];
					break;
				case 2:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][61];
					else
						factor = preflop_lookup[player_count][134];
					break;
			}
			break;

		case 14:
			switch (low_card_value) {
				case 14:
					factor = preflop_lookup[player_count][0];
					break;
				case 13:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][3];
					else
						factor = preflop_lookup[player_count][10];
					break;
				case 12:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][4];
					else
						factor = preflop_lookup[player_count][17];
					break;
				case 11:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][7];
					else
						factor = preflop_lookup[player_count][27];
					break;
				case 10:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][9];
					else
						factor = preflop_lookup[player_count][37];
					break;
				case 9:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][18];
					else
						factor = preflop_lookup[player_count][71];
					break;
				case 8:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][21];
					else
						factor = preflop_lookup[player_count][83];
					break;
				case 7:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][28];
					else
						factor = preflop_lookup[player_count][91];
					break;
				case 6:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][30];
					else
						factor = preflop_lookup[player_count][102];
					break;
				case 5:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][24];
					else
						factor = preflop_lookup[player_count][92];
					break;
				case 4:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][29];
					else
						factor = preflop_lookup[player_count][97];
					break;
				case 3:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][31];
					else
						factor = preflop_lookup[player_count][104];
					break;
				case 2:
					if (card1.suite == card2.suite)
						factor = preflop_lookup[player_count][38];
					else
						factor = preflop_lookup[player_count][113];
					break;
			}
			break;
	}

	return (factor / preflop_lookup[player_count][0]);
}



function get_out_chance(outs, cards_left) {
	if (cards_left == 2)
		return (outs/47)+(outs/46);
	else
		return (outs/47);
}


function get_missing_for_flush(deck) {
	return 5-Math.max(deck.suite_count("h"), deck.suite_count("d"), deck.suite_count("c"), deck.suite_count("s"));
}

function get_missing_for_straight(deck) {

	var max_in_row = 0;

	var _sorted = deck.get_sorted_deck();

	for (var c=0; c<_sorted.cards.length; c++) {

		max_in_row	= 0;
		strght = new Array();
		strght.push(_sorted.cards[c].value);

		for (var d=c+1; d<_sorted.cards.length; d++) {
			if (_sorted.cards[d].value == (_sorted.cards[d-1].value+1)) {
				strght.push(_sorted.cards[d].value);
			} else {
				max_in_row = Math.max(max_in_row, strght.length);
				c = d;
				max_in_row = 0;
				break;
			}
		}

	}

	return 5-max_in_row;
}



// returns an array of two values [current hand value, how good is this hand, how much more can it improve]
function get_postflop_valuation(player_deck, community_deck, cards_left) {

	var temp_deck = new Deck();
	temp_deck.add_deck(player_deck)
	temp_deck.add_deck(community_deck);

	var current_hand = evaluate_deck(temp_deck);

	var eval_array;

	switch (current_hand[1]) {

		case 100:
			// Royal Straight Flush
			eval_array = new Array(current_hand[1], 1.0, 0.0);
			break;

		case 10:
			// Straight Flush

			// Find the top value of this straight
			var strght;
			var _sorted = temp_deck.get_sorted_deck();
			for (var c=0; c<_sorted.cards.length; c++) {

				strght = new Array();
				strght.push(_sorted.cards[c].value);

				for (var d=c+1; d<_sorted.cards.length; d++) {
					if (_sorted.cards[d].value == (_sorted.cards[d-1].value+1)) {

						if (_sorted.cards[d].suite != (_sorted.cards[d-1].suite))
							break;
						else
							strght.push(_sorted.cards[d].value);
					} else {
						break;
					}
				}

				if (strght.length >= 5) {
					break;
				}
			}

			var goodness = strght[strght.length-1]/14;
			eval_array = new Array(current_hand[1], goodness, 0.0);
			break;

		case 9:
			// Four of a kind

			// Find the four
			var four_value = 0;
			for (var c=0; c<temp_deck.cards.length; c++) {
				var _card = temp_deck.cards[c];
				if (temp_deck.value_count(_card.value) == 4)
					four_value = _card.value;
			}

			var goodness = four_value/14;
			eval_array = new Array(current_hand[1], goodness, 0.0);
			break;

		case 8:
			// Full House

			// How good is this full house?
			var two_value	= 0;
			var three_value	= 0;

			// Find all 3's first
			for (var c=0; c<temp_deck.cards.length; c++) {
				var _card = temp_deck.cards[c];
				if ( (temp_deck.value_count(_card.value) == 3) && (three_value<_card.value) ) { // Pick the highest possible 3
					three_value = _card.value;  // Save the 3's value
				}
			}

			// Find all 2's
			for (var c=0; c<temp_deck.cards.length; c++) {
				var _card = temp_deck.cards[c];
				if ( (temp_deck.value_count(_card.value) >= 2) && (three_value!=_card.value) ) { // Make sure this value is different from the 3
					two_value = _card.value;  // Save the 2's value
					break;
				}
			}

			//var goodness = (two_value+three_value)/(14+13)); //14=aces, 13=kings
			var high_good 	= Math.max(two_value, three_value)/14;
			var low_good  	= Math.min(two_value, three_value)/13;
			var goodness	= high_good*0.8 + low_good*0.2;

			// -> Four of a kind = 3 outs = 6.38%
			eval_array = new Array(current_hand[1], goodness, get_out_chance(3, cards_left));
			break;

		case 7:
			// Flush

			// How good is this flush?
			var _sorted_deck = temp_deck.get_sorted_deck();
			var goodness = _sorted_deck[_sorted_deck.length-1]/14  +  _sorted_deck[_sorted_deck.length-2]/13;
			eval_array = new Array(current_hand[1], goodness, 0.0);
			break;

		case 6:
			// Straight

			// Find the top value of this straight
			var strght;
			var _sorted = temp_deck.get_sorted_deck();
			for (var c=0; c<_sorted.cards.length; c++) {

				strght = new Array();
				strght.push(_sorted.cards[c].value);

				for (var d=c+1; d<_sorted.cards.length; d++) {
					if (_sorted.cards[d].value == (_sorted.cards[d-1].value+1)) {
						strght.push(_sorted.cards[d].value);
					} else {
						break;
					}
				}

				if (strght.length >= 5) {
					break;
				}
			}

			var goodness = strght[strght.length-1]/14;
			eval_array = new Array(current_hand[1], goodness, 0.0);
			break;

		case 5:
			// Three of a kind

			// Find the best combination of 3's
			var three_value	= 0;
			for (var c=0; c<temp_deck.cards.length; c++) {
				var _card = temp_deck.cards[c];
				if ( (temp_deck.value_count(_card.value) == 3) && (three_value<_card.value) ) { // Pick the highest possible 3
					three_value = _card.value;  // Save the 3's value
				}
			}

			// We can get full house or four of a kind
			// Full house -> 6, 9, 12 outs, depending on how many cards we have
			// Four of a kind -> 1 out

			var outs = 1+(temp_deck.cards.length-3)*3;

			var goodness = three_value/14;
			eval_array = new Array(current_hand[1], goodness, get_out_chance(outs, cards_left));
			break;

		case 4:
			// Two Pairs

			// Find all pairs
			var pairs = new Array();
			for (var c=0; c<temp_deck.cards.length; c++) {
				var _card = temp_deck.cards[c];
				if ( (temp_deck.value_count(_card.value) == 2) && (_global.arr_index_of(pairs, _card.value) == -1) ) {
					// This pair has not been saved yet.
					// - see where it should go... highest last
					var added = false;
					for (var i=0; i<pairs.length; i++) {
						if (pairs[i] > _card.value) {
							pairs.splice(i, 0, _card.value);
							added = true;
							break;
						}
					}

					if (!added)
						pairs.push(_card.value);
				}
			}


			var goodness = (pairs[pairs.length-1]/14)*0.7 + (pairs[pairs.length-2]/13)*0.3;

			var outs = 0;

			// Four of a kind
			if (pairs.length == 2) {
				if (temp_deck.cards.length == 5)
					outs += 2;
			}

			// Full House
			outs += 4;

			// Three of a kind
			outs += 4;



			eval_array = new Array(current_hand[1], goodness, get_out_chance(outs, cards_left));
			break;

		case 3:
			// One Pair
			var pair_value = 0;
			for (var c=0; c<temp_deck.cards.length; c++) {
				var _card = temp_deck.cards[c];
				if (temp_deck.value_count(_card.value) == 2) {
					pair_value = _card.value;
					break;
				}
			}

			var goodness = pair_value/14;

			var flush_outs 		= 0;
			var straight_outs 	= 0;
			var miss_flush 		= get_missing_for_flush(temp_deck);
			var miss_straight 	= get_missing_for_straight(temp_deck);

			if (miss_flush <= cards_left)
				flush_outs = 13-(5-miss_flush);

			if (miss_straight <= cards_left)
				straight_outs = 4*miss_straight;

			var flush_chance 	= get_out_chance(flush_outs, cards_left)/miss_flush;
			var straight_chance 	= get_out_chance(straight_outs, cards_left)/miss_straight;

			eval_array = new Array(current_hand[1], goodness, Math.max(flush_chance, straight_chance));
			break;

		case -1:
			// Nothing
			var _sorted = temp_deck.get_sorted_deck();
			var goodness = (_sorted.cards[_sorted.cards.length-1]).value/14;

			var flush_outs 		= 0;
			var straight_outs 	= 0;
			var miss_flush 		= get_missing_for_flush(temp_deck);
			var miss_straight 	= get_missing_for_straight(temp_deck);

			if (miss_flush <= cards_left)
				flush_outs = 13-(5-miss_flush);

			if (miss_straight <= cards_left)
				straight_outs = 4*miss_straight;

			var flush_chance 	= get_out_chance(flush_outs, cards_left)/miss_flush;
			var straight_chance 	= get_out_chance(straight_outs, cards_left)/miss_straight;

			eval_array = new Array(current_hand[1], goodness, Math.max(flush_chance, straight_chance));
			break;

	}


	return eval_array;
}

/*
var test_deck1=new Deck();
test_deck1.stack(new Card("s", 2));
test_deck1.stack(new Card("s", 5));
test_deck1.stack(new Card("s", 9));

var test_deck2=new Deck();
test_deck2.stack(new Card("c", 10));
test_deck2.stack(new Card("d", 7));

alert(get_postflop_valuation(test_deck1, test_deck2, 2));
*/