function Deck() {

	this.cards = new Array();

	this.reshuffle = function() {
		var temp_deck = new Array();
		for (var s=0; s<_global.env.CARD_SUITES.length; s++) {
			for (var v=0; v<_global.env.CARD_VALUES.length; v++) {
				var _card = new Card(_global.env.CARD_SUITES[s], _global.env.CARD_VALUES[v]);
				temp_deck.push(_card);
			}
		}

		this.cards = new Array();
		while (temp_deck.length>0) {
			var temp_index = Math.floor(Math.random()*temp_deck.length);
			var _card = new Card(temp_deck[temp_index].suite, temp_deck[temp_index].value);
			temp_deck.splice(temp_index, 1);
			this.cards.push(_card);
		}

                //test
                //this.cards = [ new Card("d",13), new Card("h",13),  new Card("d",8), new Card("s",7), new Card("h",10), new Card("s",13), new Card("d",6), new Card("d",10), new Card("s",8)]
                //=====
        }

	this.draw = function() {
		if (this.cards.length > 0) {
			var _card = new Card(this.cards[0].suite, this.cards[0].value);
			this.cards.splice(0, 1);
			return _card;
		}
	}

	this.stack = function(card) {
		this.cards.push(card);
	}

	this.add_deck = function(deck) {
		for (var c=0; c<deck.cards.length; c++) {
			this.cards.push(deck.cards[c]);
		}
	}

	this.get_value_array = function() {
		var arr = new Array();
		for (var c=0; c<this.cards.length; c++) {
			arr.push(this.cards[c].value);
		}
		return arr;
	}



	this.toString = function() {
		var str = "";
		for (var i=0; i<this.cards.length; i++) {
			str += this.cards[i] + " \n";
		}
		return str;
	}



	// ****************************************
	//
	// Deck evaluation functions
	//
	// ****************************************
	this.contains = function(suite, value) {
		for (var c=0; c<this.cards.length; c++) {
			var _card = this.cards[c];
			if ( (_card.suite == suite) && (_card.value == value) )
				return true;
		}
		return false;
	}

	// Counts the number of cards of the same suite
	this.suite_count = function(suite) {
		var counter = 0;
		for (var c=0; c<this.cards.length; c++) {
			var _card = this.cards[c];
			if (_card.suite == suite)
				counter++;
		}
		return counter;
	}

	// Counts the number of cards of the same value
	this.value_count = function(value) {
		var counter = 0;
		for (var c=0; c<this.cards.length; c++) {
			var _card = this.cards[c];
			if (_card.value == value)
				counter++;
		}
		return counter;
	}

	// Generates a sorted version of this deck, where the least valued card
	// is located at position 0 and so on. Aces are inserted as both 1 and 14, if defined.
	this.get_sorted_deck = function() {
		var _deck = new Deck();
		for (var c=0; c<this.cards.length; c++) {

			// This is an ace
			if (this.cards[c].value == 14) {
				_deck.cards.push(this.cards[c]);

				if (_global.env.COUNT_ACE_AS_ONE)
					_deck.cards.splice(0, 0, new Card(this.cards[c].suite, 1));

			} else {

				var added = false;
				for (var d=0; d<_deck.cards.length; d++) {
					if (this.cards[c].value <= _deck.cards[d].value) {
						_deck.cards.splice(d, 0, this.cards[c]);
						added = true;
						break;
					}
				}

				if (!added) {
					_deck.cards.push(this.cards[c]);
				}

			}
		}

		return _deck;
	}



}