function Game() {

        this.stop = false;

        this.env = _global.env;

        _global.env.GUI.init();

        this.small_blind = 0;
        this.big_blind = 0;
        this.round = 0;

        this.hand = 0;
        this.community_cards = new Deck();
        this.deck = new Deck();
        this.players = new Array();

}

Game.prototype = 
{
    
	current_player: null,
	current_player_start: null,

        big_blind_amount: 0,
	small_blind_amount: 0,

	latest_raise: null,
    
	add_player: function(player) {
		this.players.push(player);
		_global.env.GUI.add_player(player);
		_global.env.GUI.set_cash(player);
	},

	start: function() {

		this.hand	= 0;
		this.round	= 0;

		this.big_blind_amount 	= _global.env.BIG_BLIND;
		this.small_blind_amount = _global.env.SMALL_BLIND;

		this.latest_raise = 0;

		// Init big blind
		if (_global.env.USE_BLINDS) {
			this.small_blind = Math.floor(Math.random()*this.players.length);

			this.current_player_start = this.small_blind+2;
			if (this.current_player_start >= this.players.length)
				this.current_player_start -= this.players.length;

		} else {
			this.current_player_start = Math.floor(Math.random()*this.players.length);
		}

		this.new_hand();
	},

	new_hand: function() {

                //test
//                this.small_blind = 0;
//                this.players[1].state = "BANKRUPT";
//                this.players[3].state = "BANKRUPT";
//                this.players[4].state = "BANKRUPT";
                //=====

		this.hand++;
		_global.env.GUI.set_hand(this.hand);
		_global.env.GUI.set_pot(0);

                _global.skip = false;
                $("gamemenu2").style.visibility = "hidden";

		this.round = 0;

		this.deck.reshuffle();


		// Rotate blinds
		if (_global.env.USE_BLINDS) {

			while (true) {
				this.small_blind++;
				this.small_blind = (this.small_blind==this.players.length ? 0 : this.small_blind);
				if (this.players[this.small_blind].state != "BANKRUPT")
					break; //We have found the next non-bankrupt player
			}
			_global.env.GUI.set_small_blind(this.players[this.small_blind]);

			this.big_blind = this.small_blind;
			while (true) {
				this.big_blind++;
				this.big_blind   = (this.big_blind==this.players.length ? 0 : this.big_blind);
				if (this.players[this.big_blind].state != "BANKRUPT")
					break; //We have found the next non-bankrupt player
			}
			_global.env.GUI.set_big_blind(this.players[this.big_blind]);

			// Player left of small blind is the dealer
			var dealer = this.small_blind;
			if (this.get_nr_players_left() > 2) {
				while (true) {
					dealer--;
					dealer = ( (dealer==-1) ? (this.players.length-1) : dealer);
					if (this.players[dealer].state != "BANKRUPT")
						break; //We have found the next non-bankrupt player
				}
			}
			_global.env.GUI.set_dealer(this.players[dealer]);

		}



		// Determine which player is to bet
		if (this.get_nr_players_left() > 2) {
			this.current_player_start = this.big_blind;

			while (true) {
				this.current_player_start++;
				this.current_player_start = ( this.current_player_start==this.players.length ? 0 : this.current_player_start)
				if (this.players[this.current_player_start].state != "BANKRUPT")
					break; //We have found the next non-bankrupt player
			}

		} else {
			// If there is only two players left, small blind is to start to bet
			this.current_player_start = this.small_blind;
		}



		// See if we should increase the blind amount
		if (_global.env.BLIND_RAMP_UP_HANDS > -1) {
			if ( ((this.hand-1)%_global.env.BLIND_RAMP_UP_HANDS == 0) && ((this.hand-1)>0) ) {
				this.big_blind_amount 	= _global.env.BLIND_RAMP_UP_MULTIPLIER * this.big_blind_amount;
				this.small_blind_amount = _global.env.BLIND_RAMP_UP_MULTIPLIER * this.small_blind_amount;
			}
		}


		// Set new hand for each player, and set WAITING state
		for (var p=0; p<this.players.length; p++) {
			if (this.players[p].state != "BANKRUPT") 
                        {

				this.players[p].deck 	= new Deck();
				_global.env.GUI.set_deck(this.players[p], this.players[p].deck);

				this.players[p].state 	= "WAITING";
				_global.env.GUI.set_state(this.players[p]);

				this.players[p].reset_bet();
				_global.env.GUI.set_bet(this.players[p]);
			}
		}



		if (_global.env.USE_BLINDS) {

			// Make sure that all players can participate
			// by making a cutoff based on the maximum possible bet
			var real_big_blind_amount   = Math.min(this.players[this.big_blind].cash, this.big_blind_amount);
			var real_small_blind_amount = Math.min(this.players[this.small_blind].cash, this.small_blind_amount);

			// Update GUI with blind amounts
			_global.env.GUI.set_big_blind_amount(this.big_blind_amount);
			_global.env.GUI.set_small_blind_amount(this.small_blind_amount);

			// Auto-bet blind amounts
			this.players[this.big_blind].bet[0]  = real_big_blind_amount;
			this.players[this.big_blind].cash   -= real_big_blind_amount;
			_global.env.GUI.set_bet(this.players[this.big_blind]);
			_global.env.GUI.set_cash(this.players[this.big_blind]);
			if (this.players[this.big_blind].cash == 0) {
				this.players[this.big_blind].state = "ALL-IN";
				_global.env.GUI.set_state(this.players[this.big_blind]);
			}

			this.players[this.small_blind].bet[0]  = real_small_blind_amount;
			this.players[this.small_blind].cash   -= real_small_blind_amount;
			_global.env.GUI.set_bet(this.players[this.small_blind]);
			_global.env.GUI.set_cash(this.players[this.small_blind]);
			if (this.players[this.small_blind].cash == 0) {
				this.players[this.small_blind].state = "ALL-IN";
				_global.env.GUI.set_state(this.players[this.small_blind]);
			}

			this.latest_raise = real_big_blind_amount - real_small_blind_amount;

			this.update_pot();
		}


		this.current_player = this.current_player_start;
		this.select_next_player();
		_global.env.GUI.set_current_player(this.players[this.current_player]);


		// Deal cards to players
		for (var t=0; t<_global.env.NR_PLAYER_CARDS; t++) {
			for (var p=0; p<this.players.length; p++) {
				if (this.players[p].state != "BANKRUPT") {
					var _card = this.deck.draw();
					this.players[p].deck.stack(_card);
					_global.env.GUI.add_to_deck(this.players[p], _card);
				}
			}
		}


		// Deal cards to community
		this.community_cards = new Deck();
		_global.env.GUI.set_community(this.community_cards);

		_global.env.GUI.hide_community(); // Hide first set of cards
		this.deal_round();



		this.bet_request();


	},

	select_next_player: function() {

		// Find the next player that is still gaming
		var counter = 0;
		while ( (this.players[this.current_player].state == "FOLD") || (this.players[this.current_player].state == "BANKRUPT") || (this.players[this.current_player].state == "ALL-IN") )  {
			this.current_player++;
			if (this.current_player == this.players.length)
				this.current_player = 0;

			counter++;

			if (counter == this.players.length) {
				_global.env.GUI.hide_arrow();

				if (this.get_nr_unfolded_players() > 1) {
					this.show_next_round_message();
					//_global.next_round_interval = setInterval(_global.env.GAME.next_round.bind(_global.env.GAME), 3600);
                                            if(_global.skip == true){
                                                //_global.next_round_interval = setInterval("_global.env.GAME.next_round()", 300);
                                                _global.next_round_interval = setTimeout("_global.env.GAME.next_round()", 300);
                                            }else{
                                                //_global.next_round_interval = setInterval("_global.env.GAME.next_round()", 3600);
                                                _global.next_round_interval = setTimeout("_global.env.GAME.next_round()", 3600);
                                            }
                                            
                                      

				} else {
					this.forfeit();
				}

				return false;
			}
		}

		// A player has been selected, see if this is the only player left
		if ( (this.get_nr_betting_players() == 1) && (this.get_nr_unfolded_players() == 1) ) {

			_global.env.GUI.hide_arrow();

			if (this.get_nr_unfolded_players() > 1) {
				this.show_next_round_message();
				//_global.next_round_interval = setInterval(_global.env.GAME.next_round.bind(_global.env.GAME), 3600);
                                if(_global.skip == true){
                                    //_global.next_round_interval = setInterval("_global.env.GAME.next_round()", 300);
                                    _global.next_round_interval = setTimeout("_global.env.GAME.next_round()", 300);
                                }else{
                                    //_global.next_round_interval = setInterval("_global.env.GAME.next_round()", 3600);
                                    _global.next_round_interval = setTimeout("_global.env.GAME.next_round()", 3600);
                                }

			} else {
				this.forfeit();
			}

			return false;

		}

               
		return true;
	},

	update_pot: function() {
		// Update the GUI with the current pot size
		var pot = 0;
		for (var i=0; i<this.players.length; i++) {
			pot += this.players[i].total_bet();
		}
		_global.env.GUI.set_pot(pot);
	},

	next_round: function() {

		//clearInterval(_global.next_round_interval);
                clearTimeout(_global.next_round_interval);
		this.round++;

		this.latest_raise = 0;


		this.update_pot();


		if (this.round == (_global.env.HAND_CARD_AMOUNTS.length)) {
			this.deal_round();
			this.evaluate_hand();
		} else {

			this.deal_round();

			// Reset each players state
			for (var p=0; p<this.players.length; p++) {
				if ( (this.players[p].state != "FOLD") && (this.players[p].state != "BANKRUPT") && (this.players[p].state != "ALL-IN") )  {
					this.players[p].state = "WAITING";
					_global.env.GUI.set_state(this.players[p]);
				}
			}

			// Reset each players bet
			for (var p=0; p<this.players.length; p++) {
				if ( (this.players[p].state != "BANKRUPT") && (this.players[p].state != "ALL-IN") )  {
					_global.env.GUI.set_bet(this.players[p]);
				}
			}

			// Auto-check if only one betting player left
			if (this.get_nr_betting_players() > 1) {

				if (this.get_nr_players_left() > 2) {
					this.current_player = this.small_blind;
					if (!this.select_next_player()) {
						return;
					}
				} else {
					this.current_player = this.big_blind;
				}

				this.bet_request();

			} else {

				// Are there more than one interested in the pot? If not, evaluate hand as is
				if (this.get_nr_unfolded_players() == 1) {

					//this.evaluate_hand();
					this.forfeit();

				} else {

					// Show the hands of the remaining players
					for (var i=0; i<this.players.length; i++) {
						if ( (this.players[i].state != "BANKRUPT") && (this.players[i].state != "FOLD") )
							_global.env.GUI.show_player_cards(this.players[i])
					}

					_global.env.GUI.hide_arrow();
					this.show_next_round_message();
					//_global.next_round_interval = setInterval(_global.env.GAME.next_round.bind(_global.env.GAME), 3600);
                                        if(_global.skip == true){
                                             //_global.next_round_interval = setInterval("_global.env.GAME.next_round()", 300);
                                             _global.next_round_interval = setTimeout("_global.env.GAME.next_round()", 300);
                                        }else{
                                             //_global.next_round_interval = setInterval("_global.env.GAME.next_round()", 3600);
                                             _global.next_round_interval = setTimeout("_global.env.GAME.next_round()", 3600);
                                        }



				}

			}

		}
	},

	deal_round: function() {

		// Show community cards if this is the first round (post-betting)
		if (this.round == _global.env.SHOW_COMMUNITY_AT) {
			_global.env.GUI.show_community();
			//return;
		}

		for (var t=0; t<_global.env.HAND_CARD_AMOUNTS[this.round]; t++) {
			var _card = this.deck.draw();
			this.community_cards.stack(_card);
			_global.env.GUI.add_to_community(_card);
		}

	},




	evaluate_hand: function() {

		var winning_player_array = new Array();

		// Calculate outcome of the hand
		for (var p=0; p<this.players.length; p++) {
			if ( (this.players[p].state != "FOLD") && (this.players[p].state != "BANKRUPT") ) {

				var result;

				// Get the hand from the player that will compete
				// with the hands of the other players in this game.
				if (_global.env.REQUIRED_PLAYER_CARDS_IN_HAND > 0) {

					// Evaluate each possible hand, as determined by _global.env variables
					var subset_results = new Array(); // Used to store the result for each subset
					var subsets = _global.generate_possible_subsets(this.players[p].deck.cards, _global.env.REQUIRED_PLAYER_CARDS_IN_HAND);
					for (var s=0; s<subsets.length; s++) {
						var deck = new Deck();
						for (var c=0; c<subsets[s].length; c++) {
							deck.stack(subsets[s][c]);
						}
						// Get the best hand that can be yielded from this subset.
						// deck is required, and community_deck is optional, as defined
						// by the get_best_hand function
						var temp_results = _global.get_best_hand(deck, this.community_cards);
						for (var t=0; t<temp_results.length; t++) {
							subset_results.push(temp_results[t]);
						}
					}


					var highest_results	= new Array();
					// Loop through each subset result to see which result is the greatest
					for (var r=0; r<subset_results.length; r++) {
						var subset_result = subset_results[r];
                                                alert("subset_result to check: " + subset_result);
						if (highest_results.length > 0) {

							if (subset_result[1] == highest_results[0][1]) {
                                                                alert("same result: " + subset_result[1]);
								highest_results.push(subset_result);
							} else if (subset_result[1] > highest_results[0][1]) {
                                                                alert("higher result: " + subset_result[1]);
								highest_results = new Array();
								highest_results.push(subset_result);
							}

						} else {
							highest_results.push(subset_result);
						}
					}


					if (highest_results.length == 1) {
						// One subset hand contains the highest unique result, propagate this
						result = highest_results[0];
					} else {
						// More than one subset yields the same hand, find out which is the greatest

						// Construct a new array on the form:
						// [highest_result index, result]
						var array_to_check = new Array();
						for (var r=0; r<highest_results.length; r++) {
							array_to_check.push(new Array(r, highest_results[r]));
						}

						var winner_subsets = _global.compare_winning_hands(array_to_check);
						//alert(winner_subsets.length + " winning hands found out of " + highest_results.length + " hands (" + array_to_check[0][1][0] + ")");
						//alert(highest_results);

						// The winner_subsets variable is an array of all the
						// winning hands, sharing the same hand. Just pick
						// the foremost hand as this indeed is the highest hand.
						result = highest_results[winner_subsets[0]];
					}

				} else {
					var deck_to_check = new Deck();
					deck_to_check.add_deck(this.players[p].deck);
					deck_to_check.add_deck(this.community_cards);
					result = _global.evaluate_deck(deck_to_check);
                                        alert("result: " + result);
				}


				if (winning_player_array.length > 0) {

					if (result[1] == winning_player_array[0][1][1]) {
                                                alert("same result: " + result);
						winning_player_array.push(new Array(p, result));
					} else if (result[1] > winning_player_array[0][1][1]) {
                                                alert("larger result: " + result);
						winning_player_array = new Array();
						winning_player_array.push(new Array(p, result));
					}

				} else {
					winning_player_array.push(new Array(p, result));
				}

			}
		}

		var winners = new Array();
		if (winning_player_array.length == 1) {
			// We have a single winner
			winners.push(winning_player_array[0][0]);
		} else {
			// We have a two or more players with the same
			// hand, try to find a winner amongst these.
			winners = _global.compare_winning_hands(winning_player_array);
		}




		var player_array = new Array();
		for (var i=0; i<winners.length; i++) {
			player_array.push(this.players[winners[i]]);
		}
		_global.env.GUI.set_winners(player_array, winning_player_array[0][1][0]);

		this.allocate_bets(winners);

	},


	allocate_bets: function(winners) {

		// Calculate the pot
		var pot = 0;
		for (var p=0; p<this.players.length; p++) {
			if (this.players[p].state != "BANKRUPT") {
				pot += this.players[p].total_bet();
			}
		}


		// For each player, summarize his/her bets
		for (var p=0; p<this.players.length; p++) {
			this.players[p].summarize_bet();
		}


		// Create a sorted version (in regard to bet_sum) of the winner array
		// having the least bet_sum value first
		var sorted_winners = new Array();
		for (var i=0; i<winners.length; i++) {
			var added = false;
			var next_player = this.players[winners[i]];

			for (var w=0; w<sorted_winners.length; w++) {
				if (next_player.bet_sum < sorted_winners[w].bet_sum) {
					sorted_winners.splice(w, 0, next_player);
					added = true;
					break;
				}
			}

			if (!added)
				sorted_winners.push(next_player);
		}


		// Allocate pot according to individual bets
		for (var i=0; i<sorted_winners.length; i++) {

			var curr_sum = sorted_winners[i].bet_sum;

			/*
			var player_index = 0;
			for (var p=0; p<this.players.length; p++) {
				if (this.players[p].name == sorted_winners[i].name) {
					player_index = p;
					break;
				}
			}
			*/

			// How many winning players will share this subpot?
			var eligible_winners = 0;
			for (var w=0; w<sorted_winners.length; w++) {
				if (sorted_winners[w].bet_sum >= curr_sum)
					eligible_winners++;
			}

			// What is the amount of this subpot?
			var eligible_sum = 0;
			for (var p=0; p<this.players.length; p++) {
				eligible_sum += Math.min(curr_sum, this.players[p].bet_sum);
			}

			// Distribute the money of this subpot
			for (var w=0; w<sorted_winners.length; w++) {
				if (sorted_winners[w].bet_sum >= curr_sum) {
					sorted_winners[w].cash += Math.floor(eligible_sum/eligible_winners);
				}
			}

			// Update the bet_sum of each player
			for (var p=0; p<this.players.length; p++) {
				this.players[p].bet_sum -= Math.min(curr_sum, this.players[p].bet_sum);
			}

		}


		// Return any remaining bets to each player
		for (var p=0; p<this.players.length; p++) {
			this.players[p].cash += this.players[p].bet_sum;
			this.players[p].bet_sum = 0;
		}



		// Update the GUI
		for (var p=0; p<this.players.length; p++) {
			if (this.players[p].state != "BANKRUPT") {
				this.players[p].reset_bet();
				_global.env.GUI.set_cash(this.players[p]);
				_global.env.GUI.set_bet(this.players[p]);

				if (this.players[p].cash <= 0) {

					this.players[p].state = "BANKRUPT";
					_global.env.GUI.set_state(this.players[p]);
				}
			}
		}




		// If we have just one player left, this player is the winner
		var non_bankrupt_count = 0;
		for (var p=0; p<this.players.length; p++) {
			if (this.players[p].state != "BANKRUPT")
				non_bankrupt_count++;
		}


		if (non_bankrupt_count <= 1) {

			// Set game over
			for (var p=0; p<this.players.length; p++) {
				if (this.players[p].state != "BANKRUPT")
					_global.env.GUI.game_over(this.players[p]);  //This is the winning player
			}

		}

		// Ready for a new hand
		_global.env.GUI.ready_for_new_hand();

	},


	// This function is called when there is only one player left.
	forfeit: function() {

		var player_index;
		for (var i=0; i<this.players.length; i++) {
			if ( (this.players[i].state == "WAITING") || (this.players[i].state == "ALL-IN") || (this.players[i].state == "CHECK") || (this.players[i].state == "CALL") || (this.players[i].state == "RAISE") || (this.players[i].state == "BET")) {
				player_index = i;
				break;
			}
		}

		_global.env.GUI.set_winners(new Array(this.players[player_index]), locale[lang]["gameScreen winner"]);

		var temp_array = new Array();
		temp_array[0] = player_index;
		this.allocate_bets(temp_array);

	},

	bet_request: function() {

		if (this.stop)
			return;

		if ( (this.players[this.current_player].state != "BANKRUPT") && (this.players[this.current_player].state != "ALL-IN") ) {
			_global.bet_interval_id = -1;
			_global.env.GUI.set_current_player(this.players[this.current_player]);
			this.players[this.current_player].state = "DECIDING";
			_global.env.GUI.set_state(this.players[this.current_player]);
			this.players[this.current_player].fire("bet");
		}
	},


	bet_response: function(response, amount, debug) {
            
            //alert(this.players[this.current_player].name + " -- response: " + response + ", amount: " + amount);

		if (debug)
			trace(this.players[this.current_player].name + " -- response: " + response + ", amount: " + amount);


		if (_global.bet_interval_id != -1) {
			try {
				//clearInterval(_global.bet_interval_id);
                                clearTimeout(_global.bet_interval_id);
			} catch (exception) {
				trace("Exception: " + exception);
			}
		}



		var current_bet = this.get_current_bet();
		var bet_amount = 0;
		if (response == "CALL") {
                    //AuPlayer.playSound("http://192.168.1.100/temp/scratch.mp3");
                    if(_global.skip == false){
                        AuPlayer.playSoundRelative("sound/scratch.mp3");
                    }
                    
			bet_amount = current_bet - this.players[this.current_player].bet[this.round];
		} else {
			bet_amount = amount;
		}

		this.players[this.current_player].bet[this.round] 	+= bet_amount;
		this.players[this.current_player].cash 	 		-= bet_amount;
		_global.env.GUI.set_bet(this.players[this.current_player]);
		_global.env.GUI.set_cash(this.players[this.current_player]);
		this.update_pot();

		// Update the player state
		if (response == "BET") {
			if (bet_amount == 0){
                            //AuPlayer.playSound("http://192.168.1.100/temp/scratch.mp3");
                            if(_global.skip == false){
                                AuPlayer.playSoundRelative("sound/scratch.mp3");
                            }
				this.players[this.current_player].state  = "CHECK";
                }else if (this.players[this.current_player].bet[this.round] == current_bet){

               // AuPlayer.playSound("http://192.168.1.100/temp/scratch.mp3");
               if(_global.skip == false){
                    AuPlayer.playSoundRelative("sound/scratch.mp3");
               }
				this.players[this.current_player].state  = "CALL";
                }else if (this.players[this.current_player].bet[this.round] > current_bet) {
                    //AuPlayer.playSound("http://192.168.1.100/temp/scratch.mp3");
                    if(_global.skip == false){
                        AuPlayer.playSoundRelative("sound/scratch.mp3");
                    }
				this.latest_raise = bet_amount - current_bet;
				this.players[this.current_player].state  = "RAISE";
			} else
				this.players[this.current_player].state  = "BET"; //Should never happen

		} else {
			this.players[this.current_player].state = response;
		}

		// Check for all in
		if (this.players[this.current_player].cash == 0) {
                    //AuPlayer.playSound("http://192.168.1.100/temp/winner.mp3");
                    if(_global.skip == false){
                         AuPlayer.playSoundRelative("sound/winner.mp3");
                    }
			this.players[this.current_player].state = "ALL-IN";
		}

		_global.env.GUI.set_state(this.players[this.current_player]);





		this.current_player++;
		if (this.current_player == this.players.length)
			this.current_player = 0;


		// Find the next player who has not folded, bankrupted or gone all-in
		if (this.select_next_player()) {

			_global.env.GUI.set_current_player(this.players[this.current_player]);



			// Is the current player the only player left?
			var all_other_fold = true;
			for (var p=0; p<this.players.length; p++) {
				if (p != this.current_player) {
					if ( (this.players[p].state != "FOLD") && (this.players[p].state != "BANKRUPT") ) {
						all_other_fold = false;
						break;
					}
				}
			}


			if (all_other_fold) {
				//this.evaluate_hand();
				this.forfeit();
				return;
			}





			// Does this player already have the highest bet?
			var higher_bet_exist = false;
			for (var p=0; p<this.players.length; p++) {
				if (p != this.current_player) {
					if (this.players[p].bet[this.round] >= this.players[this.current_player].bet[this.round]) {
						higher_bet_exist = true;
						break;
					}
				}
			}

			if (!higher_bet_exist) {
				_global.env.GUI.hide_arrow();
				this.show_next_round_message();
				//_global.next_round_interval = setInterval(_global.env.GAME.next_round.bind(_global.env.GAME), 3600);
				if(_global.skip == true){
                                    //_global.next_round_interval = setInterval("_global.env.GAME.next_round()", 300);
                                    _global.next_round_interval = setTimeout("_global.env.GAME.next_round()", 300);
                                }else{
                                    //_global.next_round_interval = setInterval("_global.env.GAME.next_round()", 3600);
                                    _global.next_round_interval = setTimeout("_global.env.GAME.next_round()", 3600);
                                }

                                return;
			}




			if (this.players[this.current_player].state == "WAITING") {

				// This player is waiting to bet
				this.bet_request();

			} else {

				// This player has already performed a bet response
				// See what is expected from the player

				if (this.players[this.current_player].state == "CHECK") {

					var all_other_check_or_fold = true;

					// Check if all other players have checked or folded
					for (var p=0; p<this.players.length; p++) {
						if ( (this.players[p].state != "CHECK") && (this.players[p].state != "CALL") && (this.players[p].state != "FOLD") && (this.players[p].state != "BANKRUPT") ) {

							// Have this player gone all-in this round?
							if (this.players[p].state == "ALL-IN") {
								//if (this.players[p].bet[this.round] > 0) {
								if (this.players[p].bet[this.round] > this.players[this.current_player].bet[this.round]) {
									all_other_check_or_fold = false;
									break;
								}
							} else {
								all_other_check_or_fold = false;
								break;
							}


						}
					}

					if (all_other_check_or_fold) {
						_global.env.GUI.hide_arrow();
						this.show_next_round_message();
						//_global.next_round_interval = setInterval(_global.env.GAME.next_round.bind(_global.env.GAME), 3600);
                                                if(_global.skip == true){
                                                    //_global.next_round_interval = setInterval("_global.env.GAME.next_round()", 300);
                                                    _global.next_round_interval = setTimeout("_global.env.GAME.next_round()", 300);
                                                }else{
                                                    //_global.next_round_interval = setInterval("_global.env.GAME.next_round()", 3600);
                                                    _global.next_round_interval = setTimeout("_global.env.GAME.next_round()", 3600);
                                                }

                                    } else {
						this.bet_request();
					}

					return;
				}

				if ( (this.players[this.current_player].state == "BET") || (this.players[this.current_player].state == "CALL") || (this.players[this.current_player].state == "RAISE")) {

					var higher_bet = false

					// Check if someone has bet more since this bet
					for (var p=0; p<this.players.length; p++) {
						if ( (this.players[p].state == "BET") || (this.players[p].state == "CALL") || (this.players[p].state == "RAISE") || (this.players[p].state == "ALL-IN") ) {
							if (this.players[p].bet[this.round] > this.players[this.current_player].bet[this.round]) {
								higher_bet = true;
								break;
							}
						}
					}

					if (higher_bet) {
						this.bet_request();  	// A higher bet exist, give the opportunity to re-bet
					} else {
						_global.env.GUI.hide_arrow();
						this.show_next_round_message();
						//_global.next_round_interval = setInterval(_global.env.GAME.next_round.bind(_global.env.GAME), 3600); // All bets are equal, go to next round
                                               if(_global.skip == true){
                                                   //_global.next_round_interval = setInterval("_global.env.GAME.next_round()", 300);
                                                   _global.next_round_interval = setTimeout("_global.env.GAME.next_round()", 300);
                                               }else{
                                                   //_global.next_round_interval = setInterval("_global.env.GAME.next_round()", 3600);
                                                   _global.next_round_interval = setTimeout("_global.env.GAME.next_round()", 3600);
                                               }

                                    }

					return;
				}

			}

		}
                
	},


	show_next_round_message: function() {
		var message = "";
		if (this.get_nr_unfolded_players() > 1) {
			switch (this.round) {
				case 0:
					message = locale[lang]["game message prepare for the flop"];
					break;
				case 1:
					message = locale[lang]["game message prepare for the turn"];
					break;
				case 2:
					message = locale[lang]["game message prepare for the river"];
					break;
				case 3:
					message = locale[lang]["game message evaluating hands"];
					break;
			}
		} else {
			message = locale[lang]["game message evaluating hands"];
		}
                
		if (message != "")
			_global.blinkMessage(message);
	},


	// Returns the minimum bet a player needs to make
	// to stay in the game
	get_current_bet: function() {
		var bet = -1;
		for (var p=0; p<this.players.length; p++) {
			if (this.players[p].state != "BANKRUPT") {
				if (this.players[p].bet[this.round] > bet) {
					bet = this.players[p].bet[this.round];
				}
			}
		}


		if (_global.env.USE_BLINDS && (this.round==0)) {
			var real_big_blind_amount = Math.min(this.get_max_bet(), this.big_blind_amount);
			return Math.max(bet, real_big_blind_amount);
		} else {
			return bet;
		}
	},

	// Returns the bet the minimum current player has to make
	get_required_bet: function() {
		var current_bet = this.get_current_bet();
		var player_bet  = this.players[this.current_player].bet[this.round];
		return Math.max(this.big_blind_amount, current_bet-player_bet+this.latest_raise);  //The least required bet is represented by the big blind
	},

	get_pot_size: function() {
		var pot = 0;
		for (var p=0; p<this.players.length; p++) {
			if (this.players[p].state != "BANKRUPT") {
				pot += this.players[p].total_bet();
			}
		}
		return pot;
	},

	// Checks if all previous players have checked
	is_checkable: function(debug) {

		for (var i=0; i<this.players.length; i++) {
			if (this.players[i].state != "BANKRUPT") {

				if (debug)
					trace(this.players[i].bet[this.round] + " ("+this.players[i].name+") > " + this.players[this.current_player].bet[this.round] + " ("+this.players[this.current_player].name+") = " + ( (this.players[i].bet[this.round] > this.players[this.current_player].bet[this.round]) ));


				if ( (this.players[i].bet[this.round] > this.players[this.current_player].bet[this.round]) ) {
					if (debug)
						trace(".....not checkable\n");
					return false;
				}
			}
		}

		if (debug)
			trace(".....checkable!\n");
		return true;
	},

	// Checks if a player has previously betted
	is_callable: function() {

		var is_cable = false;

		// First check if a call is theoretically possible
		for (var i=0; i<this.players.length; i++) {
			if (this.players[i].state != "BANKRUPT") {

				//if ( (this.players[index].bet[this.round] > this.players[this.current_player].bet[this.round]) && ( (this.players[index].state != "BET") || (this.players[index].state != "CALL") ) ) {
				if (this.players[i].bet[this.round] > this.players[this.current_player].bet[this.round]) {
					is_cable = true;
					break;
				}
			}
		}

		if (is_cable) {

			// Then check if the current player has enough cash to call
			if ( this.get_current_bet() > (this.players[this.current_player].cash+this.players[this.current_player].bet[this.round]) )
				return false;
			else
				return true;

		} else {
			return false;
		}

	},

	should_player_show_cards: function(player) {

		var nr_of_calls = 0;
		var nr_of_allin = 0;
		var nr_of_check = 0;
		var nr_of_wait  = 0;
		var nr_of_raise = 0;
		for (var i=0; i < this.players.length; i++) {
			switch (this.players[i].state) {
				case "CALL":
					nr_of_calls++;
					break;

				case "ALL-IN":
					nr_of_allin++;
					break;

				case "CHECK":
					nr_of_check++;
					break;

				case "WAITING":
					nr_of_wait++;
					break;

				case "RAISE":
					nr_of_raise++;
					break;

			}
		}


		// A folded or bankrupt player should not display his/her cards
		if ( (player.state == "FOLD") || (player.state == "BANKRUPT") ) {
			return false;
		}

		// This implies that all players have checked, otherwise we wouldnt end up here.
		// Show the cards...
		if (player.state == "CHECK") {
			if (nr_of_check >= 2)
				return true;
			else
				return false;
		}

		// A player that has gone all in should show his cards
		if ( (player.state == "ALL-IN") || (player.state == "RAISE") || (player.state == "CALL") ) {
			// Have someone else called or gone all-in?
			// Also, if there is more than one player waiting, this means that another player
			// has previously gone all-in, and there is another player interesting in seeing the
			// hand of this player.
			if ( (nr_of_calls>=1) || (nr_of_allin>=2) || (nr_of_wait>=1) || (nr_of_raise>=1) || (nr_of_check>=1) )
				return true;
			else
				return false;
		}


		return false;
	},

	get_max_bet: function() {
		return this.players[this.current_player].cash;
	},

	get_current_player_bet: function() {
		return this.players[this.current_player].bet[this.round];
	},

	get_current_player: function() {
		return this.players[this.current_player];
	},

	get_player_by_name: function(name) {
		for (var i=0; i<this.players.length; i++) {
			if (this.players[i].name == name)
				return this.players[i];
		}
		return null;
	},

	get_player_index: function(name) {
		for (var i=0; i<this.players.length; i++) {
			if (this.players[i].name == name)
				return i;
		}
		return -1;
	},

	get_nr_players_left: function() {
		var counter = 0;
		for (var i=0; i<this.players.length; i++) {
			if (this.players[i].state != "BANKRUPT")
				counter++;
		}
		return counter;
	},

	get_nr_betting_players: function() {
		var counter = 0;
		for (var i=0; i<this.players.length; i++) {
			if ( (this.players[i].state != "BANKRUPT") && (this.players[i].state != "FOLD") && (this.players[i].state != "ALL-IN") )
				counter++;
		}
		return counter;
	},

	get_nr_unfolded_players: function() {
		var counter = 0;
		for (var i=0; i<this.players.length; i++) {
			if ( (this.players[i].state != "BANKRUPT") && (this.players[i].state != "FOLD") )
				counter++;
		}
		return counter;
	},

	toString: function() {
		var str = "Players:";
		for (var i=0; i<this.players.length; i++) {
			str += this.players[i] + "\n";
		}
		return str;
	}



}