
_global.arr_index_of = function(arr, val) {
	for (var i=0; i<arr.length; i++) {
		if (arr[i] == val)
			return i;
	}
	return -1;
}

function arr_sort_number(a, b) {
	return a - b
}

function multi_arr_to_string(arr) {
	var str = "";
	for (var i=0; i<arr.length; i++) {
		for (var j=0; j<arr[i].length; j++) {
			str += arr[i][j] + ", ";
		}
		str += "\n";
	}
	return str;
}

function fact(num) {
	switch(num) {
		case 1:
			return 1;
		case 2:
			return 2;
		case 3:
			return 6;
		case 4:
			return 24;
		case 5:
			return 120;
		case 6:
			return 720;
		case 7:
			return 5040;
		case 8:
			return 40320;
		case 9:
			return 362880;
		case 10:
			return 3628800;
	}
}




function generate_possible_subsets(in_array, subset_size) {

	// The good ol' brute force way...

	// How many combinations are there?   n! / k!(n-k)!
	var amount = Math.round(fact(in_array.length)/(fact(subset_size)*fact(in_array.length-subset_size)))

	var subsets = new Array();
	while (subsets.length < amount) {

		var to_check = new Array();
		for (var i=0; i<subset_size; i++) {

			var taken = true;

			while (taken) {

				var intra_taken  = false;
				var random_index = Math.floor(Math.random()*in_array.length);

				// Has this element already been picked?
				for (var c=0; c<to_check.length; c++) {
					if (to_check[c] == in_array[random_index]) {
						intra_taken = true;
						break;
					}
				}

				if (!intra_taken) {
					to_check.push(in_array[random_index]);
					taken = false;
				}

			}
		}

		var taken = false;

		// Has this combination already been taken?
		for (var s=0; s<subsets.length; s++) {

			var equal_counter = 0;
			for (var e=0; e<subset_size; e++) {
				if (_global.arr_index_of(subsets[s], to_check[e]) != -1)
					equal_counter += 1;
			}

			if (equal_counter == subset_size) {
				taken = true;
				break;
			}
		}

		// This subset has not been added yet, add it
		if (!taken) {
			subsets.push(to_check);
		}

	}

	return subsets;
}
_global.generate_possible_subsets = generate_possible_subsets;




// This function evaluates the hand of a player, combined with the community cards.
// The response is an array of length three, with the following characteristics:
//
// [Hand Name, Hand Value, Hand Combination]
//
function evaluate_deck(to_eval) {


	// ----------------------
	// Royal Straight Flush
	// ----------------------
	if ( 	(to_eval.contains("h", 14)) &&
		(to_eval.contains("h", 13)) &&
		(to_eval.contains("h", 12)) &&
		(to_eval.contains("h", 11)) &&
		(to_eval.contains("h", 10)) )
	{
		return new Array(locale[lang]["game_helper royal straight flush"], 100, to_eval);
	}

	// ----------------------
	// Straight Flush
	// ----------------------
	var _sorted = to_eval.get_sorted_deck(true);
	for (var c=0; c<_sorted.cards.length; c++) {

		var nr_in_row = 1;

		for (var d=c+1; d<_sorted.cards.length; d++) {
			if ( 	(_sorted.cards[d].value == (_sorted.cards[d-1].value+1)) &&
				(_sorted.cards[d].suite == (_sorted.cards[d-1].suite)) )
				nr_in_row++;
			else
				break;
		}

		if (nr_in_row >= 5) {
			return new Array(locale[lang]["game_helper straight flush"], 10, _sorted);
		}
	}

	// ----------------------
	// Four of a kind
	// ----------------------
	for (var c=0; c<to_eval.cards.length; c++) {
		var _card = to_eval.cards[c];
		if (to_eval.value_count(_card.value) == 4)
		{
			return new Array(locale[lang]["game_helper four of a kind"], 9, to_eval);
		}
	}

	// ----------------------
	// Full House
	// ----------------------
	for (var c=0; c<to_eval.cards.length; c++) {
		var _card = to_eval.cards[c];
		var count = to_eval.value_count(_card.value);

		if ( (count == 2) || (count == 3) )
		{
			var other_count = (count==2 ? 3 : 2);
			for (var d=0; d<to_eval.cards.length; d++) {
				var _card2 = to_eval.cards[d];
				if (_card2.value != _card.value) {
					var other_count = to_eval.value_count(_card2.value);
					if ( ( (count == 2) && (other_count == 3) ) || ( (count == 3) && (other_count >= 2) ) ) {
						return new Array(locale[lang]["game_helper full house"], 8, to_eval);
					}
				}
			}
		}
	}

	// ----------------------
	// Flush
	// ----------------------
	if ( 	(to_eval.suite_count("h") >= 5) ||
		(to_eval.suite_count("d") >= 5) ||
		(to_eval.suite_count("s") >= 5) ||
		(to_eval.suite_count("c") >= 5) )
	{
		return new Array(locale[lang]["game_helper flush"], 7, to_eval);
	}

	// ----------------------
	// Straight
	// ----------------------
	var _sorted = to_eval.get_sorted_deck();
	for (var c=0; c<_sorted.cards.length; c++) {

		var nr_in_row = 1;

		for (var d=c+1; d<_sorted.cards.length; d++) {
			if (_sorted.cards[d].value == (_sorted.cards[d-1].value+1))
				nr_in_row++;
			else if (_sorted.cards[d].value != (_sorted.cards[d-1].value))  //If a d12 follows h12, for example. This shouldn't disrupt the counting
				break;
		}

		if (nr_in_row >= 5) {
			return new Array(locale[lang]["game_helper straight"], 6, _sorted);
		}
	}

	// ----------------------
	// Three of a kind
	// ----------------------
	for (var c=0; c<to_eval.cards.length; c++) {
		var _card = to_eval.cards[c];
		if (to_eval.value_count(_card.value) == 3)
		{
			return new Array(locale[lang]["game_helper three of a kind"], 5, to_eval);
		}
	}


	// ----------------------
	// One pair or Two pairs
	// ----------------------
	for (var c=0; c<to_eval.cards.length; c++) {
		var _card = to_eval.cards[c];
		if (to_eval.value_count(_card.value) == 2)
		{
			// See if another pair exist
			for (var d=c; d<to_eval.cards.length; d++) {
				var _card2 = to_eval.cards[d];
				if (_card2.value != _card.value) {

					if (to_eval.value_count(_card2.value) == 2)
					{
						return new Array(locale[lang]["game_helper two pairs"], 4, to_eval);
					}


				}
			}

			return new Array(locale[lang]["game_helper one pair"], 3, to_eval);
		}
	}


	return new Array("Nothing", -1, to_eval);
}




// This function feeds the evaluate_deck function with possible decks
// and returns an array of the possible hands rendered from this
// combination
function get_best_hand(required_deck, optional_deck) {

	// Generate all possible versions of required_deck and combine
	// these with optional_deck. Feed the evaluate_deck function with these
	// combinations.

	var subsets 	= generate_possible_subsets(optional_deck.cards, 5-required_deck.cards.length);
	var to_return 	= new Array();

	for (var s=0; s<subsets.length; s++) {

		var deck_to_check 	= new Deck();
		var subset_deck 	= new Deck();
		for (var c=0; c<subsets[s].length; c++) {
			subset_deck.stack(subsets[s][c]);
		}

		deck_to_check.add_deck(required_deck);
		deck_to_check.add_deck(subset_deck);

		// Now we should have a hand of five cards, whereof
		// the required deck is a subset. Evaluate this deck!
		to_return.push(evaluate_deck(deck_to_check));

	}

	return to_return;
}
_global.evaluate_deck = evaluate_deck;












// ****************************************
//
// Hand Comparing Functions
//
// ****************************************

function compare_winning_hands(winner_array) {

	// Construct a stripped version of the winner array
	// where the only information propagated to the
	// helper functions are the index of a player and
	// his / her deck.
	var stripped_array = new Array();
	for (var i=0; i<winner_array.length; i++) {
		stripped_array[i] = new Array(winner_array[i][0], winner_array[i][1][2]);
	}


	switch (winner_array[0][1][1]) {
		case 100:
			// Royal Straight Flush, should never end up here
			return winner_array[0][0];
			break;
		case 10:
			// Straight Flush
			return hand_compare_straights(stripped_array,true);
			break;
		case 9:
			// Four of a Kind
			return hand_compare_pairs(stripped_array, 4, 1);
			break;
		case 8:
			// Full House
			return hand_compare_full_houses(stripped_array);
			break;
		case 7:
			// Flush
			return hand_compare_flushes(stripped_array);
			break;
		case 6:
			// Straight
			return hand_compare_straights(stripped_array, false);
			break;
		case 5:
			// Three of a Kind
			return hand_compare_pairs(stripped_array, 3, 1);
			break;
		case 4:
			// Two Pairs
			return hand_compare_pairs(stripped_array, 2, 2);
			break;
		case 3:
			// One Pair
			return hand_compare_pairs(stripped_array, 2, 1);
			break;
		case -1:
			// Nothing
			return hand_compare_nothings(stripped_array);
			break;
	}

}
_global.compare_winning_hands = compare_winning_hands;




function hand_compare_full_houses(in_array) {

	var array_to_check = new Array();

	for (var i=0; i<in_array.length; i++) {

		array_to_check[i] = new Array(in_array[i][0], new Array(-1, -1));  // [player index, flush array]

		var deck = in_array[i][1];

		// Find all 3's first
		for (var c=0; c<deck.cards.length; c++) {
			var _card = deck.cards[c];
			if ( (deck.value_count(_card.value) == 3) && (array_to_check[i][1][0]<_card.value) ) { // Pick the highest possible 3
				array_to_check[i][1][0] = _card.value;  // Save the 3's value
			}
		}

		// Find all 2's
		for (var c=0; c<deck.cards.length; c++) {
			var _card = deck.cards[c];
			if ( (deck.value_count(_card.value) >= 2) && (array_to_check[i][1][0]!=_card.value) ) { // Make sure this value is different from the 3
				array_to_check[i][1][1] = _card.value;  // Save the 2's value
				break;
			}
		}

	}


	// We have an array on the form:
	// [player index, [3's value, 2's value]]
	var highest_array = new Array();
	var highest_value = -1;

	// Has someone got the highest 3?
	for (var c=0; c<array_to_check.length; c++) {
		if (array_to_check[c][1][0] > highest_value) {
			highest_value = array_to_check[c][1][0];
			highest_array = new Array();
			highest_array.push(array_to_check[c][0]);
		} else if (array_to_check[c][1][0] == highest_value) {
			highest_array.push(array_to_check[c][0]);
		}
	}

	if (highest_array.length == 1) {
		return highest_array;
	} else {

		// Some players share the same 3, continue by checking the 2's

		var highest_array = new Array();
		var highest_value = -1;

		for (var c=0; c<array_to_check.length; c++) {
			if (array_to_check[c][1][1] > highest_value) {
				highest_value = array_to_check[c][1][1];
				highest_array = new Array();
				highest_array.push(array_to_check[c][0]);
			} else if (array_to_check[c][1][1] == highest_value) {
				highest_array.push(array_to_check[c][0]);
			}
		}

		return highest_array;
	}


}

function hand_compare_flushes(in_array) {

	var array_to_check = new Array();


	// For each hand, find out which suite the flush is in, and
	// gather all flush cards in an array, that will be examined
	// below.

	for (var i=0; i<in_array.length; i++) {

		array_to_check[i] = new Array(in_array[i][0], new Array());  // [player index, flush array]

		var deck = in_array[i][1];
		var flush_suite = "";

		if (deck.suite_count("h") >= 5) {
			flush_suite = "h";
		} else if (deck.suite_count("d") >= 5) {
			flush_suite = "d";
		} else if (deck.suite_count("s") >= 5) {
			flush_suite = "s";
		} else if (deck.suite_count("c") >= 5) {
			flush_suite = "c";
		}

		// Extract all cards of this suite to a separate array
		for (var c=0; c<deck.cards.length; c++) {
			if (deck.cards[c].suite == flush_suite)
				array_to_check[i][1].push(deck.cards[c].value);
		}
	}

	// Which flush is greatest
	return get_greatest_array(array_to_check, 5);
}

function hand_compare_straights(in_array, suite_important) {


	var array_to_check = new Array();

	// For each hand, find out its straight
	for (var i=0; i<in_array.length; i++) {

		array_to_check[i] = new Array(in_array[i][0], new Array());  // [player index, straight array]

		var deck = in_array[i][1];

		var _sorted = deck.get_sorted_deck(suite_important);

		for (var c=(_sorted.cards.length-1); c>=0; c--) {

			var nr_in_row = 1;
			var strght = new Array();
			strght.push(_sorted.cards[c].value);

			for (var d=c-1; d>=0; d--) {
				if (_sorted.cards[d].value == (_sorted.cards[d+1].value-1)) {

					if (suite_important) {
						if (_sorted.cards[d].suite != (_sorted.cards[d+1].suite))
							break;
					}

					strght.push(_sorted.cards[d].value);
				} else {
					if (_sorted.cards[d].value != (_sorted.cards[d+1].value))
						break;
				}
			}

			if (strght.length >= 5) {
				array_to_check[i][1] = strght;
				break;
			}
		}

	}

	// Which straight is greatest
	return get_greatest_array(array_to_check, 5);
}


// count:2, diff_count:1 -> Pairs
// count:2, diff_count:2 -> Two Pairs
// count:3, diff_count:1 -> Three of a kind
// count:4, diff_count:1 -> Four of a kind
function hand_compare_pairs(in_array, count, diff_count) {

        //alert("in_array: " + in_array);

	var pairs = new Array(in_array.length); // This array will hold all pairs found in each hand

	// Init the pair array
	for (var i=0; i<pairs.length; i++) {
		pairs[i] = new Array();
	}


	// For each hand, find out its pair
	for (var i=0; i<in_array.length; i++) {
		var deck = in_array[i][1];

		for (var c=0; c<deck.cards.length; c++) {
			var _card = deck.cards[c];

			if ( 	(deck.value_count(_card.value) == count) &&
				(_global.arr_index_of(pairs[i], _card.value) == -1) ) // Only count unique pairs
			{
				pairs[i].push(_card.value);
			}
		}
                //alert("paris[" + i + "] " + pairs[i] );


                //remove the pairs that are not biggest
                if(pairs[i].length > diff_count){
                    for(var ii = 0; ii < pairs[i].length-1; ii ++){
                       for(var jj = ii; jj < pairs[i].length-1; jj++){
                           if(pairs[i][jj] < pairs[i][jj+1]){
                               var temp = pairs[i][jj];
                               pairs[i][jj] = pairs[i][jj+1];
                               pairs[i][jj+1] = temp;
                           }
                       }
                    }
                }
                var newPair = new Array();
                for(var kk = 0; kk < diff_count; kk ++){
                    newPair.push(pairs[i][kk]);
                }
                pairs[i] = newPair;

	}



	// Now we have an array for each competing hand containing its unique
	// pair values. Now try to find out which has the greatest pair.

	var array_to_check = new Array();

	for (var i=0; i<pairs.length; i++) {
		array_to_check[i] = new Array(in_array[i][0], pairs[i]);  // [player index, pair array]
	}

	// See which pair is greatest
	var greatest = get_greatest_array(array_to_check, diff_count);
        //alert("array_to_check  " + array_to_check  + " greatest " + greatest );

	if (greatest.length == 1) {
		// We have found the hand with the greatest pair!
		return greatest;
	} else {
		// Two or more hands share the same combination of pairs

		// We need to differentiate based on the remaining cards.
		// This means that the hand with the highest combination of
		// the remaining cards (the other cards constitute the pair)
		// will be the winner.

		var array_to_check = new Array();
		for (var i=0; i<greatest.length; i++) {

			var deck;
			var _pairs;

			// Which element in the in_array corresponds to this element in the 'greatest' array?
			for (var j=0; j<in_array.length; j++) {
				if (in_array[j][0] == greatest[i]) {
					deck = in_array[j][1];
					_pairs = pairs[j];
				}
			}
                        //alert("_pairs: " + _pairs);

			var card_array = new Array() // This array will hold all cards not belonging to a pair

			// Go trough all cards and pick out those not belonging to a pair
			for (var c=0; c<deck.cards.length; c++) {
				var _card = deck.cards[c];

				// Is this card part of a pair?
				if (_global.arr_index_of(_pairs, _card.value) == -1) {
					card_array.push(_card.value);
				}

			}
                        //alert("card_arary: " + card_array);

			// Pick the cards not
			array_to_check[i] = new Array(greatest[i], card_array);  // [player index, card array]
		}
                //alert("array_to_check 0: " + array_to_check[0]);
                //alert("array_to_check 1: " + array_to_check[1]);

		// See which of the remaining cards of the hands are greatest
		var greatest = get_greatest_array(array_to_check, _global.env.HAND_SIZE-count*diff_count);
                //alert("greatest: " + greatest);
		return greatest; // An array of winners, preferable with one element
	}

}

function hand_compare_nothings(in_array) {

	var array_to_check = new Array();

	// Construct a new array containing just the player index and the card value array
	for (var i=0; i<in_array.length; i++) {
		array_to_check[i] = new Array(in_array[i][0], in_array[i][1].get_value_array());
	}

	return get_greatest_array(array_to_check, _global.env.HAND_SIZE);
}



// This is a helper function which basically picks out the greatest array of values
// from a set of input arrays. It also maintains a supplied index.
//
//  INPUT:::
//  [ [index, array of numbers], [index, array of numbers] ..., [index, array of numbers] ], number of elements
//
//  OUTPUT:::
//  An array of the indeces of the greatest arrays
function get_greatest_array(in_array, nr_of_cards) {

	// First sort each hand, with the greatest value at position 0
	for (var i=0; i<in_array.length; i++) {
		in_array[i][1] = in_array[i][1].sort(arr_sort_number);
		in_array[i][1] = in_array[i][1].reverse();
	}


	// For each hand, pick out the nr_of_cards cards that have been determined
	// by the calling function to be interesting.
	for (var i=0; i<in_array.length; i++) {

		var interesting_array = new Array();
		for (var c=0; c<nr_of_cards; c++) {
			interesting_array.push(in_array[i][1][c]);
		}

		in_array[i][1] = interesting_array; // Overwrite the old definition
	}


	var array_to_check = in_array;

	// Who has the greatest cards?
	for (var c=0; c<in_array[0][1].length; c++) {  // This is how many values there are

		var highest_value  = -1; 		// Will contain the highsest value of this set of cards
		var highest_arrays = new Array();	// Will contain the arrays that share the highest value

		for (var i=0; i<array_to_check.length; i++) {

			if (array_to_check[i][1][c] == highest_value) {
				highest_arrays.push(array_to_check[i]);
			} else if (array_to_check[i][1][c] > highest_value) {
				highest_value = array_to_check[i][1][c];
				highest_arrays = new Array();
				highest_arrays.push(array_to_check[i]);
			}

		}

		if (highest_arrays.length == 1) {
			var arr = new Array();
			arr.push(highest_arrays[0][0]);
			return arr;
		} else {
			array_to_check = highest_arrays;
		}

	}

	var to_return = new Array();
	for (var i=0; i<array_to_check.length; i++) {
		to_return.push(array_to_check[i][0]);
	}

	return to_return;
}