var before_help_screen;
var _global = {
    env: null,
    characters: new Array(),
    
    showingMessage: false,
    
    //Screens
    front_screen: null,
    charsel_screen: null,
    game_screen: null,
    winner_screen: null,
    game_over_screen: null,
    game_menu: null,
    
    //Formats
    helpFormat: "textHelp", 
    nameFormat: "textName", 
    scoreboardFormat: "textScoreboard", 
    foldFormat: "textFold", 
    winningHandFormat: "textWinningHand", 
    headerFormat: "textHeader", 
    messageFormat: "textMessage",
    playerStateFormat: "textPlayerState",
    menuSelectedFormat: "textMenuSelected",
    menuUnselectedFormat: "textMenuUnselected",
    
    // Misc
    bet_interval_id: -1
}

/**
 * Bind - Extention of Function that makes it possible
 * 		  to bind a certain scope to a function.
 *
 * e.g. myfunc.bind(anObj) returns a function that when executed makes 'this' point to anObj
 * 		This behaviour is very useful in places where functions are passed as references (callbacks functions etc.)
 * 
 *
 */
Function.prototype.bind = function bind() {
    if (arguments.length < 2 && arguments[0] === undefined) return this; // no object to bind
    var __method = this; // func.bind(..) makes this = func
    var object = arguments[0]; // extract the object to bind to (which is arg0)
	
    return function() {
        return __method.apply(object, arguments);
    }
};

_global.showMessage = function() {
    _global.showingMessage = true;
	
    $("message_message").setText(arguments[0]);
    $("message_message").setTextFormat(_global.messageFormat);
	
    if (typeof arguments[1] != "undefined") {
        $("message_submessage").setText(arguments[1]);
        $("message_submessage").setTextFormat(_global.messageFormat);	
    } else {
        $("message_submessage").setText("");
    }	
	
    var height = ( (arguments.length == 1) ? $("message_messagebg").singleRowHeight : $("message_messagebg").doubleRowHeight);
    /*$("message_messagebg").style.top = 270;*/
    $("message_messagebg").style.height = height;
    $("message_messagebg").style.width = Stage.width;
        
    $("message").style.visibility = "visible";
   
}

_global.hideMessage = function() {
    _global.showingMessage = false;
    $("message_message").setText("");
    $("message_submessage").setText("");
    $("message").style.visibility = "hidden";
}

var blinkerInterval;
_global.blinkMessage = function() 
{
    //clearInterval(blinkerInterval);
    clearTimeout(blinkerInterval);
    if (arguments[0] != "") {
        if(arguments.length > 1)
        {
            _global.showMessage(arguments[0], arguments[1]);
        }
        else
        {
            _global.showMessage(arguments[0]);      
                    
        }
        //blinkerInterval = setInterval(_global.blinkMessage, 3500, "", "");
        if(_global.skip == true){
            //blinkerInterval = setInterval("_global.blinkMessage('','')", 200);
            blinkerInterval = setTimeout("_global.blinkMessage('','')", 200);
        }else{
            //blinkerInterval = setInterval("_global.blinkMessage('','')", 3500);
            blinkerInterval = setTimeout("_global.blinkMessage('','')", 3500);
        }
        
    } else {
        _global.hideMessage(/*arguments*/);		
    }
    
}

_global.show_help = function() 
{
    _global.blinkMessage("");
    before_help_screen = current_screen;
    _global.help_screen.doShow();
    current_screen = _global.help_screen;
}

_global.hide_help = function() 
{ 
    _global.help_screen.doHide();
    current_screen = before_help_screen; 
}

    
_global.__ExitGame = function()
{
    //window.location = window.location;
    //_global.show_front();
   // widgetAPI.sendExitEvent();
   if(accedobroadband.querystring.getValue("modelid") != "LAXXB650_HKG"){
                                 alert("sendReturnEvent()");
                                 widgetAPI.sendReturnEvent (); // this will get the TV restart! so comment out
                             }
    alert("exit game");
};

_global.show_game_over = function() 
{	
    _global.game_over_screen.doShow();
    current_screen = _global.game_over_screen;   
}

_global.show_winner = function(winner_name, winning_round, is_player) 
{	
	
    for (var i=0; i<_global.characters.length; i++) {
        if (_global.characters[i][0] == winner_name) {
            _global.winner_screen.set_winner(_global.characters[i], winning_round, is_player);
            break;
        }
    }
    
    _global.winner_screen.doShow();		
    current_screen = _global.winner_screen; 
}

_global.show_charsel = function() 
{
        if (_global.env.GAME != null)
        _global.env.GAME.stop = true;

    _global.blinkMessage("");
    _global.game_menu.doHide();
    _global.game_screen.doHide();
    _global.charsel_screen.doShow();
    _global.front_screen.doHide();	
    _global.help_screen.doHide();		
    _global.winner_screen.doHide();		
    _global.game_over_screen.doHide();
    current_screen = _global.charsel_screen;
        $("press_skip").style.visibility = "hidden";
    $("gamemenu2").style.visibility = "hidden";
}

_global.show_front = function() 
{		   
    if (_global.env.GAME != null)
        _global.env.GAME.stop = true;

    _global.blinkMessage("");
     
   
    _global.game_menu.doHide();
    _global.game_screen.doHide();
    _global.charsel_screen.doHide();
    _global.front_screen.doShow();	
    _global.help_screen.doHide();		
    _global.winner_screen.doHide();	
    _global.game_over_screen.doHide();
    $("press_skip").style.visibility = "hidden";
    $("gamemenu2").style.visibility = "hidden";
    current_screen = _global.front_screen;    
}

_global.start_game = function(characters) 
{  
    _global.env.GAME = new Game();
	
    var human_player = player_factory(characters[0][0]);
    _global.env.GAME.add_player(human_player);
    for (var i=1; i<characters.length; i++) {
        var c_player = avatar_factory(characters[i][0], characters[i][2]);
        _global.env.GAME.add_player(c_player);		
    }
	
    _global.game_menu.doHide();
    _global.game_screen.doShow();
    _global.front_screen.doHide();
    _global.charsel_screen.doHide();	
    _global.help_screen.doHide();
    _global.winner_screen.doHide();	
    _global.game_over_screen.doHide();	
    current_screen = _global.game_screen;	

    _global.env.GAME.start();  
}

_global.get_icon = function(pname) {
    for (var i=0; i<this.characters.length; i++) {
        if (this.characters[i][0] == pname)
            return this.characters[i][3];
    }
    return "";
}

_global.stb_bet = function() {
    _global.game_menu.doShow();	
    if (current_screen != _global.help_screen) {
        current_screen = _global.game_menu;	
    } else {
        before_help_screen = _global.game_menu;
    }
}

_global.stb_bet_done = function() {
    _global.game_menu.doHide();
    current_screen = _global.game_screen;		
}

function player_factory(name) {
    var player = new Player(name, _global.env.INIT_CASH, -1);
    player.add_event_handler("bet", _global.stb_bet);
    return player;
}

function avatar_factory(name, braveness) {
    var player = new Player(name, _global.env.INIT_CASH, braveness);
    player.add_event_handler("bet", avatar_bet);
    return player;
}