var KEY_BACKSPACE;
var KEY_TAB;
var KEY_RETURN;
var KEY_SHIFT;
var KEY_CONTROL;
var KEY_ALT;
var KEY_CAPSLOCK;
var KEY_STOP;
var KEY_STANDBY;
var KEY_SPACE;
var KEY_LEFT;
var KEY_UP;
var KEY_RIGHT;
var KEY_DOWN;
var KEY_SCROLL_LEFT;
var KEY_SCROLL_UP;
var KEY_SCROLL_RIGHT;
var KEY_SCROLL_DOWN;

var KEY_0;
var KEY_1;
var KEY_2;
var KEY_3;
var KEY_4;
var KEY_5;
var KEY_6;
var KEY_7;
var KEY_8;
var KEY_9;

var KEY_INFO;
var KEY_TEXT;
var KEY_TV;
var KEY_WWW;
var KEY_RED;
var KEY_GREEN;
var KEY_YELLOW;
var KEY_BLUE;
var KEY_PORTAL;
var KEY_BACK;
var KEY_OK;
var KEY_MENU;

var KEY_VOLUME_DOWN;
var KEY_VOLUME_UP;
var KEY_MUTE;

var KEY_MEDIA_PLAY;
var KEY_MEDIA_REW;
var KEY_MEDIA_FF;
var KEY_MEDIA_STOP;

var version;

function init_keycodes() {

	switch (version) {
		case "0":
			KEY_BACKSPACE      = 0;
			KEY_TAB            = 0;
			KEY_RETURN         = 0;
			KEY_SHIFT          = 0;
			KEY_CONTROL        = 0;
			KEY_ALT            = 0;
			KEY_CAPSLOCK       = 0;
			KEY_STOP           = 0;
			KEY_STANDBY        = 0;
			KEY_SPACE          = 0;
			KEY_LEFT           = appContext.input.KEY_LEFT;
			KEY_UP             = appContext.input.KEY_UP;
			KEY_RIGHT          = appContext.input.KEY_RIGHT;
			KEY_DOWN           = appContext.input.KEY_DOWN;
			KEY_SCROLL_LEFT    = 0;
			KEY_SCROLL_UP      = 0;
			KEY_SCROLL_RIGHT   = 0;
			KEY_SCROLL_DOWN    = 0;

			KEY_0              = appContext.input.KEY_0;
			KEY_1              = appContext.input.KEY_1;
			KEY_2              = appContext.input.KEY_2;
			KEY_3              = appContext.input.KEY_3;
			KEY_4              = appContext.input.KEY_4;
			KEY_5              = appContext.input.KEY_5;
			KEY_6              = appContext.input.KEY_6;
			KEY_7              = appContext.input.KEY_7;
			KEY_8              = appContext.input.KEY_8;
			KEY_9              = appContext.input.KEY_9;

			KEY_INFO           = appContext.input.KEY_INFO;
			KEY_TEXT           = 0;
			KEY_TV             = appContext.input.KEY_TV;
			KEY_WWW            = 0;
			KEY_RED            = appContext.input.KEY_RED;
			KEY_GREEN          = appContext.input.KEY_GREEN;
			KEY_YELLOW         = appContext.input.KEY_YELLOW;
			KEY_BLUE           = appContext.input.KEY_BLUE;
			KEY_PORTAL         = appContext.input.KEY_PORTAL;
			KEY_BACK           = appContext.input.KEY_BACK;
			KEY_OK             = appContext.input.KEY_OK;
			KEY_MENU           = appContext.input.KEY_MENU;

			KEY_VOLUME_DOWN    = appContext.input.KEY_VOLUME_DOWN;
			KEY_VOLUME_UP      = appContext.input.KEY_VOLUME_UP;
			KEY_MUTE           = 0;

			KEY_MEDIA_PLAY     = appContext.input.KEY_MEDIA_PLAY_PAUSE;
			KEY_MEDIA_REW      = appContext.input.KEY_MEDIA_REWIND;
			KEY_MEDIA_FF       = appContext.input.KEY_MEDIA_FAST_FORWARD;
			KEY_MEDIA_STOP     = appContext.input.KEY_MEDIA_STOP;
			break;

		case "1":
			KEY_BACKSPACE      = 0x00080008;
			KEY_TAB            = 0x00090009;
			KEY_RETURN         = 0x000D000D;
			KEY_SHIFT          = 0x00100010;
			KEY_CONTROL        = 0x00110011;
			KEY_ALT            = 0x00120012;
			KEY_CAPSLOCK       = 0x00140014;
			KEY_STOP           = 0x001B001B;
			KEY_STANDBY        = 0x011B001B;
			KEY_SPACE          = 0x00200020;
			KEY_LEFT           = 0x00250025;
			KEY_UP             = 0x00260026;
			KEY_RIGHT          = 0x00270027;
			KEY_DOWN           = 0x00280028;
			KEY_SCROLL_LEFT    = 0x01250025;
			KEY_SCROLL_UP      = 0x01260026;
			KEY_SCROLL_RIGHT   = 0x01270027;
			KEY_SCROLL_DOWN    = 0x01280028;

			KEY_0              = 0x00300030;
			KEY_1              = 0x00310031;
			KEY_2              = 0x00320032;
			KEY_3              = 0x00330033;
			KEY_4              = 0x00340034;
			KEY_5              = 0x00350035;
			KEY_6              = 0x00360036;
			KEY_7              = 0x00370037;
			KEY_8              = 0x00380038;
			KEY_9              = 0x00390039;

			KEY_INFO           = 0x00700070;
			KEY_TEXT           = 0x00710071;
			KEY_TV             = 0x00720072;
			KEY_WWW            = 0x00730073;
			KEY_RED            = 0x00740074;
			KEY_GREEN          = 0x00750075;
			KEY_YELLOW         = 0x00760076;
			KEY_BLUE           = 0x00770077;
			KEY_PORTAL         = 0x00780078;
			KEY_BACK           = 0x00790079;
			KEY_OK             = 0x007A007A;
			KEY_MENU           = 0x007B007B;

			KEY_VOLUME_DOWN    = 0x01710071;
			KEY_VOLUME_UP      = 0x01720072;
			KEY_MUTE           = 0x01730073;

			KEY_MEDIA_PLAY     = 0x01740074;
			KEY_MEDIA_REW      = 0x01750075;
			KEY_MEDIA_FF       = 0x01760076;
			KEY_MEDIA_STOP     = 0x01770077;
			break;
	}

}

function getBox(){
	return "kreatel";
}

function initiateKeyHandler() {

    try {
	// TOI JS API Version 0
        inputhandler = appContext.input;
        inputhandler.addEventListener (inputhandler.ON_KEY_PRESS, keyHandler);
        inputhandler.setNumericMode(inputhandler.MENU_MODE);
        version = "0";
    } catch (ex) {
    }

    try {
    	// TOI JS API Version 1
    	inputhandler = toiEnv.input;
	inputhandler.addEventListener (inputhandler.ON_KEY_DOWN, keyHandler);
	version = "1";
    } catch (ex) {
    }

    init_keycodes();

}


function keyHandler(e) {

    var switchOn;

    switch (version) {
    	case "0":
    		switchOn = e.keyCode;
    		break;
    	case "1":
    		switchOn = e.extendedKeyCode;
    		break;
    }

    switch (switchOn) {
    		case KEY_0:

			keyEventFunction("0");
			break;

		case KEY_UP:
			keyEventFunction("UP");
			break;

		case KEY_DOWN:
			keyEventFunction("DOWN");
			break;

		case KEY_LEFT:
			keyEventFunction("LEFT");
			break;

		case KEY_RIGHT:
			keyEventFunction("RIGHT");
			break;

		case KEY_OK:
			keyEventFunction("OK");
			break;

		case KEY_RED:
			keyEventFunction("RED");
			break;

		case KEY_GREEN:
			keyEventFunction("GREEN");
			break;

		case KEY_YELLOW:
			keyEventFunction("YELLOW");
			break;

		case KEY_BLUE:
			keyEventFunction("BLUE");
			break;

		case KEY_VOLUME_UP:
			keyEventFunction("VOLUP");
			break;

		case KEY_VOLUME_DOWN:
			keyEventFunction("VOLDOWN");
			break;

		case KEY_BACK:
			keyEventFunction("BACK");
			break;

		case KEY_MENU:
			keyEventFunction("MENU");
			break;

		/*
		case KEY_MEDIA_PLAY_PAUSE:
			keyEventFunction("PLAY");
			break;

		case KEY_MEDIA_REWIND:
			keyEventFunction("RW");
			break;

		case KEY_MEDIA_FAST_FORWARD:
			keyEventFunction("FF");
			break;

		case KEY_MEDIA_STOP:
			keyEventFunction("STOP");
			break;
		*/

		case KEY_INFO:
			keyEventFunction("HELP");
			break;



		case KEY_1:
			keyEventFunction("1");
			break;

		case KEY_2:
			keyEventFunction("2");
			break;

		case KEY_3:
			keyEventFunction("3");
			break;

		case KEY_4:
			keyEventFunction("4");
			break;

		case KEY_5:
			keyEventFunction("5");
			break;

		case KEY_6:
			keyEventFunction("6");
			break;

		case KEY_7:
			keyEventFunction("7");
			break;

		case KEY_8:
			keyEventFunction("8");
			break;

		case KEY_9:
			keyEventFunction("9");
			break;

		case KEY_TV:
			keyEventFunction("TV");
			break;

		case KEY_PORTAL:
			keyEventFunction("PORTAL");
			break;


	}
}