function Player(name, cash, braveness) {
    this.name 	= name;
    this.cash 	= cash;
    this.braveness	= braveness;

    // Possible values:
    //   WAITING
    //   CHECK
    //   CALL
    //   FOLD
    //   BET
    //   DECIDING
    //   RAISE
    //   BANKRUPT
    //   ALL-IN
    this.state	= "WAITING";

    this.reset_bet();
    this.deck = null;
    this.bet = 0;

    this.event_handlers = new Array();
}

Player.prototype = 
{
    bet_sum: 0,
    
    reset_bet: function() {
        this.bet = new Array();
        for (var i=0; i<5; i++) {
            this.bet[i] = 0;
        }
    },

    total_bet: function() {
        var to_return = 0;
        for (var i=0; i<this.bet.length; i++) {
            to_return += this.bet[i];
        }
        return to_return;
    },

    summarize_bet: function() {
        this.bet_sum = this.total_bet();
    },



    add_event_handler: function(event, handler) {
        this.event_handlers[event] = handler;
    },

    fire: function(event) {
        if (this.event_handlers[event]) {
            this.event_handlers[event]();
        }
    },

    toString : function() {
        return this.name + " (cash: " + this.cash + ", bet: " + this.bet + ") " + this.state;
    }

}

/*
function player_factory(name) {
	var player = new Player(name, env.INIT_CASH, -1);
	player.add_event_handler("bet", stb_bet);
	return player;
}

function avatar_factory(name, braveness) {
	var player = new Player(name, env.INIT_CASH, braveness);
	player.add_event_handler("bet", avatar_bet);
	return player;
}*/
