function CharacterSelectionScreen(parent)
{   
    this.env = _global.env;
    this.done_selecting = false;
      
    parent.appendChild(createFrame("charselscreen",
                    {   "visibility":"hidden",
                        "width":Stage.width, 
                        "height": Stage.height,
                        "backgroundImage":"url('img/background_charsel.jpg')",
                        "position":"absolute", "top":0, "left":0
                    }));
    
    this.root = $("charselscreen");
   
    //Background Image
    //this.root.appendChild(createImage("images/background_charsel.jpg", "bg_charsel", {"position":"absolute", "top":0, "left":0}));

    this.selection_x = Math.round(Stage.width/2-(_global.env.BIG_CHAR_IMAGE_WIDTH + _global.env.BIG_CHAR_IMAGE_SPACING)/2);
    this.selection_y = 120-18;    
    
    // Whitebox was here.. what does it do? Nevermind, found it!
    this.root.appendChild(createFrame("whitebox", {"position": "absolute","top": 0, "left": 0, "visbility":"hidden" , "width": _global.env.BIG_CHAR_IMAGE_WIDTH, "height": _global.env.BIG_CHAR_IMAGE_HEIGHT, "background":"#FFFFFF"}));
    
    // The base clip for all character data
    this.root.appendChild(createFrame("charactersContainer", {"overflow":"hidden", "position": "absolute","top": 0, "left": 0, "width":Stage.width, "height":Stage.height}));
    $("charactersContainer").appendChild(createFrame("characters", {"position": "absolute","top": this.selection_y, "left": this.selection_x}));
    
    // The chosen players
    this.root.appendChild(createFrame("chosen_character0", {"position": "absolute"}));
    $("chosen_character0").appendChild(createImage("img/blank.gif","chosen_character0_img", {"width": _global.env.BIG_CHAR_IMAGE_WIDTH, "height": _global.env.BIG_CHAR_IMAGE_HEIGHT}));
    this.root.appendChild(createFrame("chosen_character1", {"position": "absolute"}));
    $("chosen_character1").appendChild(createImage("img/blank.gif","chosen_character1_img", {"width": _global.env.BIG_CHAR_IMAGE_WIDTH, "height": _global.env.BIG_CHAR_IMAGE_HEIGHT}));
    this.root.appendChild(createFrame("chosen_character2", {"position": "absolute"}));
    $("chosen_character2").appendChild(createImage("img/blank.gif","chosen_character2_img", {"width": _global.env.BIG_CHAR_IMAGE_WIDTH, "height": _global.env.BIG_CHAR_IMAGE_HEIGHT}));
    this.root.appendChild(createFrame("chosen_character3", {"position": "absolute"}));
    $("chosen_character3").appendChild(createImage("img/blank.gif","chosen_character3_img", {"width": _global.env.BIG_CHAR_IMAGE_WIDTH, "height": _global.env.BIG_CHAR_IMAGE_HEIGHT}));
    this.root.appendChild(createFrame("chosen_character4", {"position": "absolute"}));
    $("chosen_character4").appendChild(createImage("img/blank.gif","chosen_character4_img", {"width": _global.env.BIG_CHAR_IMAGE_WIDTH, "height": _global.env.BIG_CHAR_IMAGE_HEIGHT}));
    
   
    // The your-player arrow
    this.root.appendChild(createImage("img/your_player_arrow.png", "your_player_arrow", {"position": "absolute"}));

    // The your-player label
    this.root.appendChild(createTextField("your_player_label", parseInt($("your_player_arrow").style.left), parseInt($("your_player_arrow").style.top)+15, 200, 60));

    // The your-opponents label
    this.root.appendChild(createTextField("your_opponents_label", 0, 450, Stage.width, 60));

    // The header label
    this.root.appendChild(createTextField("header", 35, 35-18, 430, 100));

    // The additional header label
    this.root.appendChild(createTextField("additional_header", 210, 80-26, 500, 100));
}

CharacterSelectionScreen.prototype = 
{
    current_option: 0,
    
    doShow: function()
    {
        this.root.style.visibility = "visible";
        
        this.current_option = 0;
        this.done_selecting = false;
        
        //There was some check for options being undefined, but DUHH they are always undefined it seems, so skipping
        for (var c=0; c<_global.characters.length; c++) {
            var character = _global.characters[c];

            $("characters").appendChild(createFrame("character"+c));
            $("character"+c).appendChild(createImage(character[1], "character"+c+"_img", {"left": c*(_global.env.BIG_CHAR_IMAGE_WIDTH+_global.env.BIG_CHAR_IMAGE_SPACING), "top": 0, "position": "absolute"}));
        }
        
        // Hide previously chosen players
        for(var i=0; i<5; i++)
        {
            $("chosen_character"+i+"_img").src = "img/blank.gif";
            $("chosen_character"+i+"_img").style.visibility = "visible";
        }

        $("characters").style.left = this.selection_x;
        $("characters").style.top = this.selection_y;
        
        //TODO: whitebox
        $("charactersContainer").style.visibility = "visible";
        
        $("header").setText(locale[lang]["characterSelectionScreen choose your player"]);
        $("header").setTextFormat(_global.headerFormat);
        $("additional_header").setText(locale[lang]["characterSelectionScreen use left right to select"]);
        $("additional_header").setTextFormat(_global.messageFormat);
        $("header").style.visibility = "visible";
        $("additional_header").style.visibility = "visible";
        
        $("your_player_arrow").style.visibility = "visible";
        $("your_player_label").style.visibility = "visible";
        $("your_player_arrow").style.left = this.selection_x + 40;
        $("your_player_arrow").style.top = this.selection_y + _global.env.BIG_CHAR_IMAGE_HEIGHT + 10 - 38-10;
        $("your_player_label").style.left = parseInt($("your_player_arrow").style.left)-180;//+30;
        $("your_player_label").style.top = parseInt($("your_player_arrow").style.top)+10+14+5;
        $("your_player_label").setText(locale[lang]["characterSelectionScreen your choice"]);
        $("your_player_label").setTextFormat(_global.messageFormat);
        
        $("your_opponents_label").style.top = $("your_player_label").style.top;
        $("your_opponents_label").setText("");
        $("your_opponents_label").setTextFormat(_global.messageFormat);
        $("whitebox").style.visibility = "hidden";

//        var samsung_bar = document.getElementById("samsung_navigation_bar");
//        samsung_navigation_bar_clear_bar(samsung_bar);
//        samsung_navigation_bar_add_button(samsung_bar,"LEFTRIGHT");
//        samsung_navigation_bar_add_button(samsung_bar,"ENTER");
//        samsung_navigation_bar_add_button(samsung_bar,"RETURN");
        this.updateSamsungHelp();
    },
    
    doHide: function()
    {
        

        this.root.style.visibility = "hidden";
        
        $("your_player_arrow").style.visibility = "hidden";
        $("your_player_label").style.visibility = "hidden";
        $("whitebox").style.visibility = "hidden";
        $("header").style.visibility = "hidden";
        $("additional_header").style.visibility = "hidden";
        $("charactersContainer").style.visibility = "hidden";
        for(var i=0; i<5; i++)
        {
            $("chosen_character"+i+"_img").style.visibility = "hidden";
        }
    },
    
    updateSamsungHelp:function(){
        var samsung_bar = document.getElementById("samsung_navigation_bar");
        samsung_navigation_bar_clear_bar(samsung_bar);
        
        if(this.done_selecting){
            samsung_navigation_bar_add_button(samsung_bar,"ENTER");
            samsung_navigation_bar_add_button(samsung_bar,"RETURN");             
        }else{
            if(this.current_option == 0){
                
                samsung_navigation_bar_add_button(samsung_bar,"RIGHT");
                samsung_navigation_bar_add_button(samsung_bar,"ENTER");
                samsung_navigation_bar_add_button(samsung_bar,"RETURN"); 
            }else if(this.current_option == (_global.characters.length-1)){
                samsung_navigation_bar_add_button(samsung_bar,"LEFT");
                samsung_navigation_bar_add_button(samsung_bar,"ENTER");
                samsung_navigation_bar_add_button(samsung_bar,"RETURN");                
            }else{
                samsung_navigation_bar_add_button(samsung_bar,"LEFTRIGHT");
                samsung_navigation_bar_add_button(samsung_bar,"ENTER");
                samsung_navigation_bar_add_button(samsung_bar,"RETURN");                 
            }
        }

    },

    keyEventFunction:function (event)
    {
        if(this.done_selecting)
        {
            if(event == "OK")
            {
                _global.start_game(this.game_characters);
            }
            return;
        }
        
        switch(event) 
        {
                    
            case "LEFT":
                if(this.current_option > 0)
                {
                   // AuPlayer.playSound("http://192.168.1.100/temp/scratch.mp3");
                    $("characters").style.left = parseInt($("characters").style.left) + (_global.env.BIG_CHAR_IMAGE_WIDTH + _global.env.BIG_CHAR_IMAGE_SPACING);
                    this.current_option--;
                }
                break;
                    
            case "RIGHT":
                if(this.current_option < (_global.characters.length-1))
                {
                    //AuPlayer.playSound("http://192.168.1.100/temp/scratch.mp3");
                    $("characters").style.left = parseInt($("characters").style.left) - (_global.env.BIG_CHAR_IMAGE_WIDTH  + _global.env.BIG_CHAR_IMAGE_SPACING);
                    this.current_option++;
                }   
                break;

            case "OK":
                this.game_characters = new Array();
                this.game_characters.push(_global.characters[this.current_option]);
                
                while (this.game_characters.length < 5) 
                {
                    var random_index = Math.floor(Math.random()*_global.characters.length);

                    var already_picked = false;
                    for (var i=0; i<this.game_characters.length; i++) 
                    {
                        if (this.game_characters[i][0] == _global.characters[random_index][0]) 
                        {
                            already_picked = true;
                            break;
                        }
                    }

                    if (!already_picked) 
                    {
                        this.game_characters.push(_global.characters[random_index]);
                    }
                }
                
                for (var i=0; i<5; i++) 
                {
                    $("chosen_character" + i + "_img").src = this.game_characters[i][1];
                    $("chosen_character" + i).style.left = Math.round(Stage.width/2 - (2.5-i)*(_global.env.BIG_CHAR_IMAGE_WIDTH  + _global.env.BIG_CHAR_IMAGE_SPACING));
                    $("chosen_character" + i).style.top = this.selection_y - 18;
                    $("chosen_character" + i).style.visibility = "visible";
                }
                
                $("charactersContainer").style.visibility = "hidden";
                
                
                var dest_x = Math.round(Stage.width/2 - 2.5*(_global.env.BIG_CHAR_IMAGE_WIDTH + _global.env.BIG_CHAR_IMAGE_SPACING));
                $("your_player_arrow").style.left = dest_x + 25;
                $("your_player_label").style.left = dest_x-110;

               

                // Set the label
                $("your_player_label").setText(locale[lang]["characterSelectionScreen you"]);
                $("your_player_label").setTextFormat(_global.messageFormat);

                $("your_opponents_label").setText(locale[lang]["characterSelectionScreen your opponents"]);
                $("your_opponents_label").setTextFormat(_global.messageFormat);
                $("your_opponents_label").style.left = 0;//dest_x + 2*(_global.env.BIG_CHAR_IMAGE_WIDTH + _global.env.BIG_CHAR_IMAGE_SPACING); // or use 500
                
                $("header").setText(locale[lang]["characterSelectionScreen players in this game"]);
                $("header").setTextFormat(_global.headerFormat);

                $("additional_header").setText(locale[lang]["characterSelectionScreen press ok to start"]);
                $("additional_header").setTextFormat(_global.messageFormat);
                
                
                $("whitebox").style.visibility 	= "visible";
                $("whitebox").style.left 	= parseInt($("chosen_character0").style.left) - 5;
                $("whitebox").style.top 	= parseInt($("chosen_character0").style.top) - 5;
                $("whitebox").style.width 	= _global.env.BIG_CHAR_IMAGE_WIDTH + 10;
                $("whitebox").style.height 	= _global.env.BIG_CHAR_IMAGE_HEIGHT + 10;

                this.done_selecting = true;   
                
                break;
        }
        this.updateSamsungHelp();
    }
}