function FrontScreen(parent)
{
    this.env = _global.env;
    parent.appendChild(createFrame("frontscreen",
                    {   "visibility":"hidden",
                        "width":Stage.width, 
                        "height": Stage.height,
                        "backgroundImage":"url('img/background_front.jpg')",
                        "position":"absolute", "top":0, "left":0
                    }
                ));
    this.root = $("frontscreen");
    
    //Background Image
    //this.root.appendChild(createImage("images/background_front.jpg", "bg_front", {"position":"absolute", "top":0, "left":0}));
    
    //Menu Options
    this.options = new Array();
  
    this.options.push(ButtonHandler.create_button("front_option1", "", locale[lang]["start_button_selected"], locale[lang]["start_button_unselected"], this.root,  213, 430, 184, 50));
    this.options.push(ButtonHandler.create_button("front_option2", "", locale[lang]["help_button_selected"], locale[lang]["help_button_unselected"], this.root, 397, 430, 184, 50));
    this.options.push(ButtonHandler.create_button("front_option3", "", locale[lang]["exit_button_selected"], locale[lang]["exit_button_unselected"], this.root, 581, 430, 184, 50));
}

FrontScreen.prototype = 
{
    current_option: 0,
    
    doShow: function()
    {
        var samsung_bar = document.getElementById("samsung_navigation_bar");
        samsung_navigation_bar_clear_bar(samsung_bar);
        samsung_navigation_bar_add_button(samsung_bar,"LEFTRIGHT");
        samsung_navigation_bar_add_button(samsung_bar,"ENTER");
        samsung_navigation_bar_add_button(samsung_bar,"RETURN");

        this.root.style.visibility = "visible";
        
        this.current_option = 0;
        ButtonHandler.select_button(this.options[0]);
        ButtonHandler.unselect_button(this.options[1]);
        ButtonHandler.unselect_button(this.options[2]);
    },
    
    doHide: function()
    {
        this.root.style.visibility = "hidden";
    },
    
    keyEventFunction:function (event)
    {
        
        switch(event) {
            case "LEFT":
                    if (this.current_option > 0) {
                            //AuPlayer.playSound("http://192.168.1.100/temp/scratch.mp3");
                            ButtonHandler.unselect_button(this.options[this.current_option]);
                            this.current_option--;
                            ButtonHandler.select_button(this.options[this.current_option]);
                    } else {
                            
                    }
                    break;

            case "RIGHT":
                    if (this.current_option < 2) {
                           //AuPlayer.playSound("http://192.168.1.100/temp/scratch.mp3");
                            ButtonHandler.unselect_button(this.options[this.current_option]);
                            this.current_option++;
                            ButtonHandler.select_button(this.options[this.current_option]);
                    } else {
                            
                    }
                    break;

            case "OK":
                    
                    switch (this.current_option) {
                            case 0:
                                    // Start game
                                    
                                    _global.show_charsel();
                                    break;
                            case 1:
                                    // Rules
                                    
                                    _global.show_help();
                                    break;
                            case 2:
                                    // Exit
                                    
                                    _global.__ExitGame();
                                    break;
                    }
                    break;
        }
    }
}