function GameMenu(parent)
{
    this.env = _global.env;
    parent.appendChild(createFrame("gamemenu",{"position":"absolute","visibility":"hidden", "width":338,"height":71, "backgroundImage":"url('img/menu_background.png')"}));
    this.root = $("gamemenu");
    parent.appendChild(createFrame("gamemenu2",{"position":"absolute","visibility":"hidden", "width":338,"height":71, "backgroundImage":"url('img/menu_background.png')"}));
    $("gamemenu2").style.visibility = "hidden";
    $("gamemenu2").style.left = 30;
    $("gamemenu2").style.top = 460-18;
    
    //Background Image
    //this.root.appendChild(createImage("images/menu_background.gif", "bg_menu", {"position":"absolute", "top":0, "left":0}));
    this.root.style.left = 30;
    this.root.style.top = 460-18;
    
    // Menu Options
    this.options = new Array();
    this.options.push(ButtonHandler.create_button("gamemenu_option0", locale[lang]["gameMenu bet"]+"10", "img/selected_button.png", "img/unselected_button.png", this.root,  3+5,20, 67+20, 30));
    this.options.push(ButtonHandler.create_button("gamemenu_option1", locale[lang]["gameMenu bet"]+"1", "img/selected_button.png", "img/unselected_button.png", this.root,  75+20, 20, 67+20, 30));
    this.options.push(ButtonHandler.create_button("gamemenu_option2", locale[lang]["gameMenu check"], "img/selected_button.png", "img/unselected_button.png", this.root, 145+30, 5, 67, 30));
    this.options.push(ButtonHandler.create_button("gamemenu_option3", locale[lang]["gameMenu fold"], "img/selected_button.png", "img/unselected_button.png", this.root, 145+30, 33, 67, 30));
    this.options.push(ButtonHandler.create_button("gamemenu_option4", locale[lang]["gameMenu all in"], "img/big_selected_button.png", "img/big_unselected_button.png", this.root, 216+30, 5, 68, 62));
    
    // Betting direction arrows
    this.root.appendChild(createImage("img/arrow_up.png",   "arrow_up_10", {"position":"absolute", "left":32.5, "top":5, "width": 38, "height": 20}));
    this.root.appendChild(createImage("img/arrow_down.png", "arrow_down_10", {"position":"absolute", "left":32.5, "top":45, "width": 38, "height": 20}));
    
    this.root.appendChild(createImage("img/arrow_up.png",   "arrow_up_1", {"position":"absolute", "left":119.5, "top":5, "width": 38, "height": 20}));
    this.root.appendChild(createImage("img/arrow_down.png", "arrow_down_1", {"position":"absolute", "left":119.5, "top":45, "width": 38, "height": 20}));
    
    
    $("gamemenu2").appendChild(createTextField("press_skip", 30/300*338, 65/63*71-55, 300, 50));
    $("press_skip").setText(locale[lang]["gameMenu press 0 to skip"]);
    $("press_skip").setTextFormat(_global.playerStateFormat);
    //$("press_skip").style.visibility = "hidden";

    // Label
    this.root.appendChild(createTextField("press_ok", 30/300*338, 65/63*71-3, 300, 50));
    $("press_ok").setText(locale[lang]["gameMenu press ok to place bet"]);
    $("press_ok").setTextFormat(_global.playerStateFormat);
    $("press_ok").style.visibility = "hidden";
}

GameMenu.prototype = 
    {
    current_option: 0,
    checkable: false,
    calalble: false,
    
    doShow: function()
    {


        this.root.style.visibility = "visible";
        this.current_option = 1;
	
	//Showing buttons that are always visible, option 2 is conditional
        ButtonHandler.show_button(this.options[0]);
	ButtonHandler.show_button(this.options[1]);
	ButtonHandler.show_button(this.options[3]);
	ButtonHandler.show_button(this.options[4]);
	
        ButtonHandler.select_button(this.options[1]);
        $("arrow_up_1").style.visibility = "visible";
        $("arrow_down_1").style.visibility = "visible";
        $("press_ok").style.visibility = "visible";
        
        this.checkable	= false;
        this.callable	= false;
        
        if (_global.env.GAME.is_checkable()) {
            ButtonHandler.show_button(this.options[2]);
            ButtonHandler.set_text(this.options[2], locale[lang]["gameMenu check"]);
            this.checkable = true;
        } else if (_global.env.GAME.is_callable()) {
            ButtonHandler.show_button(this.options[2]);
            ButtonHandler.set_text(this.options[2], locale[lang]["gameMenu call"]);
            this.callable = true;
        } else {
            ButtonHandler.hide_button(this.options[2]);
        }

        ButtonHandler.set_text(this.options[0], locale[lang]["gameMenu bet"] + _global.env.GAME.big_blind_amount);

        // Unselect buttons that are not in focus
        ButtonHandler.unselect_button(this.options[0]);
        ButtonHandler.unselect_button(this.options[2]);
        ButtonHandler.unselect_button(this.options[3]);
        ButtonHandler.unselect_button(this.options[4]);

        $("arrow_up_10").style.visibility = "hidden";
        $("arrow_down_10").style.visibility = "hidden";

        this.max_bet = _global.env.GAME.get_max_bet();
        this.min_bet = _global.env.GAME.get_required_bet();
        this.call_bet = _global.env.GAME.get_current_bet();
        this.acc_bet = 0;
        this.blind_amt = _global.env.GAME.get_current_player_bet();  //Needed in the context of blinds

        //this.root.style.top = 600;
	this.updateSamsungHelp();
    },
    
    doHide: function()
    {
	this.root.style.visibility = "hidden";
        
        $("arrow_up_1").style.visibility = "hidden";
        $("arrow_down_1").style.visibility = "hidden";
        $("arrow_up_10").style.visibility = "hidden";
        $("arrow_down_10").style.visibility = "hidden";
        $("press_ok").style.visibility = "hidden";
        
	ButtonHandler.hide_button(this.options[0]);
	ButtonHandler.hide_button(this.options[1]);
	ButtonHandler.hide_button(this.options[2]);
	ButtonHandler.hide_button(this.options[3]);
	ButtonHandler.hide_button(this.options[4]);
        this.updateSamsungHelp();
    },
    
    do_check_call: function() {
	_global.stb_bet_done();

	// Reset intermediate betting
	var player = _global.env.GAME.get_current_player();
	player.cash += this.acc_bet;
	player.bet[_global.env.GAME.round] -= this.acc_bet;

	if (this.checkable)
	    _global.env.GAME.bet_response("CHECK", 0);
	if (this.callable)
	    _global.env.GAME.bet_response("CALL", 0);
    },
    
    keyEventFunction:function (event)
    {
        
	switch(event) 
	{
	    case "UP":

		if ( (this.current_option == 0) || (this.current_option == 1) ) {

		    var player = _global.env.GAME.get_current_player();

		    var bet_factor = this.current_option==0 ? _global.env.GAME.big_blind_amount : 1;
		    var to_bet = Math.min(player.cash, bet_factor);

		    //if ( (player.bet[env.GAME.round] + to_bet) <= this.max_bet) {


		    this.acc_bet += to_bet;

		    player.cash -= to_bet;
		    player.bet[_global.env.GAME.round] += to_bet;
		    _global.env.GUI.set_bet(player);
		    _global.env.GUI.set_cash(player);
		    return;
		    //}

		}

		if ( (this.current_option == 3) && (this.checkable || this.callable) ) {
		    ButtonHandler.unselect_button(this.options[this.current_option]);
		    this.current_option--;
		    ButtonHandler.select_button(this.options[this.current_option]);
		    return;
		}

		break;

	    case "DOWN":

		if ( (this.current_option == 0) || (this.current_option == 1) ) 
		{
		    if (this.acc_bet > 0) 
		    {

			var player = _global.env.GAME.get_current_player();
			var bet_factor = this.current_option==0 ? _global.env.GAME.big_blind_amount : 1;

			var to_unbet = 0;
			if ( (player.bet[_global.env.GAME.round] % bet_factor) != 0) {
			    var fact 	= player.bet[_global.env.GAME.round] / bet_factor;
			    to_unbet  	= player.bet[_global.env.GAME.round] - bet_factor*Math.floor(fact);
			} else {
			    to_unbet 	= bet_factor;
			}

			this.acc_bet -= to_unbet;

			player.cash += to_unbet;
			player.bet[_global.env.GAME.round] -= to_unbet;
			_global.env.GUI.set_bet(player);
			_global.env.GUI.set_cash(player);
			return;
		    }
		}

		if (this.current_option == 2) 
		{
		    ButtonHandler.unselect_button(this.options[this.current_option]);
		    this.current_option++;
		    ButtonHandler.select_button(this.options[this.current_option]);
		    return;
		}

		break;

	    case "RIGHT":
		if (this.current_option == 0) 
		{

		    ButtonHandler.unselect_button(this.options[this.current_option]);
		    $("arrow_up_10").style.visibility = "hidden";
		    $("arrow_down_10").style.visibility = "hidden";

		    this.current_option++;
		    $("arrow_up_1").style.visibility = "visible";
		    $("arrow_down_1").style.visibility = "visible";

		    ButtonHandler.select_button(this.options[this.current_option]);

		} 
		else if (this.current_option == 1) 
		{

		    ButtonHandler.unselect_button(this.options[this.current_option]);
		    $("arrow_up_1").style.visibility = "hidden";
		    $("arrow_down_1").style.visibility = "hidden";

		    if (this.checkable || this.callable)
			this.current_option = 2;
		    else
			this.current_option = 3;

		    ButtonHandler.select_button(this.options[this.current_option]);

		    $("press_ok").style.visibility = "hidden";

		} 
		else if ( (this.current_option == 2) || (this.current_option == 3) ) 
		{

		    ButtonHandler.unselect_button(this.options[this.current_option]);
		    this.current_option = 4;
		    ButtonHandler.select_button(this.options[this.current_option]);
		} else {
		}
		break;

	    case "LEFT":
		if ( (this.current_option == 2) || (this.current_option == 3) ) {

		    ButtonHandler.unselect_button(this.options[this.current_option]);
		    this.current_option = 1;
		    ButtonHandler.select_button(this.options[this.current_option]);

		    $("arrow_up_1").style.visibility = "visible";
		    $("arrow_down_1").style.visibility = "visible";
		    $("press_ok").style.visibility = "visible";

		} else if (this.current_option == 1) {

		    ButtonHandler.unselect_button(this.options[this.current_option]);

		    $("arrow_up_1").style.visibility = "hidden";
		    $("arrow_down_1").style.visibility = "hidden";

		    this.current_option = 0;
		    ButtonHandler.select_button(this.options[this.current_option]);
		    $("arrow_up_10").style.visibility = "visible";
		    $("arrow_down_10").style.visibility = "visible";

		} else if (this.current_option == 4) {

		    ButtonHandler.unselect_button(this.options[this.current_option]);

		    if (this.checkable || this.callable)
			this.current_option = 2;
		    else
			this.current_option = 3;

		    ButtonHandler.select_button(this.options[this.current_option]);
		} else {

		}
		break;

	    case "OK":
		switch (this.current_option) {
		    case 0:
		    case 1:
			// Bet
			var player = _global.env.GAME.get_current_player();

			// Is this a CALL/CHECK?
			if ( (this.acc_bet + this.blind_amt) == this.call_bet) {
			    this.do_check_call();
			} else {

			    if ( (this.min_bet <= this.acc_bet) || (player.cash==0) ) {
				_global.stb_bet_done();

				player.cash += this.acc_bet;
				player.bet[_global.env.GAME.round] -= this.acc_bet;
				_global.env.GAME.bet_response("BET", this.acc_bet);
			    } 
			    else 
			    {
				var check_or_call = "";
				if (this.checkable)
				    check_or_call = "check";
				else
				    check_or_call = "call";
				_global.blinkMessage(locale[lang]["gameMenu press you have to bet"][0]+this.call_bet+locale[lang]["gameMenu press you have to bet"][1]+(this.min_bet+this.blind_amt)+locale[lang]["gameMenu press you have to bet"][2]);
			    }
			}

			break;

		    case 2:
			// Call - check
			this.do_check_call();
			break;

		    case 3:
			// Fold
                        $("press_skip").style.visibility = "visible";
                        $("gamemenu2").style.visibility = "visible";
			_global.stb_bet_done();
			_global.env.GAME.bet_response("FOLD", 0);
                        $("gamemenu2").style.visibility = "visible";
			break;

		    case 4:
			// All in
			_global.stb_bet_done();

			// Reset intermediate betting
			var player = _global.env.GAME.get_current_player();
			player.cash += this.acc_bet;
			player.bet[_global.env.GAME.round] -= this.acc_bet;

			// Bet all available cash
			_global.env.GAME.bet_response("BET", player.cash);

			break;
		}
		break;

	}
        this.updateSamsungHelp();
    },

    updateSamsungHelp:function(){
        var samsung_bar = document.getElementById("samsung_navigation_bar");
        samsung_navigation_bar_clear_bar(samsung_bar);

        if(this.root.style.visibility == "hidden"){
            samsung_navigation_bar_add_button(samsung_bar,"RETURN");
        }else{
            if(this.current_option == 0){


                samsung_navigation_bar_add_button(samsung_bar,"MOVERIGHT");
                samsung_navigation_bar_add_button(samsung_bar,"ENTER");
                samsung_navigation_bar_add_button(samsung_bar,"RETURN");
            }else if(this.current_option == 1 || this.current_option == 2 || this.current_option == 3){
                samsung_navigation_bar_add_button(samsung_bar,"MOVE");
                samsung_navigation_bar_add_button(samsung_bar,"ENTER");
                samsung_navigation_bar_add_button(samsung_bar,"RETURN");
            }else if( this.current_option == 4){
                samsung_navigation_bar_add_button(samsung_bar,"MOVELEFT");
                samsung_navigation_bar_add_button(samsung_bar,"ENTER");
                samsung_navigation_bar_add_button(samsung_bar,"RETURN");
            }
        }

    }
}