function GameOverScreen(parent)
{
    this.env = _global.env;
    parent.appendChild(createFrame("gameoverscreen",
                    {   "visibility":"hidden",
                        "width":Stage.width, 
                        "height": Stage.height,
                        "backgroundImage":"url('img/background_charsel.jpg')",
                        "position":"absolute", "top":0, "left":0
                    }));
    this.root = $("gameoverscreen");
    
    //Background Image
    //this.root.appendChild(createImage("images/background_charsel.jpg", "bg_gameover", {"position":"absolute", "top":0, "left":0}));

    // The header label
    this.root.appendChild(createTextField("gameover_header", 75, 100, 450, 500));
    $("gameover_header").setText(locale[lang]["gameOverScreen gameover"]);
    $("gameover_header").setTextFormat(_global.headerFormat);
    
    // The additional header label
    this.root.appendChild(createTextField("gameover_additional_header", 320, Stage.height-100, 400, 100));
    
    $("gameover_additional_header").setText(locale[lang]["gameOverScreen press ok to continue"]);
    $("gameover_additional_header").setTextFormat(_global.messageFormat);
    
}

GameOverScreen.prototype = 
{
    
    doShow: function()
    {
        this.root.style.visibility = "visible";

        var samsung_bar = document.getElementById("samsung_navigation_bar");
        samsung_navigation_bar_clear_bar(samsung_bar);
       // samsung_navigation_bar_add_button(samsung_bar,"LEFTRIGHT");
        samsung_navigation_bar_add_button(samsung_bar,"ENTER");
        samsung_navigation_bar_add_button(samsung_bar,"RETURN");
    },
    
    doHide: function()
    {
        this.root.style.visibility = "hidden";
    },
    
    keyEventFunction:function (event)
    {
        if (event == "OK") {
            _global.show_front();
        }
    }
}
