function GameScreen(parent)
{
    this.env = _global.env;
    parent.appendChild(createFrame("gamescreen_bg",
                    {   "visibility":"hidden",
                        "width":Stage.width, 
                        "height": Stage.height,
                        "backgroundImage":"url('img/background.jpg')",
                        "position":"absolute", "top":0, "left":0
                    }));
    parent.appendChild(createFrame("gamescreen",
                    {   "visibility":"hidden",
                        "width":Stage.width, 
                        "height": Stage.height,
                        //"backgroundImage":"url('img/background.jpg')",
                        "position":"absolute", "top":-18, "left":120
                    }));
    this.root = $("gamescreen");
    this.rootbg=$("gamescreen_bg");
       
    // Player Names
    this.root.appendChild(createTextField("player1_name", 470+35, 470, 245, 50));
    this.root.appendChild(createTextField("player2_name", 50-20, 300, 245, 50));
    this.root.appendChild(createTextField("player3_name", 50-20, 70, 245, 50));
    this.root.appendChild(createTextField("player4_name", 470+120, 70, 245, 50));
    this.root.appendChild(createTextField("player5_name", 470+120, 300, 245, 50));
    
    // Player States
    this.root.appendChild(createTextField("player1_state", 475+35, 495, 240, 50));
    this.root.appendChild(createTextField("player2_state", 50-20, 325, 350, 50));
    this.root.appendChild(createTextField("player3_state", 50-20, 95, 350, 50));
    this.root.appendChild(createTextField("player4_state", 475+120, 95, 350, 50));
    this.root.appendChild(createTextField("player5_state", 475+120, 325, 300, 50));
    
    // Player Icons
    this.root.appendChild(createImage("img/blank.gif", "player1_icon", {"position": "absolute", "top": 465, "left":322, "width": _global.env.SMALL_CHAR_IMAGE_WIDTH, "height": _global.env.SMALL_CHAR_IMAGE_HEIGHT}));
    this.root.appendChild(createImage("img/blank.gif", "player2_icon", {"position": "absolute", "top": 360, "left":22+50, "width": _global.env.SMALL_CHAR_IMAGE_WIDTH, "height": _global.env.SMALL_CHAR_IMAGE_HEIGHT}));
    this.root.appendChild(createImage("img/blank.gif", "player3_icon", {"position": "absolute", "top": 125, "left":22+50, "width": _global.env.SMALL_CHAR_IMAGE_WIDTH, "height": _global.env.SMALL_CHAR_IMAGE_HEIGHT}));
    this.root.appendChild(createImage("img/blank.gif", "player4_icon", {"position": "absolute", "top": 125, "left":635-50-15, "width": _global.env.SMALL_CHAR_IMAGE_WIDTH, "height": _global.env.SMALL_CHAR_IMAGE_HEIGHT}));
    this.root.appendChild(createImage("img/blank.gif", "player5_icon", {"position": "absolute", "top": 360, "left":635-50-15, "width": _global.env.SMALL_CHAR_IMAGE_WIDTH, "height": _global.env.SMALL_CHAR_IMAGE_HEIGHT}));
    
    // Scoreboards
    this.root.appendChild(createFrame("player1_scoreboard",  {"position": "absolute", "top": 465, "left": 370+20}));
    this.root.appendChild(createFrame("player2_scoreboard",  {"position": "absolute", "top": 360, "left": 71-90}));
    this.root.appendChild(createFrame("player3_scoreboard",  {"position": "absolute", "top": 130, "left": 71-90}));
    this.root.appendChild(createFrame("player4_scoreboard",  {"position": "absolute", "top": 130, "left": 570+75}));
    this.root.appendChild(createFrame("player5_scoreboard",  {"position": "absolute", "top": 360, "left": 570+75}));
    
    //Attach Scoreboard images
    $("player1_scoreboard").appendChild(createImage("img/scoreboard.png", "player1_scoreboard_img"/*, {"top": 580, "left": 720}*/));
    $("player2_scoreboard").appendChild(createImage("img/scoreboard.png", "player2_scoreboard_img"/*, {"top": 480, "left": 135}*/));
    $("player3_scoreboard").appendChild(createImage("img/scoreboard.png", "player3_scoreboard_img"/*, {"top": 140, "left": 117}*/));
    $("player4_scoreboard").appendChild(createImage("img/scoreboard.png", "player4_scoreboard_img"/*, {"top": 140, "left": 1040}*/));
    $("player5_scoreboard").appendChild(createImage("img/scoreboard.png", "player5_scoreboard_img"/*, {"top": 480, "left": 1020}*/));
    
    // Scoreboard labels
    $("player1_scoreboard").appendChild(createTextField("player1_scoreboard_cash", 11+8, 10+4, 51, 30));
    $("player1_scoreboard").appendChild(createTextField("player1_scoreboard_bet", 11+8, 33+8, 51, 30));
    
    $("player2_scoreboard").appendChild(createTextField("player2_scoreboard_cash", 11+8, 10+4, 51, 30));
    $("player2_scoreboard").appendChild(createTextField("player2_scoreboard_bet", 11+8, 33+8, 51, 30));
    
    $("player3_scoreboard").appendChild(createTextField("player3_scoreboard_cash", 11+8, 10+4, 51, 30));
    $("player3_scoreboard").appendChild(createTextField("player3_scoreboard_bet", 11+8, 33+8, 51, 30));
    
    $("player4_scoreboard").appendChild(createTextField("player4_scoreboard_cash", 11+8, 10+4, 51, 30));
    $("player4_scoreboard").appendChild(createTextField("player4_scoreboard_bet", 11+8, 33+8, 51, 30));
    
    $("player5_scoreboard").appendChild(createTextField("player5_scoreboard_cash", 11+8, 10+4, 51, 30));
    $("player5_scoreboard").appendChild(createTextField("player5_scoreboard_bet", 11+8, 33+8, 51, 30));
    
    // Define where player cards goes
    this.card_positions = new Array();
    this.card_positions[0] = new Array();
    this.card_positions[1] = new Array();
    this.card_positions[2] = new Array();
    this.card_positions[3] = new Array();
    this.card_positions[4] = new Array();
    
    this.card_positions[0]["playing"] = new Array(310-20, 375);
    this.card_positions[1]["playing"] = new Array(150, 365);
    this.card_positions[2]["playing"] = new Array(150, 130);
    this.card_positions[3]["playing"] = new Array(475-35, 130);
    this.card_positions[4]["playing"] = new Array(475-35, 365);

    this.card_positions[0]["folded"] = new Array(310-20, 375);
    this.card_positions[1]["folded"] = new Array(150, 365);
    this.card_positions[2]["folded"] = new Array(150, 130);
    this.card_positions[3]["folded"] = new Array(475-35, 130);
    this.card_positions[4]["folded"] = new Array(475-35, 365);
    
    this.root.appendChild(createFrame("player1_cards", {"position": "absolute"}));
    this.root.appendChild(createFrame("player2_cards", {"position": "absolute"}));
    this.root.appendChild(createFrame("player3_cards", {"position": "absolute"}));
    this.root.appendChild(createFrame("player4_cards", {"position": "absolute"}));
    this.root.appendChild(createFrame("player5_cards", {"position": "absolute"}));
    
    $("player1_cards").style.left = this.card_positions[0]["playing"][0];
    $("player1_cards").style.top = this.card_positions[0]["playing"][1];
    
    $("player2_cards").style.left = this.card_positions[1]["playing"][0];
    $("player2_cards").style.top = this.card_positions[1]["playing"][1];
    
    $("player3_cards").style.left = this.card_positions[2]["playing"][0];
    $("player3_cards").style.top = this.card_positions[2]["playing"][1];
    
    $("player4_cards").style.left = this.card_positions[3]["playing"][0];
    $("player4_cards").style.top = this.card_positions[3]["playing"][1];
    
    $("player5_cards").style.left = this.card_positions[4]["playing"][0];
    $("player5_cards").style.top = this.card_positions[4]["playing"][1];
    
    // Blinds
    this.root.appendChild(createImage("img/tokens/big_blind.png", "big_blind", {"position": "absolute", "top": 0, "left": 0}));
    this.root.appendChild(createImage("img/tokens/small_blind.png", "small_blind", {"position": "absolute", "top": 0, "left": 0}));
    this.root.appendChild(createImage("img/tokens/dealer.png", "dealer_knob", {"position": "absolute", "top": 0, "left": 0}));
    
    this.root.appendChild(createTextField("big_blind_amount", 45-120, 30, Stage.width - 80, 50));
    this.root.appendChild(createTextField("small_blind_amount", 45-120, 45, Stage.width - 80, 50));
    
    // Current player arrow
    this.root.appendChild(createImage("img/current_player_arrow.png", "current_player_arrow", {"position": "absolute","top": 0, "left": 0}));
    
    // The label for the pot size
    this.root.appendChild(createTextField("pot_size", 0-120, 195+20, Stage.width, 50));
    
    this.waiting_for_ok = false;
}

GameScreen.prototype = 
    {
    
    doShow: function()
    {
        this.root.style.visibility = "visible";
        this.rootbg.style.visibility = "visible";

//        var samsung_bar = document.getElementById("samsung_navigation_bar");
//        samsung_navigation_bar_clear_bar(samsung_bar);
//        samsung_navigation_bar_add_button(samsung_bar,"MOVE");
//        samsung_navigation_bar_add_button(samsung_bar,"ENTER");
//        samsung_navigation_bar_add_button(samsung_bar,"RETURN");
        _global.game_menu.updateSamsungHelp()
        
    },
    
    doHide: function()
    {
        this.root.style.visibility = "hidden";
        this.rootbg.style.visibility = "hidden";
        this.reset_table();
        for (var i=1; i<6; i++) 
        {
            // Show this players elements
            $("player" + i + "_name").style.visibility = "hidden";
            $("player" + i + "_cards").style.visibility = "hidden"; // May not work due to visibility toggle for each card
			
            $("player" + i + "_name").style.visibility = "hidden";
            $("player" + i + "_scoreboard").style.visibility = "hidden";
            $("player" + i + "_icon").style.visibility = "hidden";
        }
        this.hide_arrow();
    },
    
    keyEventFunction:function (event)
    {
        
        switch(event) 
        {
           

            case "OK":
                _global.hideMessage();

                if (this.is_game_over) {
                    this.reset_table();
                    this.clear_game();
                    _global.show_game_over();
                    return;
                }

                if (this.is_winner) {
                    this.reset_table();
                    this.clear_game();
                    _global.show_winner(this.winning_player_name, this.hand, this.winning_real_player);
                    return;
                }

                if (this.waiting_for_ok) {
                    this.hide_bankrupt_players();
                    this.reset_table();
                    _global.env.GAME.new_hand();
                    this.waiting_for_ok = false;
                }     
                break;
        }
    },
    
    // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*------
    //
    // Functions as specified by the poker GUI template
    //
    // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-----//
    
    community_copy: new Array(),
    community_hidden: true,
    players_copy: null,
    card_count: null,
    waiting_for_ok: true,
    big_blind: 0,
    hand: null,

    winning_player_name: null,
    winning_real_player: null,
    is_winner: null,
    is_game_over: null,

    players_left: null,

    big_blind_player: null,
    small_blind_player: null,
    dealer_player: null,

    bankrupt_players: new Array(),
    
    hide_bankrupt_players: function() {

        for (var i=0; i<this.bankrupt_players.length; i++) {

            var player_index = this.bankrupt_players[i];

            // Hide the cards of this player
            $("player" + player_index + "_name").style.visibility = "hidden";
            $("player" + player_index + "_cards").style.visibility = "hidden";
            $("player" + player_index + "_scoreboard").style.visibility = "hidden";
            $("player" + player_index + "_icon").style.visibility = "hidden";
            /*$("player" + player_index + "_name")._alpha = 40;
            $("player" + player_index + "_scoreboard")._alpha = 40;
            $("player" + player_index + "_icon")._alpha = 40;*/

        }

        this.bankrupt_players = new Array();
    },
    
    get_array_value: function(arr, name) {
        for (var i=0; i<arr.length; i++) {
            if (arr[i][0] == name)
                return arr[i][1];
        }
        return -1;
    },
    
    get_array_index: function(arr, name) {
        for (var i=0; i<arr.length; i++) {
            if (arr[i][0] == name)
                return i;
        }
        return -1;
    },
        
    set_hand: function(hand) {
        //AuPlayer.playSound("http://192.168.1.100/temp/scratch.mp3");
        this.hand = hand;
    },
    
    set_winners: function(players, winning_hand) {

       // AuPlayer.playSound("http://192.168.1.100/temp/winner.mp3");
                           if(_global.skip == false){

                                AuPlayer.playSoundRelative("sound/winner.mp3");
                           }

        // Clear state for each player
        for (var i=0; i<this.players_copy.length; i++) {
            $("player" + (i+1) + "_state").setText("");
        }


        var unfolded_amount = _global.env.GAME.get_nr_unfolded_players();



        // More than one player have won. Show a message indicating
        // between which players the pot is split
        if (players.length > 1) 
        {
            var message = locale[lang]["gameScreen the pot is split between"][0];
            for (var p=0; p<players.length; p++) 
            {
                if (p>0) 
                {
                    if (p == (players.length-1))
                        message += locale[lang]["gameScreen the pot is split between"][1]
                    else
                        message += ", "
                }
                message += players[p].name;
            }
            message += locale[lang]["gameScreen the pot is split between"][2];

            var request_message = locale[lang]["gameScreen press ok for the next hand"];

            if (this.is_game_over || this.is_winner)
            {
                request_message = locale[lang]["gameScreen press ok to continue"];
            }
            
            _global.showMessage(message, request_message);
        }



        // Show the winning hand for the winning players
        for (var p=0; p<players.length; p++) {

            var player_index = 1+this.get_array_index(this.players_copy, players[p].name);

            // Set label to hand, but only if there are other unfolded players
            if ( (unfolded_amount > 1) || (player_index == 1) ) {

                var new_st = "";
                if (winning_hand == "Nothing")
                   // new_st = "High Card";
                       new_st = locale[lang]["gameScreen highcard"];
                else
                    new_st = winning_hand;

                $("player" + player_index + "_state").setText(new_st+"!");
            } else {
                $("player" + player_index + "_state").setText(locale[lang]["gameScreen winner"]);
            }

            $("player" + player_index + "_state").setTextFormat(_global.winningHandFormat);

        }


        for (var p=0; p<_global.env.GAME.players.length; p++) {
            // Show hand, but only if needed
            if (_global.env.GAME.should_player_show_cards(_global.env.GAME.players[p]) == true) {
                this.show_player_cards(_global.env.GAME.players[p]);
            }
        }

    },
    
    show_player_cards: function(player) {
       // AuPlayer.playSound("http://192.168.1.100/temp/turncards.mp3");
        var player_index = 1+this.get_array_index(this.players_copy, player.name);
        var card_root 	= "player" + player_index + "_cards";
        var card_count	= this.players_copy[player_index-1][1];

        if ($(card_root + "_card_0_back").style.visibility == "visible") { //Are the cards face down?

            for (var i=0; i<card_count; i++) {
                $(card_root + "_card_" + i + "_back").style.visibility 	= "hidden";
                $(card_root + "_card_" + i).style.visibility		= "visible";
            }

            // Make cards larger (if not MOXI player)
            if (player_index != 1) {
                /*card_root._xscale = this.large_card_scale;
                  card_root._yscale = this.large_card_scale;*/
            }
        }
    },
        
    set_big_blind_amount: function(amount) {
        if (amount != this.big_blind) {
            this.big_blind = amount;
            _global.blinkMessage(locale[lang]["gameScreen new big blind"] + amount);
        }

        $("big_blind_amount").setText(locale[lang]["gameScreen big blind"] + amount);
        $("big_blind_amount").setTextFormat(_global.playerStateFormat);
    },

    set_small_blind_amount: function (amount) {
        $("small_blind_amount").setText(locale[lang]["gameScreen small blind"] + amount);
        $("small_blind_amount").setTextFormat(_global.playerStateFormat);
    },


    get_blind_pos: function (player) {
        var player_index = 1+this.get_array_index(this.players_copy, player.name);

        switch (player_index) {
            case 1:
                return new Array(280, 420+50);
                break;
            case 2:
                return new Array(180-30, 335);
                break;
            case 3:
                return new Array(160-10, 200+20);
                break;
            case 4:
                return new Array(545-50, 200+20);
                break;
            case 5:
                return new Array(465+30, 355-20);
                break;
        }
    },

    set_dealer: function (player) {
        var pos = this.get_blind_pos(player);
        this.dealer_player = player;

        var dest_x = pos[0];
        var dest_y = pos[1];
        if ( (this.dealer_player == this.big_blind_player) || (this.dealer_player == this.small_blind_player) ) {
            var player_index = 1+this.get_array_index(this.players_copy, player.name);
            var offset = 25;
            switch (player_index) {
                case 1:
                    dest_y -= offset;
                    break;
                case 2:
                    dest_x += offset;
                    break;
                case 3:
                    dest_x += offset;
                    break;
                case 4:
                    dest_x -= offset;
                    break;
                case 5:
                    dest_x -= offset;
                    break;
            }
        }

        $("dealer_knob").style.left = dest_x;
        $("dealer_knob").style.top = dest_y;
    },

    set_big_blind: function (player) {
        var pos = this.get_blind_pos(player);
        this.big_blind_player = player;

        $("big_blind").style.left = pos[0];
        $("big_blind").style.top = pos[1];
		
    },

    set_small_blind: function (player) {
        var pos = this.get_blind_pos(player);
        this.small_blind_player = player;

        $("small_blind").style.left = pos[0];
        $("small_blind").style.top = pos[1];
		
    },

    set_current_player: function (player) {
        var player_index = 1+this.get_array_index(this.players_copy, player.name);

        var dest_x = parseInt($("player"+player_index+"_name").style.left) - 28;
        var dest_y = parseInt($("player"+player_index+"_name").style.top) + 5;

        $("current_player_arrow").style.visibility = "visible";
        $("current_player_arrow").style.left = dest_x;
        $("current_player_arrow").style.top = dest_y;
		
    },

    hide_arrow: function () {
        $("current_player_arrow").style.left		= 0;
        $("current_player_arrow").style.top		= 0;
        $("current_player_arrow").style.visibility 	= "hidden";
    },

    set_bet: function (player) {
        var player_index = 1+this.get_array_index(this.players_copy, player.name);
        $("player"+player_index+"_scoreboard_bet").setText("$" + player.bet[_global.env.GAME.round]);
        $("player"+player_index+"_scoreboard_bet").setTextFormat(_global.scoreboardFormat);
    },

    set_cash: function (player) {
        var player_index = 1+this.get_array_index(this.players_copy, player.name);

        $("player"+player_index+"_scoreboard_cash").setText("$" + player.cash);
        $("player"+player_index+"_scoreboard_cash").setTextFormat(_global.scoreboardFormat);
    },

    set_state: function (player) {

        var player_index = 1+this.get_array_index(this.players_copy, player.name);


        // Make folded player hands somewhat transparent
        if (player.state == "FOLD") {
            //AuPlayer.playSound("http://192.168.1.100/temp/fold.mp3");
                                if(_global.skip == false){

                                    AuPlayer.playSoundRelative("sound/fold.mp3");
                                }
            var card_root = "player" + player_index + "_cards";

            $(card_root).style.left = this.card_positions[player_index-1]["folded"][0];
            $(card_root).style.top = this.card_positions[player_index-1]["folded"][1];

            //card_root._alpha = 50;
            for(var i = 0; i< player.deck.cards.length; i++)
            {
                if($(card_root+"_card_"+i) != null && $(card_root+"_card_"+i+"_back") != null)
                {
                    $(card_root+"_card_"+i).src = "img/card_img_fold_"+_global.env.CARD_WIDTH+"x"+_global.env.CARD_HEIGHT+"/"+player.deck.cards[i].get_symbol()+".png";



                    $(card_root+"_card_"+i+"_back").src = "img/card_img_fold_"+_global.env.CARD_WIDTH+"x"+_global.env.CARD_HEIGHT+"/"+player.deck.cards[i].get_back_symbol()+".png";

                    if(player_index-1 != 0)
                    {
                        var card_width = Math.round(_global.env.CARD_WIDTH * _global.env.FOLD_CARD_SCALE_FACTOR);
                        var card_height = Math.round(_global.env.CARD_HEIGHT * _global.env.FOLD_CARD_SCALE_FACTOR);

                        $(card_root + "_card_" + i + "_back").style.width = card_width;
                        $(card_root + "_card_" + i + "_back").style.height = card_height;

                        $(card_root + "_card_" + i).style.width = card_width;
                        $(card_root + "_card_" + i).style.height = card_height;

                        if(i == 1)
                        {
                            $(card_root + "_card_" + i + "_back").style.left = parseInt($(card_root + "_card_0_back").style.left) + card_width;
                            $(card_root + "_card_" + i).style.left = parseInt($(card_root + "_card_0").style.left) + card_width;
                        }
                    }
                }
            }

           // $("player" + player_index + "_state").setText(player.state);
           $("player" + player_index + "_state").setText(locale[lang]["gameScreen fold"]);
            $("player" + player_index + "_state").setTextFormat(_global.foldFormat);


        } else {

            //var card_root = this.root["player" + player_index + "_cards"];
            if (player.state == "BANKRUPT") {

                this.bankrupt_players.push(player_index);

                if (player_index==1)
                    this.is_game_over = true;

            }

            if (player.state != "WAITING") {
               // $("player" + player_index + "_state").setText(player.state);
               switch(player.state){
                    case "ALL-IN" :
                            $("player" + player_index + "_state").setText(locale[lang]["gameScreen all in"]);
                    break;
                    case "CALL" :
                            $("player" + player_index + "_state").setText(locale[lang]["gameScreen call"]);
                    break;
                    case "CHECK" :
                            $("player" + player_index + "_state").setText(locale[lang]["gameScreen check"]);
                    break;
                    case "RAISE" :
                            $("player" + player_index + "_state").setText(locale[lang]["gameScreen raise"]);
                    break;
                    case "BET" :
                            $("player" + player_index + "_state").setText(locale[lang]["gameScreen bet"]);
                    break;
               }
            } else {
                
                $("player" + player_index + "_state").setText("");
            }
            $("player" + player_index + "_state").setTextFormat(_global.playerStateFormat);
        }

    },

    set_deck: function (player, deck) {
           
        var player_index = this.get_array_index(this.players_copy, player.name);
        var card_root = "player" + (player_index+1) + "_cards";

        // Make sure that the cards are not transparent
        //card_root._alpha = 100;

        // Remove previous cards
        for (var i=0; i<10; i++) {
            if (typeof $(card_root+"_card_" + i) != "undefined") {
                removeElement($(card_root+"_card_" + i));
                removeElement($(card_root+"_card_" + i + "_back"));
            }
        }
        this.players_copy[player_index][1] = 0;

        // Add new cards
        for (var i=0; i<deck.cards.length; i++) {
            this.add_to_deck(player, deck.cards[i]);
        }
    },

    add_to_deck: function (player, _card) {
       
        var player_index 	= this.get_array_index(this.players_copy, player.name);
        var card_root 		= "player" + (player_index+1) + "_cards";
        var card_count		= this.players_copy[player_index][1];

        $(card_root).appendChild(
        createImage(
        "img/card_img_"+_global.env.CARD_WIDTH+"x"+_global.env.CARD_HEIGHT+"/"+_card.get_symbol()+".png", 
        card_root + "_card_" + card_count, 
        {"position": "absolute"}
    ));
                            
        $(card_root).appendChild(
        createImage(
        "img/card_img_"+_global.env.CARD_WIDTH+"x"+_global.env.CARD_HEIGHT+"/"+_card.get_back_symbol()+".png", 
        card_root + "_card_" + card_count + "_back", 
        {"position": "absolute"}
    ));

        $(card_root + "_card_" + card_count).style.left = card_count * _global.env.CARD_WIDTH; //parseInt($(card_root + "_card_" + card_count).style.width);
        $(card_root + "_card_" + card_count + "_back").style.left = parseInt($(card_root + "_card_" + card_count).style.left);

        this.players_copy[player_index][1] = card_count+1;

        if (player_index != 0) { //This is not the MOXI player, hide the card
            $(card_root + "_card_" + card_count + "_back").style.visibility = "visible";
            $(card_root + "_card_" + card_count).style.visibility = "hidden";
            
            var card_width = Math.round(_global.env.CARD_WIDTH * _global.env.OPPONENT_CARD_SCALE_FACTOR);
            var card_height = Math.round(_global.env.CARD_HEIGHT* _global.env.OPPONENT_CARD_SCALE_FACTOR);
            
            
            $(card_root + "_card_" + card_count + "_back").style.width = card_width;
            $(card_root + "_card_" + card_count + "_back").style.height = card_height;
            
            $(card_root + "_card_" + card_count).style.width = card_width;
            $(card_root + "_card_" + card_count).style.height = card_height;
            
            if(card_count == 1)
            {
                $(card_root + "_card_" + card_count + "_back").style.left = parseInt($(card_root + "_card_0_back").style.left) + card_width;
                $(card_root + "_card_" + card_count).style.left = parseInt($(card_root + "_card_0").style.left) + card_width;
            }
            
        } else {
            $(card_root + "_card_" + card_count + "_back").style.visibility = "hidden";
            $(card_root + "_card_" + card_count).style.visibility = "visible";
            
        }
    },
        
    set_community: function (deck) {

        for (var i=0; i<this.community_copy.length; i++) {
            removeElement($("community_" + i));
            removeElement($("community_" + i + "_back"));
        }

        this.community_copy = new Array();

        if (deck) {
            for (var i=0; i<deck.cards.length; i++) {
                this.add_to_community(deck.cards[i]);
            }
        }
    },

    add_to_community: function (_card) 
    {
             //AuPlayer.playSound("http://192.168.1.100/temp/deal7.mp3");
             //AuPlayer.playSoundRelative("sound/deal7.mp3");
        var c  = this.root.appendChild(createImage("img/card_img_"+_global.env.CARD_WIDTH+"x"+_global.env.CARD_HEIGHT+"/"+_card.get_symbol()+".png", "community_" + this.community_copy.length, {"position":"absolute"}));
        var cb = this.root.appendChild(createImage("img/card_img_"+_global.env.CARD_WIDTH+"x"+_global.env.CARD_HEIGHT+"/"+_card.get_back_symbol()+".png", "community_" + this.community_copy.length + "_back", {"position":"absolute"}));

        this.community_copy.push(_card);

        if (this.community_hidden) {
            c.style.visibility = "hidden";
            cb.style.visibility = "visible";
        } else {
            c.style.visibility = "visible";
            cb.style.visibility = "hidden";
        }

        var dest_x = Math.round(Stage.width/2 + this.community_copy.length * _global.env.CARD_WIDTH - 3.5*_global.env.CARD_WIDTH) -120;
        var dest_y = Math.round(Stage.height/2 - _global.env.CARD_HEIGHT + 60);


        c.style.left = dest_x;
        c.style.top = dest_y;

        cb.style.left = dest_x;
        cb.style.top = dest_y;

		

    },

    hide_community: function () {


        this.community_hidden = true;
        for (var i=0; i<this.community_copy.length; i++) {
            $("community_" + i).style.visibility = "hidden";
            $("community_" + i + "_back").style.visibility = "visible";
        }
    },

    show_community: function () {
    //AuPlayer.playSound("http://192.168.1.100/temp/turncards.mp3");
                        if(_global.skip == false){

    AuPlayer.playSoundRelative("sound/turncards.mp3");
                        }
        this.community_hidden = false;
        for (var i=0; i<this.community_copy.length; i++) {
            $("community_" + i).style.visibility = "visible";
            $("community_" + i + "_back").style.visibility = "hidden";
        }
    },

    add_player: function (player) {
        this.players_copy.push(new Array(player.name, 0));

        // Set name
        $("player" + this.players_copy.length + "_name").setText(player.name);
        $("player" + this.players_copy.length + "_name").setTextFormat(_global.nameFormat);

        // Set icon
        var icon_url = _global.get_icon(player.name);
        $("player" + this.players_copy.length + "_icon").src = icon_url;

        this.players_left++;
    },

    remove_player: function (player) {
    },

    ready_for_new_hand: function () {

        var request_message = locale[lang]["gameScreen press ok for the next hand"];

        if (this.is_game_over || this.is_winner)
            request_message = locale[lang]["gameScreen press ok to continue"];


        if (!_global.showingMessage) {
            var left_in_game = _global.env.GAME.get_nr_players_left();
            if (left_in_game < this.players_left) {
                var diff = this.players_left - left_in_game;
                this.players_left = left_in_game;

                var diff_str = "";
                if (diff == 1) {
                    diff_str = locale[lang]["gameScreen 1 player just went bankrupt"];
                } else {
                    diff_str = diff+ locale[lang]["gameScreen X players just went bankrupt"]
                }

                _global.showMessage(diff_str + "" +locale[lang]["gameScreen X players left in game"][0] + this.players_left + locale[lang]["gameScreen X players left in game"][1], request_message)
            } else {
                _global.showMessage(request_message);
            }
        }

        this.waiting_for_ok = true;
    },

    clear_game: function () {

        for (var p=0; p<this.players_copy.length; p++) {
            var player = _global.env.GAME.get_player_by_name(this.players_copy[p][0]);
            this.set_deck(player, new Deck());
        }

    },

    reset_table: function () 
    {
        this.set_community(null);
        if(this.players_copy != null)
        {
            for (var p=0; p<this.players_copy.length; p++) {

                var card_root = "player" + (p+1) + "_cards";

                // Remove cards
                for (var i=0; i<10; i++) {
                    if (typeof $(card_root+ "_card_" + i) != "undefined") 
                    {
                        removeElement($(card_root+ "_card_" + i));
                        removeElement($(card_root+ "_card_" + i + "_back"));
                    }
                }
                this.players_copy[p][1] = 0;

                // Move card root into playing position
                $(card_root).style.left = this.card_positions[p]["playing"][0];
                $(card_root).style.top = this.card_positions[p]["playing"][1];

                // Set label
                $("player" + (p+1) + "_state").setText("");

                // Show hand
                //card_root._alpha = 100;
                /*if (p == 0) 
                {
                    card_root._xscale = this.large_card_scale;
                    card_root._yscale = this.large_card_scale;
                } 
                else 
                {
                    card_root._xscale = this.small_card_scale;
                    card_root._yscale = this.small_card_scale;
                }*/
            }
        }

    },

    set_pot: function (pot) {
        $("pot_size").setText(locale[lang]["gameScreen current pot"]+ pot);
        $("pot_size").setTextFormat(_global.messageFormat);
    },

    game_over: function (winning_player) {
        this.is_winner		 = true;
        this.winning_player_name = winning_player.name;
        this.winning_real_player	 = (this.get_array_index(this.players_copy, winning_player.name) == 0);

    },

    init: function () {

        this.bankrupt_players = new Array();

        this.big_blind = 0;
        this.players_left = 0;
        this.is_game_over = false;
        this.is_winner = false;
        this.waiting_for_ok = false;

        this.set_community();
        this.hide_community();

        this.players_copy = new Array();
        this.community_copy = new Array();
        this.card_count = new Array();

        for (var i=1; i<6; i++) {
            // Show this players elements
            $("player" + i + "_name").style.visibility = "visible";
            $("player" + i + "_cards").style.visibility = "visible";
			
            $("player" + i + "_name").style.visibility = "visible";
            $("player" + i + "_scoreboard").style.visibility = "visible";
            $("player" + i + "_icon").style.visibility = "visible";

            /*$("player" + i + "_name")._alpha = 100;
			$("player" + i + "_scoreboard")._alpha = 100;
			$("player" + i + "_icon")._alpha = 100;*/
        }
    }
    
    
}