function WinnerScreen(parent)
{
    this.env = _global.env;
    parent.appendChild(createFrame("winnerscreen",
                    {   "visibility":"hidden",
                        "width":Stage.width, 
                        "height": Stage.height,
                        "backgroundImage":"url('img/background_charsel.jpg')",
                        "position":"absolute", "top":0, "left":0
                    }));
    this.root = $("winnerscreen");
    
    //Background Image
    //this.root.appendChild(createImage("images/background_charsel.jpg", "bg_winner", {"position":"absolute", "top":0, "left":0}));
   
    // The winner player
    this.root.appendChild(createImage("img/blank.gif","winner_character", {"position":"absolute", "width": _global.env.BIG_CHAR_IMAGE_WIDTH, "height": _global.env.BIG_CHAR_IMAGE_HEIGHT}));

    // The header label
    this.root.appendChild(createTextField("winner_header", 75-20, 100-50, 450, 500));

    // The additional header label
    this.root.appendChild(createTextField("winner_additional_header", 370-120, Stage.height-100, 300, 100));
}

WinnerScreen.prototype = 
    {
    set_winner: function(character, winning_round, is_player) 
    {
        this.winner         = character;
        this.winning_round  = winning_round;
        this.is_player      = is_player;
    },
    doShow: function()
    {
        this.root.style.visibility = "visible";
        $("winner_character").src = this.winner[1];
        $("winner_character").style.left = Math.round(Stage.width/2 - _global.env.BIG_CHAR_IMAGE_WIDTH/2)+150;
	$("winner_character").style.top = 100-36;
        
        var level = "";
        if (this.winning_round <= 10)
            level = locale[lang]["winnerScreen poker shark"];
        else if (this.winning_round <= 20)
            level = locale[lang]["winnerScreen poker master"];
        else if (this.winning_round <= 30)
            level = locale[lang]["winnerScreen poker star"];
        else if (this.winning_round <= 40)
            level = locale[lang]["winnerScreen poker hero"];
        else
            level = locale[lang]["winnerScreen poker fish"];


        if (this.is_player)
            $("winner_header").setText(locale[lang]["winnerScreen congratuation"][0] + this.winning_round + locale[lang]["winnerScreen congratuation"][1] + level + locale[lang]["winnerScreen congratuation"][2]);
        else
            $("winner_header").setText("The winner is");

        $("winner_header").setTextFormat(_global.headerFormat);
        $("winner_additional_header").setText(locale[lang]["winnerScreen press ok to continue"]);
        $("winner_additional_header").setTextFormat(_global.messageFormat);

        var samsung_bar = document.getElementById("samsung_navigation_bar");
        samsung_navigation_bar_clear_bar(samsung_bar);
       // samsung_navigation_bar_add_button(samsung_bar,"LEFTRIGHT");
        samsung_navigation_bar_add_button(samsung_bar,"ENTER");
        samsung_navigation_bar_add_button(samsung_bar,"RETURN");
    },
    
    doHide: function()
    {
        this.root.style.visibility = "hidden";
    },
    
    keyEventFunction:function (event)
    {
        
        if (event == "OK") {
            _global.show_front();
        }
    }
}
