var ButtonHandler = {
    
    create_button: function(buttonName, buttonLabel, selectedImage, unselectedImage, parent, x, y, width, height)
    {
        var obj = createFrame(buttonName, {"position":"absolute", "top":y,"left":x,"width":width,"height":height});
        parent.appendChild(obj);
        
        // Using same idea that Lumexis gave us = storing data in DOM object by extending it
        obj.texasSelectedImage = selectedImage;
        obj.texasUnselectedImage = unselectedImage;
        
        obj.appendChild(createImage(unselectedImage, buttonName+"_img", {"width":width,"height":height,"top":0,"left":0}));
  
        //Add label handler later
        obj.appendChild(createTextField(buttonName+"_labelfield", 0, Math.round(height/2)-11+3, width, height));
        $(buttonName+"_labelfield").setText(buttonLabel);
        
        //Unselect it
        ButtonHandler.unselect_button(obj);
        
        return obj;
    },
    
    select_button:function (buttonRef)
    {
        var obj = $(buttonRef);
        
        $(obj.id+"_img").src = obj.texasSelectedImage;
        $(obj.id+"_labelfield").setTextFormat(_global.menuSelectedFormat);
    },
    
    unselect_button:function (buttonRef)
    {
        var obj = $(buttonRef);
        $(obj.id+"_img").src = obj.texasUnselectedImage;
        $(obj.id+"_labelfield").setTextFormat(_global.menuUnselectedFormat);
    },
    
    hide_button: function (buttonRef)
    {
        $(buttonRef).style.visibility = "hidden";
    },
    
    show_button: function (buttonRef)
    {
        $(buttonRef).style.visibility = "visible";
    },
    
    set_text: function (buttonRef, text)
    {
        var obj = $(buttonRef);
        //$(obj.id+"_img").src = obj.texasUnselectedImage;
        $(obj.id+"_labelfield").setText(text);
    }
}