/*Navigation Description bar specially build for Samsung TV
 *
 *as requested by Samsung TV Internet@TV Navigation Guidelines, a navigation help area is required
 *
 *Basically, a bar is needed to place at the bottom of the widget and the instruction must be aligned to the right hand side
 *
 *A standardised measure is made to handle the navigation help issue
 *so that all the Accedo games would have standardised navigation help
 *without the re-generating the graphic files
 *
 *Here is the steps to add the navigation help bar.
 *
 *  1. put the path of the folder containing the image file in the variable samsung_image_path
 *
 *  2. put an empty <div> tag in the html
 *
 *  3. include this javascript file in the html
 *
 *  4. in the onLoad/init function, put on the following code:
 *
 *  var samsung_bar = samsung_navigation_bar([div element id],[left],[top],[width],[height],[border width in the format like "1px"],[background color],[border color]);
     samsung_navigation_bar_add_button(samsung_bar,[navigation instruction to include e.g. "ENTER"]);

 *
 *
 *
 */


var samsung_image_path = "img/samsung/" //config this path to the navigation images

function samsung_navigation_bar(elementId,bar_x,bar_y,bar_width,bar_height,border,bgcolor,bordercolor){



   // var obj = document.createElement("div");
   // document.getElementById("samsung_navigation_bar").appendChild(obj);
var obj = document.getElementById(elementId); //link the div element created in the html
    
    styles = {     "visibility":"visible",
                        "width":bar_width-20+120,//modified for texas holdem
                       "height": bar_height,
                     "position":"absolute",
                    
                          "top":bar_y-10,
                         "left":bar_x-60,
                         
                         "backgroundColor": bgcolor,
                        
                        "textAlign": "right",
                        "verticalAlign":"center",
                        "color" : "#FFFFFF",
                        "paddingTop":2,
                        "paddingBottom":0,
                        "paddingRight":50,//modified for texas holdem

                         "outline":1,
                         "outlineColor":bordercolor,
                         "outlineStyle":"solid",
                         "outlineWidth":border

                    }
    
    for (var property in styles)
        {
            obj.style[property] = styles[property];
        }

    return obj;
}

function samsung_navigation_bar_add_button(obj,button){



    switch(button){

        case "RETURN":
          obj.innerHTML +=  "<img src='"+samsung_image_path+"blank.gif' width='15'>"+"<img src='"+samsung_image_path+"help_back.png' style='vertical-align:-45%;'>"  +" "+ locale[lang]["navigation help return"];
        break;
        case "ENTER":
          obj.innerHTML += "<img src='"+samsung_image_path+"blank.gif' width='15'>"+"<img src='"+samsung_image_path+"help_enter.png'  style='vertical-align:-45%;'>" +" "+ locale[lang]["navigation help enter"];
        break;
        case "MOVE":
          obj.innerHTML += "<img src='"+samsung_image_path+"blank.gif' width='15'>"+"<img src='"+samsung_image_path+"help_move.png' style='vertical-align:-45%;'>" +" "+ locale[lang]["navigation help move"];
        break;
        case "MOVELEFT":
          obj.innerHTML += "<img src='"+samsung_image_path+"blank.gif' width='15'>"+"<img src='"+samsung_image_path+"help_move_left.png' style='vertical-align:-45%;'>" +" "+ locale[lang]["navigation help move"];
        break;
        case "MOVERIGHT":
          obj.innerHTML += "<img src='"+samsung_image_path+"blank.gif' width='15'>"+"<img src='"+samsung_image_path+"help_move_right.png' style='vertical-align:-45%;'>" +" "+ locale[lang]["navigation help move"];
        break;
        case "LEFTRIGHT":
          obj.innerHTML += "<img src='"+samsung_image_path+"blank.gif' width='15'>"+"<img src='"+samsung_image_path+"help_lr.png' style='vertical-align:-45%;'>" +" "+ locale[lang]["navigation help move"];
        break;
        case "LEFT":
          obj.innerHTML += "<img src='"+samsung_image_path+"blank.gif' width='15'>"+"<img src='"+samsung_image_path+"help_left.png' style='vertical-align:-45%;'>" +" "+ locale[lang]["navigation help move"];
        break;
        case "RIGHT":
          obj.innerHTML += "<img src='"+samsung_image_path+"blank.gif' width='15'>"+"<img src='"+samsung_image_path+"help_right.png' style='vertical-align:-45%;'>" +" "+ locale[lang]["navigation help move"];
        break;
        case "UPDOWN":
          obj.innerHTML += "<img src='"+samsung_image_path+"blank.gif' width='15'>"+"<img src='"+samsung_image_path+"help_ud.png' style='vertical-align:-45%;'>" +" "+ locale[lang]["navigation help move"];
        break;


    }

}

function samsung_navigation_bar_clear_bar(obj){

    obj.innerHTML = "";

}